/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.net.connect;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.passage.lic.internal.base.io.LicensingFolder;
import org.eclipse.passage.lic.internal.base.io.UserHomePath;
import org.eclipse.passage.lic.internal.net.connect.CliParameter;

public final class Storage
extends CliParameter<Path> {
    public Storage() {
        super(new LicensingFolder((Supplier)new UserHomePath()).get());
    }

    public Storage(Path lazy) {
        super(lazy);
    }

    public Storage(String[] sources, Path lazy) {
        super(sources, lazy);
    }

    public String key() {
        return "server.storage";
    }

    @Override
    protected Optional<Path> parse(String value) {
        boolean created;
        Path path = Paths.get(value, new String[0]);
        if (!Files.exists(path, new LinkOption[0]) && !(created = path.toFile().mkdirs())) {
            this.log.error(String.format("Failed to create absent license storage directory %s", path.toAbsolutePath()));
            return Optional.empty();
        }
        if (!Files.isDirectory(path, new LinkOption[0])) {
            this.log.error(String.format("License storage must be a directory: %s ", path.toAbsolutePath()));
            return Optional.empty();
        }
        if (!Files.isExecutable(path)) {
            this.log.error(String.format("Lack of access rights - directory is not executable: %s ", path.toAbsolutePath()));
            return Optional.empty();
        }
        return Optional.of(path);
    }
}

