/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.jetty.interaction;

import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.passage.lic.internal.api.LicensedProduct;
import org.eclipse.passage.lic.internal.api.LicensingException;
import org.eclipse.passage.lic.internal.api.ServiceInvocationResult;
import org.eclipse.passage.lic.internal.api.access.GrantLockAttempt;
import org.eclipse.passage.lic.internal.api.restrictions.ExaminationCertificate;
import org.eclipse.passage.lic.internal.base.diagnostic.DiagnosticExplained;
import org.eclipse.passage.lic.internal.base.restrictions.CertificateWorthAttention;
import org.eclipse.passage.lic.internal.equinox.EquinoxPassage;
import org.eclipse.passage.lic.internal.equinox.LicensedApplication;
import org.eclipse.passage.lic.internal.jetty.interaction.RequirementsLicensingStatusExplained;

final class LicenseProtection {
    private final Logger log = LogManager.getLogger(this.getClass());
    private Optional<GrantLockAttempt> lock = Optional.empty();

    LicenseProtection() {
    }

    boolean check() {
        this.lock = this.acquireLicense();
        if (!this.lock.isPresent()) {
            return false;
        }
        if (!this.lock.get().successful()) {
            return false;
        }
        ExaminationCertificate certificate = this.lock.get().certificate();
        if (new CertificateWorthAttention().test(Optional.of(certificate))) {
            this.log.error(String.format("\n---\n%s\n---\n", new RequirementsLicensingStatusExplained(certificate).get()));
        }
        return true;
    }

    void release() {
        this.lock.ifPresent(acq -> {
            ServiceInvocationResult serviceInvocationResult = new EquinoxPassage().releaseLicense(acq);
        });
    }

    private Optional<GrantLockAttempt> acquireLicense() {
        return this.product().flatMap(this::acquireLicense);
    }

    private Optional<LicensedProduct> product() {
        try {
            return Optional.of(new LicensedApplication().product());
        }
        catch (LicensingException e) {
            this.log.error("Failed to read product credentials", (Throwable)e);
            return Optional.empty();
        }
    }

    private Optional<GrantLockAttempt> acquireLicense(LicensedProduct product) {
        ServiceInvocationResult response = new EquinoxPassage().acquireLicense(product.identifier());
        if (!this.successful((ServiceInvocationResult<GrantLockAttempt>)response)) {
            this.log.error(String.format("Failed to acquire license \nfor product %s:\n%s\n", product, new DiagnosticExplained(response.diagnostic()).get()));
            return Optional.empty();
        }
        return Optional.of((GrantLockAttempt)response.data().get());
    }

    private boolean successful(ServiceInvocationResult<GrantLockAttempt> response) {
        return response.data().map(GrantLockAttempt::successful).orElse(Boolean.FALSE);
    }
}

