/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.jface.dialogs.licensing;

import java.util.Optional;
import java.util.function.Consumer;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.passage.lic.internal.api.restrictions.ExaminationCertificate;
import org.eclipse.passage.lic.internal.base.restrictions.CertificateIsRestrictive;
import org.eclipse.passage.lic.internal.base.restrictions.CertificateWorthAttention;
import org.eclipse.passage.lic.internal.jface.i18n.LicenseStatusDialogMessages;

final class CertificateSummary
implements Consumer<TitleAreaDialog> {
    private final Optional<ExaminationCertificate> certificate;

    CertificateSummary(ExaminationCertificate certificate) {
        this(Optional.of(certificate));
    }

    CertificateSummary(Optional<ExaminationCertificate> certificate) {
        this.certificate = certificate;
    }

    @Override
    public void accept(TitleAreaDialog dialog) {
        if (new CertificateIsRestrictive().test(this.certificate)) {
            dialog.setMessage(LicenseStatusDialogMessages.WithCertificatSummary_error, 3);
            return;
        }
        if (new CertificateWorthAttention().test(this.certificate)) {
            dialog.setMessage(LicenseStatusDialogMessages.WithCertificatSummary_warning, 2);
            return;
        }
        dialog.setMessage(LicenseStatusDialogMessages.WithCertificatSummary_ok, 0);
    }
}

