/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.jetty;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.passage.lic.internal.jetty.JettyException;
import org.eclipse.passage.lic.internal.jetty.JettyHandler;
import org.eclipse.passage.lic.internal.jetty.i18n.Messages;
import org.eclipse.passage.lic.internal.net.connect.Port;

public final class JettyServer {
    private final Logger log = LogManager.getLogger(this.getClass());
    private final Supplier<JettyHandler> handler;
    private Optional<Server> server = Optional.empty();

    public JettyServer(Supplier<JettyHandler> handler) {
        Objects.requireNonNull(handler, "JettyServer::handler");
        this.handler = handler;
    }

    public void launch(Port port) throws JettyException {
        try {
            this.server = Optional.of(new Server(((Integer)port.get().get()).intValue()));
            this.server.get().setHandler((Handler)this.handler.get());
            this.server.get().start();
            this.log.info(String.format(Messages.started, port.get().get()));
        }
        catch (Exception e) {
            this.logAndRethrow(e, Messages.error_onstart);
        }
    }

    public void terminate() throws JettyException {
        try {
            if (this.server.isPresent()) {
                this.server.get().stop();
            }
            this.log.info(String.format(Messages.stopped, new Object[0]));
        }
        catch (Exception e) {
            this.logAndRethrow(e, Messages.error_onstop);
        }
    }

    public String state() throws JettyException {
        block3: {
            try {
                if (this.server.isPresent()) break block3;
                return "NOT LAUNCHED";
            }
            catch (Exception e) {
                throw new JettyException(Messages.error_onstate, e);
            }
        }
        return this.server.get().getState();
    }

    private void logAndRethrow(Exception e, String template) throws JettyException {
        String message = String.format(template, e.getClass(), e.getMessage());
        this.log.error(message, (Throwable)e);
        throw new JettyException(message, e);
    }
}

