/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.licenses.edit.providers;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.passage.lic.licenses.edit.GetOrUnknown;
import org.eclipse.passage.lic.licenses.edit.LicensesEditPlugin;
import org.eclipse.passage.lic.licenses.model.api.FeatureRef;
import org.eclipse.passage.lic.licenses.model.api.PersonalFeatureGrant;
import org.eclipse.passage.lic.licenses.model.api.ValidityPeriodClosed;
import org.eclipse.passage.lic.licenses.model.api.VersionMatch;
import org.eclipse.passage.lic.licenses.model.meta.LicensesFactory;
import org.eclipse.passage.lic.licenses.model.meta.LicensesPackage;

public class PersonalFeatureGrantItemProvider
extends ItemProviderAdapter
implements IEditingDomainItemProvider,
IStructuredItemContentProvider,
ITreeItemContentProvider,
IItemLabelProvider,
IItemPropertySource {
    public PersonalFeatureGrantItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addIdentifierPropertyDescriptor(object);
            this.addCapacityPropertyDescriptor(object);
            this.addVividPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addIdentifierPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_PersonalFeatureGrant_identifier_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_PersonalFeatureGrant_identifier_feature", "_UI_PersonalFeatureGrant_type"), (EStructuralFeature)LicensesPackage.eINSTANCE.getPersonalFeatureGrant_Identifier(), true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addCapacityPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_PersonalFeatureGrant_capacity_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_PersonalFeatureGrant_capacity_feature", "_UI_PersonalFeatureGrant_type"), (EStructuralFeature)LicensesPackage.eINSTANCE.getPersonalFeatureGrant_Capacity(), true, false, false, ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE, null, null));
    }

    protected void addVividPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_PersonalFeatureGrant_vivid_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_PersonalFeatureGrant_vivid_feature", "_UI_PersonalFeatureGrant_type"), (EStructuralFeature)LicensesPackage.eINSTANCE.getPersonalFeatureGrant_Vivid(), true, false, false, ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE, null, null));
    }

    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
        if (this.childrenFeatures == null) {
            super.getChildrenFeatures(object);
            this.childrenFeatures.add(LicensesPackage.eINSTANCE.getPersonalFeatureGrant_Feature());
            this.childrenFeatures.add(LicensesPackage.eINSTANCE.getPersonalFeatureGrant_Valid());
            this.childrenFeatures.add(LicensesPackage.eINSTANCE.getPersonalFeatureGrant_UserAuthentication());
        }
        return this.childrenFeatures;
    }

    protected EStructuralFeature getChildFeature(Object object, Object child) {
        return super.getChildFeature(object, child);
    }

    public Object getImage(Object object) {
        return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/license.png"));
    }

    protected boolean shouldComposeCreationImage() {
        return true;
    }

    public String getText(Object object) {
        Date validUntil;
        String unknownDate;
        String from = unknownDate = String.valueOf('?');
        String until = unknownDate;
        PersonalFeatureGrant grant = (PersonalFeatureGrant)object;
        FeatureRef feature = grant.getFeature();
        String fid = Optional.ofNullable(feature).map(FeatureRef::getIdentifier).orElseGet(new GetOrUnknown());
        String version = Optional.ofNullable(feature).map(FeatureRef::getVersionMatch).map(VersionMatch::getVersion).orElse("0.0.0");
        String rule = Optional.ofNullable(feature).map(FeatureRef::getVersionMatch).map(VersionMatch::getRule).orElse("");
        Date validFrom = ((ValidityPeriodClosed)grant.getValid()).getFrom();
        if (validFrom != null) {
            from = LocalDateTime.ofInstant(validFrom.toInstant(), ZoneId.systemDefault()).toLocalDate().toString();
        }
        if ((validUntil = ((ValidityPeriodClosed)grant.getValid()).getUntil()) != null) {
            until = LocalDateTime.ofInstant(validUntil.toInstant(), ZoneId.systemDefault()).toLocalDate().toString();
        }
        if (!rule.isEmpty()) {
            return this.getString("_UI_LicenseGrant_text_pattern_dates_rules", new Object[]{from, until, fid, version, rule});
        }
        return this.getString("_UI_LicenseGrant_text_pattern_dates", new Object[]{from, until, fid, version});
    }

    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(PersonalFeatureGrant.class)) {
            case 0: 
            case 4: 
            case 5: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
            case 1: 
            case 2: 
            case 3: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, false));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
        newChildDescriptors.add(this.createChildParameter(LicensesPackage.eINSTANCE.getPersonalFeatureGrant_Feature(), LicensesFactory.eINSTANCE.createFeatureRef()));
        newChildDescriptors.add(this.createChildParameter(LicensesPackage.eINSTANCE.getPersonalFeatureGrant_Valid(), LicensesFactory.eINSTANCE.createValidityPeriodClosed()));
        newChildDescriptors.add(this.createChildParameter(LicensesPackage.eINSTANCE.getPersonalFeatureGrant_UserAuthentication(), LicensesFactory.eINSTANCE.createEvaluationInstructions()));
    }

    public ResourceLocator getResourceLocator() {
        return LicensesEditPlugin.INSTANCE;
    }
}

