/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.net.connect;

import java.util.Arrays;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.runtime.Platform;
import org.eclipse.passage.lic.base.NamedData;

public abstract class CliParameter<T>
implements NamedData<T> {
    protected final Logger log = LogManager.getLogger(this.getClass());
    protected final Optional<String> raw;
    private final T lazy;

    public CliParameter(T lazy) {
        this(Platform.getCommandLineArgs(), lazy);
    }

    public CliParameter(String[] sources, T lazy) {
        this.lazy = lazy;
        String prefix = String.format("-%s=", this.key());
        this.raw = Arrays.stream(sources).map(String::toLowerCase).filter(source -> source.startsWith(prefix)).map(source -> source.substring(prefix.length())).findAny();
    }

    public final Optional<T> get() {
        return this.raw.map(this::parse).orElseGet(this::defaultValue);
    }

    protected abstract Optional<T> parse(String var1);

    protected final Optional<T> defaultValue() {
        return Optional.of(this.lazy);
    }
}

