/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.jetty.interaction;

import java.io.InputStream;
import org.eclipse.passage.lic.internal.base.logging.Logging;
import org.eclipse.passage.lic.internal.jetty.JettyHandler;
import org.eclipse.passage.lic.internal.jetty.JettyServer;
import org.eclipse.passage.lic.internal.jetty.interaction.Commands;
import org.eclipse.passage.lic.internal.jetty.interaction.ServerHandles;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public abstract class LicensedJettyActivator
implements BundleActivator {
    private final JettyServer jetty;
    private ServerHandles server;

    public LicensedJettyActivator() {
        this.configureLogging();
        this.jetty = new JettyServer(this::handler);
    }

    public final void start(BundleContext context) throws Exception {
        this.registerCommands(context);
        this.server.start();
    }

    public final void stop(BundleContext context) throws Exception {
        this.server.stop();
    }

    private void configureLogging() {
        new Logging(this::logConfig).configure();
    }

    private void registerCommands(BundleContext context) {
        Commands commands = new Commands();
        commands.register(context, this.jetty, this.name());
        this.server = commands.server();
        this.registerCustomCommands(context);
    }

    protected abstract String name();

    protected abstract JettyHandler handler();

    protected abstract InputStream logConfig() throws Exception;

    protected abstract void registerCustomCommands(BundleContext var1);
}

