/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.bc;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.operator.PBEDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.PGPDataDecryptor;
import org.bouncycastle.openpgp.operator.bc.BcImplProvider;
import org.bouncycastle.openpgp.operator.bc.BcPGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.bc.BcUtil;

public class BcPBEDataDecryptorFactory
extends PBEDataDecryptorFactory {
    public BcPBEDataDecryptorFactory(char[] cArray, BcPGPDigestCalculatorProvider bcPGPDigestCalculatorProvider) {
        super(cArray, bcPGPDigestCalculatorProvider);
    }

    @Override
    public byte[] recoverSessionData(int n, byte[] byArray, byte[] byArray2) throws PGPException {
        try {
            if (byArray2 != null && byArray2.length > 0) {
                BlockCipher blockCipher = BcImplProvider.createBlockCipher(n);
                BufferedBlockCipher bufferedBlockCipher = BcUtil.createSymmetricKeyWrapper(false, blockCipher, byArray, new byte[blockCipher.getBlockSize()]);
                byte[] byArray3 = new byte[byArray2.length];
                int n2 = bufferedBlockCipher.processBytes(byArray2, 0, byArray2.length, byArray3, 0);
                n2 += bufferedBlockCipher.doFinal(byArray3, n2);
                return byArray3;
            }
            byte[] byArray4 = new byte[byArray.length + 1];
            byArray4[0] = (byte)n;
            System.arraycopy(byArray, 0, byArray4, 1, byArray.length);
            return byArray4;
        }
        catch (Exception exception) {
            throw new PGPException("Exception recovering session info", exception);
        }
    }

    @Override
    public PGPDataDecryptor createDataDecryptor(boolean bl, int n, byte[] byArray) throws PGPException {
        BlockCipher blockCipher = BcImplProvider.createBlockCipher(n);
        return BcUtil.createDataDecryptor(bl, blockCipher, byArray);
    }

    @Override
    public PGPDataDecryptor createDataDecryptor(int n, byte[] byArray, int n2, int n3, byte[] byArray2) throws PGPException {
        return BcUtil.createDataDecryptor(n, byArray, n2, n3, byArray2);
    }
}

