/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.emf.xmi;

import java.io.InputStream;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.BasicResourceHandler;
import org.eclipse.emf.ecore.xml.type.AnyType;
import org.eclipse.passage.lic.emf.migration.MigrationException;
import org.eclipse.passage.lic.emf.migration.MigrationRoutes;
import org.eclipse.passage.lic.internal.emf.migration.RecognizeFeatures;

public abstract class MigratingResourceHandler
extends BasicResourceHandler {
    public void preLoad(XMLResource resource, InputStream inputStream, Map<?, ?> options) {
        this.register();
    }

    protected abstract void register();

    public final void postLoad(XMLResource resource, InputStream inputStream, Map<?, ?> options) {
        Set entries = resource.getEObjectToExtensionMap().entrySet();
        for (Map.Entry<EObject, AnyType> entry : entries) {
            try {
                this.convertEntry(entry);
            }
            catch (MigrationException e) {
                String message = Optional.ofNullable(resource.getURI()).map(Object::toString).orElseGet(e::getMessage);
                throw new RuntimeException(message, e);
            }
        }
        this.complete(resource);
        this.evaporizeUnknownParticles(resource);
    }

    private void evaporizeUnknownParticles(XMLResource resource) {
        resource.getEObjectToExtensionMap().clear();
    }

    protected void convertEntry(Map.Entry<EObject, AnyType> entry) throws MigrationException {
        new RecognizeFeatures(entry.getValue(), this.attributes()).apply(entry.getKey());
    }

    protected abstract MigrationRoutes attributes();

    protected abstract void complete(XMLResource var1);
}

