/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lbc.internal.base.mine;

import java.util.Collection;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.passage.lbc.internal.base.EncodedResponse;
import org.eclipse.passage.lbc.internal.base.api.FloatingState;
import org.eclipse.passage.lbc.internal.base.api.RawRequest;
import org.eclipse.passage.lbc.internal.base.mine.FloatingConditions;
import org.eclipse.passage.lbc.internal.base.mine.PersonalLicenseGenerated;
import org.eclipse.passage.lic.api.LicensedProduct;
import org.eclipse.passage.lic.api.PassageAction;
import org.eclipse.passage.lic.api.ServiceInvocationResult;
import org.eclipse.passage.lic.api.conditions.ConditionPack;
import org.eclipse.passage.lic.base.diagnostic.DiagnosticExplained;
import org.eclipse.passage.lic.base.diagnostic.NoErrors;
import org.eclipse.passage.lic.internal.net.api.handle.NetResponse;
import org.eclipse.passage.lic.internal.net.handle.Failure;
import org.eclipse.passage.lic.internal.net.handle.ProductUserRequest;
import org.eclipse.passage.lic.licenses.model.api.PersonalLicensePack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Conditions
implements Supplier<NetResponse> {
    private final ProductUserRequest<RawRequest> data;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public Conditions(ProductUserRequest<RawRequest> data) {
        this.data = data;
    }

    @Override
    public NetResponse get() {
        this.log.debug(String.format("Mining conditions for product %s", this.data.product().get()));
        ServiceInvocationResult conditions = new FloatingConditions(((FloatingState)((RawRequest)this.data.raw()).state())::source, (String)this.data.user().get()).all((LicensedProduct)this.data.product().get());
        if (!conditions.data().isPresent()) {
            return new Failure.OperationFailed(new PassageAction.Mine().name(), new DiagnosticExplained(conditions.diagnostic()).get());
        }
        if (!new NoErrors().test(conditions.diagnostic())) {
            this.log.error(new DiagnosticExplained(conditions.diagnostic()).get());
        }
        return this.encodedPack(this.pack((Collection)conditions.data().get()));
    }

    private NetResponse encodedPack(PersonalLicensePack pack) {
        return new EncodedResponse<PersonalLicensePack>(pack, this.data).get();
    }

    private PersonalLicensePack pack(Collection<ConditionPack> conditions) {
        return new PersonalLicenseGenerated((LicensedProduct)this.data.product().get(), (String)this.data.user().get(), conditions.stream().flatMap(pack -> pack.conditions().stream()).collect(Collectors.toList()), conditions.stream().flatMap(pack -> pack.agreements().stream()).collect(Collectors.toList())).get();
    }
}

