/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.bc;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Date;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.openpgp.PGPKeyPair;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPKeyRingGenerator;
import org.bouncycastle.openpgp.PGPSignatureSubpacketGenerator;
import org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import org.bouncycastle.openpgp.operator.PBESecretKeyEncryptor;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPDigestCalculatorProviderBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPKeyPair;
import org.bouncycastle.openpgp.operator.jcajce.JcePBESecretKeyEncryptorBuilder;
import org.eclipse.passage.lic.internal.api.LicensingException;
import org.eclipse.passage.lic.internal.api.io.EncryptionAlgorithm;
import org.eclipse.passage.lic.internal.api.io.EncryptionKeySize;
import org.eclipse.passage.lic.internal.bc.i18n.BcMessages;

final class BcKeyPair {
    private final Targets targets;
    private final EncryptionParameters parameters;

    BcKeyPair(Targets targets, EncryptionParameters parameters) {
        this.targets = targets;
        this.parameters = parameters;
    }

    void generate(String username, String password) throws LicensingException {
        PGPKeyRingGenerator ring = this.keyRing(username, password);
        this.persist((PGPKeyRing)ring.generateSecretKeyRing(), this.targets.privatePath, "BcStreamCodec_create_keys_error_private");
        this.persist((PGPKeyRing)ring.generatePublicKeyRing(), this.targets.publicPath, "BcStreamCodec_create_keys_error_public");
    }

    private PGPKeyRingGenerator keyRing(String username, String password) throws LicensingException {
        try {
            JcaPGPKeyPair pair = new JcaPGPKeyPair(1, this.pair(), new Date());
            PGPDigestCalculator calculator = new JcaPGPDigestCalculatorProviderBuilder().build().get(2);
            PGPKeyRingGenerator generator = new PGPKeyRingGenerator(19, (PGPKeyPair)pair, username, calculator, this.vector(), null, (PGPContentSignerBuilder)this.signer((PGPKeyPair)pair), this.encryptor(password, calculator));
            generator.addSubKey((PGPKeyPair)pair);
            return generator;
        }
        catch (Exception e) {
            throw new LicensingException(BcMessages.getString("BcStreamCodec_create_keys_error_ring"), (Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void persist(PGPKeyRing key, Path target, String error) throws LicensingException {
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try {
                FileOutputStream fos = new FileOutputStream(target.toFile());
                try {
                    try (ArmoredOutputStream output = new ArmoredOutputStream((OutputStream)new BufferedOutputStream(fos));){
                        key.encode((OutputStream)output);
                    }
                    if (fos == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (fos == null) throw throwable;
                    fos.close();
                    throw throwable;
                }
                fos.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new LicensingException(BcMessages.getString(error), (Throwable)e);
        }
    }

    private KeyPair pair() throws NoSuchAlgorithmException, NoSuchProviderException {
        KeyPairGenerator generator = KeyPairGenerator.getInstance(this.parameters.algorithm.name(), "BC");
        generator.initialize(this.parameters.key.size());
        return generator.generateKeyPair();
    }

    private PBESecretKeyEncryptor encryptor(String password, PGPDigestCalculator calculator) {
        JcePBESecretKeyEncryptorBuilder builder = new JcePBESecretKeyEncryptorBuilder(3, calculator);
        return builder.setProvider("BC").build(password.toCharArray());
    }

    private PGPSignatureSubpacketVector vector() {
        PGPSignatureSubpacketGenerator subpacketGenerator = new PGPSignatureSubpacketGenerator();
        subpacketGenerator.setKeyExpirationTime(false, this.parameters.expiration);
        return subpacketGenerator.generate();
    }

    private JcaPGPContentSignerBuilder signer(PGPKeyPair pair) {
        return new JcaPGPContentSignerBuilder(pair.getPublicKey().getAlgorithm(), 2);
    }

    static final class EncryptionParameters {
        private final EncryptionAlgorithm algorithm;
        private final EncryptionKeySize key;
        private final long expiration = 1000L;

        EncryptionParameters(EncryptionAlgorithm algorithm, EncryptionKeySize key) {
            this.algorithm = algorithm;
            this.key = key;
        }
    }

    static final class Targets {
        private final Path publicPath;
        private final Path privatePath;

        Targets(Path publicPath, Path privatePath) {
            this.publicPath = publicPath;
            this.privatePath = privatePath;
        }
    }
}

