/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.mylyn.reviews.frame.core.model.ReviewComponent;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EDecision;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReview;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewDecision;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewGroup;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewPhase;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewState;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewType;
import org.eclipse.mylyn.reviews.r4e.core.model.RModelFactory;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.Persistence;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.CompatibilityException;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.OutOfSyncException;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.ResourceHandlingException;
import org.eclipse.mylyn.reviews.r4e.ui.R4EUIPlugin;
import org.eclipse.mylyn.reviews.r4e.ui.internal.dialogs.IReviewInputDialog;
import org.eclipse.mylyn.reviews.r4e.ui.internal.dialogs.R4EUIDialogFactory;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.IR4EUIModelElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelController;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReviewBasic;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReviewExtended;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIRootElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIRuleSet;
import org.eclipse.mylyn.reviews.r4e.ui.internal.properties.general.ReviewGroupProperties;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.UIUtils;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.views.properties.IPropertySource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class R4EUIReviewGroup
extends R4EUIModelElement {
    public static final String REVIEW_GROUP_ICON_FILE = "icons/obj16/revgrp_obj.gif";
    public static final String REVIEW_GROUP_CLOSED_ICON_FILE = "icons/obj16/revgrpclsd_obj.gif";
    private static final String NEW_CHILD_ELEMENT_COMMAND_NAME = "New Review...";
    private static final String NEW_CHILD_ELEMENT_COMMAND_TOOLTIP = "Add a New Review to the Current Review Group";
    private static final String OPEN_ELEMENT_COMMAND_NAME = "Open Review Group";
    private static final String OPEN_ELEMENT_COMMAND_TOOLTIP = "Open and Load Data for this Review Group";
    private static final String CLOSE_ELEMENT_COMMAND_NAME = "Close Review Group";
    private static final String CLOSE_ELEMENT_COMMAND_TOOLTIP = "Close and Unload Data for this Review Group";
    private static final String REMOVE_ELEMENT_COMMAND_NAME = "Disable Review Group";
    private static final String REMOVE_ELEMENT_COMMAND_TOOLTIP = "Disable this Review Group";
    private static final String RESTORE_ELEMENT_COMMAND_NAME = "Restore Review Group";
    private static final String RESTORE_ELEMENT_COMMAND_TOOLTIP = "Restore this disabled Review Group";
    protected R4EReviewGroup fGroup;
    private final URI fGroupFileURI;
    private final List<R4EUIReviewBasic> fReviews;
    private final List<R4EUIRuleSet> fRuleSets;

    public R4EUIReviewGroup(IR4EUIModelElement aParent, R4EReviewGroup aGroup, boolean aOpen) {
        super(aParent, aGroup.getName());
        this.fReadOnly = false;
        this.fGroup = aGroup;
        this.fGroupFileURI = aGroup.eResource().getURI();
        this.fReviews = new ArrayList<R4EUIReviewBasic>();
        this.fRuleSets = new ArrayList<R4EUIRuleSet>();
        this.fOpen = aOpen;
    }

    @Override
    public String getImageLocation() {
        if (this.isOpen()) {
            return REVIEW_GROUP_ICON_FILE;
        }
        return REVIEW_GROUP_CLOSED_ICON_FILE;
    }

    @Override
    public String getToolTip() {
        return "File Location: " + URI.decode((String)this.fGroupFileURI.devicePath());
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (IR4EUIModelElement.class.equals((Object)adapter)) {
            return this;
        }
        if (IPropertySource.class.equals((Object)adapter)) {
            return new ReviewGroupProperties(this);
        }
        return null;
    }

    public R4EReviewGroup getReviewGroup() {
        return this.fGroup;
    }

    public String getGroupFile() {
        return URI.decode((String)this.fGroupFileURI.devicePath());
    }

    public List<R4EUIRuleSet> getRuleSets() {
        return this.fRuleSets;
    }

    @Override
    public void setModelData(ReviewComponent aModelComponent) throws ResourceHandlingException, OutOfSyncException {
        Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)this.fGroup, R4EUIModelController.getReviewer());
        this.fGroup.setDescription(((R4EReviewGroup)aModelComponent).getDescription());
        this.fGroup.getAvailableProjects().addAll((Collection)((R4EReviewGroup)aModelComponent).getAvailableProjects());
        this.fGroup.getAvailableComponents().addAll((Collection)((R4EReviewGroup)aModelComponent).getAvailableComponents());
        this.fGroup.setDefaultEntryCriteria(((R4EReviewGroup)aModelComponent).getDefaultEntryCriteria());
        this.fGroup.getDesignRuleLocations().addAll((Collection)((R4EReviewGroup)aModelComponent).getDesignRuleLocations());
        R4EUIModelController.FResourceUpdater.checkIn(bookNum);
    }

    @Override
    public List<ReviewComponent> createChildModelDataElement() {
        ArrayList<ReviewComponent> tempReviews = new ArrayList<ReviewComponent>();
        IReviewInputDialog dialog = R4EUIDialogFactory.getInstance().getReviewInputDialog(this);
        dialog.create();
        int result = dialog.open();
        if (result == 0) {
            R4EReviewType type = dialog.getReviewTypeValue();
            Object tempReview = type.equals((Object)R4EReviewType.R4E_REVIEW_TYPE_FORMAL) ? RModelFactory.eINSTANCE.createR4EFormalReview() : RModelFactory.eINSTANCE.createR4EReview();
            tempReview.setType(type);
            tempReview.setName(dialog.getReviewNameValue());
            tempReview.setExtraNotes(dialog.getReviewDescriptionValue());
            tempReview.setDueDate(dialog.getDueDate());
            tempReview.setProject(dialog.getProjectValue());
            String[] stringArray = dialog.getComponentsValues();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String component = stringArray[n2];
                tempReview.getComponents().add((Object)component);
                ++n2;
            }
            tempReview.setEntryCriteria(dialog.getEntryCriteriaValue());
            tempReview.setObjectives(dialog.getObjectivesValue());
            tempReview.setReferenceMaterial(dialog.getReferenceMaterialValue());
            R4EReviewDecision reviewDecision = Persistence.RModelFactoryExt.eINSTANCE.createR4EReviewDecision();
            if (type.equals((Object)R4EReviewType.R4E_REVIEW_TYPE_INFORMAL)) {
                reviewDecision.setValue(R4EDecision.R4E_REVIEW_DECISION_ACCEPTED);
            } else {
                reviewDecision.setValue(R4EDecision.R4E_REVIEW_DECISION_NONE);
            }
            tempReview.setDecision(reviewDecision);
            tempReviews.add((ReviewComponent)tempReview);
        }
        return tempReviews;
    }

    @Override
    public void close() {
        R4EUIReviewBasic review = null;
        int reviewsSize = this.fReviews.size();
        int i = 0;
        while (i < reviewsSize) {
            review = this.fReviews.get(i);
            if (review.isOpen()) {
                review.close();
            }
            ++i;
        }
        this.fReviews.clear();
        this.fRuleSets.clear();
        this.fOpen = false;
        this.fReadOnly = false;
        R4EUIModelController.FModelExt.closeR4EReviewGroup(this.fGroup);
        this.fImage = UIUtils.loadIcon(REVIEW_GROUP_CLOSED_ICON_FILE);
    }

    @Override
    public void open() throws ResourceHandlingException, CompatibilityException {
        this.fGroup = R4EUIModelController.FModelExt.openR4EReviewGroup(this.fGroupFileURI);
        if (this.checkCompatibility()) {
            EList reviews = this.fGroup.getReviews();
            if (reviews != null) {
                int reviewsSize = reviews.size();
                R4EReview review = null;
                R4EUIReviewBasic uiReview = null;
                int i = 0;
                while (i < reviewsSize) {
                    review = (R4EReview)reviews.get(i);
                    if (review.isEnabled() || R4EUIPlugin.getDefault().getPreferenceStore().getBoolean("showDisabled")) {
                        uiReview = null;
                        if (review.getType().equals((Object)R4EReviewType.R4E_REVIEW_TYPE_FORMAL)) {
                            uiReview = new R4EUIReviewExtended(this, review, review.getType(), false);
                            uiReview.setName(String.valueOf(((R4EUIReviewExtended)uiReview).getPhaseString(((R4EReviewState)review.getState()).getState())) + ": " + uiReview.getName());
                        } else {
                            uiReview = new R4EUIReviewBasic(this, review, review.getType(), false);
                        }
                        this.addChildren(uiReview);
                    }
                    ++i;
                }
            }
            EList ruleSetlocations = this.fGroup.getDesignRuleLocations();
            block1: for (String ruleSetlocation : ruleSetlocations) {
                for (R4EUIRuleSet ruleSet : ((R4EUIRootElement)this.getParent()).getRuleSets()) {
                    if (!ruleSet.getRuleSet().getName().equals(ruleSetlocation)) continue;
                    this.fRuleSets.add(ruleSet);
                    continue block1;
                }
            }
            this.fOpen = true;
            this.fImage = UIUtils.loadIcon(REVIEW_GROUP_ICON_FILE);
        } else {
            R4EUIModelController.FModelExt.closeR4EReviewGroup(this.fGroup);
        }
    }

    private boolean checkCompatibility() {
        int checkResult = this.fGroup.getCompatibility();
        switch (checkResult) {
            case -1: {
                UIUtils.displayCompatibilityErrorDialog();
                return false;
            }
            case 1: {
                int result = UIUtils.displayCompatibilityWarningDialog(this.fGroup.getFragmentVersion(), this.fGroup.getApplicationVersion());
                switch (result) {
                    case 0: {
                        try {
                            Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)this.fGroup, R4EUIModelController.getReviewer());
                            this.fGroup.setFragmentVersion(this.fGroup.getApplicationVersion());
                            R4EUIModelController.FResourceUpdater.checkIn(bookNum);
                        }
                        catch (ResourceHandlingException e) {
                            UIUtils.displayResourceErrorDialog(e);
                            return false;
                        }
                        catch (OutOfSyncException e) {
                            UIUtils.displaySyncErrorDialog(e);
                            return false;
                        }
                        this.fReadOnly = false;
                        return true;
                    }
                    case 1: {
                        this.fReadOnly = true;
                        return true;
                    }
                }
                return false;
            }
        }
        this.fReadOnly = false;
        return true;
    }

    @Override
    public void setEnabled(boolean aEnabled) throws ResourceHandlingException, OutOfSyncException, CompatibilityException {
        this.fGroup = R4EUIModelController.FModelExt.openR4EReviewGroup(this.fGroupFileURI);
        Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)this.fGroup, R4EUIModelController.getReviewer());
        this.fGroup.setEnabled(aEnabled);
        R4EUIModelController.FResourceUpdater.checkIn(bookNum);
        R4EUIModelController.FModelExt.closeR4EReviewGroup(this.fGroup);
    }

    @Override
    public boolean isEnabled() {
        return this.fGroup.isEnabled();
    }

    @Override
    public IR4EUIModelElement[] getChildren() {
        return this.fReviews.toArray(new R4EUIReviewBasic[this.fReviews.size()]);
    }

    @Override
    public boolean hasChildren() {
        return this.isOpen() && this.fReviews.size() > 0;
    }

    @Override
    public IR4EUIModelElement createChildren(ReviewComponent aModelComponent) throws ResourceHandlingException, OutOfSyncException {
        R4EUIReviewBasic addedChild;
        String reviewName = ((R4EReview)aModelComponent).getName();
        R4EReviewType type = ((R4EReview)aModelComponent).getType();
        for (R4EUIReviewBasic review : this.fReviews) {
            if (!review.getReview().getName().equals(reviewName)) continue;
            final ErrorDialog dialog = new ErrorDialog(null, "R4E Error", "Error while creating new review ", (IStatus)new Status(4, "org.eclipse.mylyn.reviews.r4e.ui", 0, "Review " + reviewName + " already exists", null), 4);
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    dialog.open();
                }
            });
            return null;
        }
        if (type.equals((Object)R4EReviewType.R4E_REVIEW_TYPE_FORMAL)) {
            addedChild = new R4EUIReviewExtended(this, (R4EReview)R4EUIModelController.FModelExt.createR4EFormalReview(this.getReviewGroup(), reviewName, R4EUIModelController.getReviewer()), type, true);
            ((R4EUIReviewExtended)addedChild).updatePhase(R4EReviewPhase.R4E_REVIEW_PHASE_STARTED);
        } else {
            addedChild = new R4EUIReviewBasic(this, R4EUIModelController.FModelExt.createR4EReview(this.getReviewGroup(), reviewName, R4EUIModelController.getReviewer()), type, true);
            addedChild.updatePhase(R4EReviewPhase.R4E_REVIEW_PHASE_STARTED);
        }
        addedChild.setModelData(aModelComponent);
        this.addChildren(addedChild);
        return addedChild;
    }

    @Override
    public void addChildren(IR4EUIModelElement aChildToAdd) {
        this.fReviews.add((R4EUIReviewBasic)aChildToAdd);
    }

    @Override
    public void removeChildren(IR4EUIModelElement aChildToRemove, boolean aFileRemove) throws ResourceHandlingException, OutOfSyncException, CompatibilityException {
        if (((R4EUIReviewBasic)aChildToRemove).isOpen()) {
            R4EUIModelController.setActiveReview(null);
        }
        R4EUIReviewBasic removedElement = this.fReviews.get(this.fReviews.indexOf(aChildToRemove));
        removedElement.removeAllChildren(aFileRemove);
        removedElement.setEnabled(false);
        if (!R4EUIPlugin.getDefault().getPreferenceStore().getBoolean("showDisabled")) {
            this.fReviews.remove(removedElement);
        }
    }

    @Override
    public void removeAllChildren(boolean aFileRemove) throws ResourceHandlingException, OutOfSyncException, CompatibilityException {
        for (R4EUIReviewBasic review : this.fReviews) {
            this.removeChildren(review, aFileRemove);
        }
    }

    @Override
    public boolean isOpenElementCmd() {
        return this.isEnabled() && !this.isOpen();
    }

    @Override
    public String getOpenElementCmdName() {
        return OPEN_ELEMENT_COMMAND_NAME;
    }

    @Override
    public String getOpenElementCmdTooltip() {
        return OPEN_ELEMENT_COMMAND_TOOLTIP;
    }

    @Override
    public boolean isCloseElementCmd() {
        return this.isEnabled() && this.isOpen();
    }

    @Override
    public String getCloseElementCmdName() {
        return CLOSE_ELEMENT_COMMAND_NAME;
    }

    @Override
    public String getCloseElementCmdTooltip() {
        return CLOSE_ELEMENT_COMMAND_TOOLTIP;
    }

    @Override
    public boolean isNewChildElementCmd() {
        return this.isEnabled() && this.isOpen() && !this.isReadOnly();
    }

    @Override
    public String getNewChildElementCmdName() {
        return NEW_CHILD_ELEMENT_COMMAND_NAME;
    }

    @Override
    public String getNewChildElementCmdTooltip() {
        return NEW_CHILD_ELEMENT_COMMAND_TOOLTIP;
    }

    @Override
    public boolean isRemoveElementCmd() {
        return !this.isOpen() && this.isEnabled() && !this.isReadOnly();
    }

    @Override
    public String getRemoveElementCmdName() {
        return REMOVE_ELEMENT_COMMAND_NAME;
    }

    @Override
    public String getRemoveElementCmdTooltip() {
        return REMOVE_ELEMENT_COMMAND_TOOLTIP;
    }

    @Override
    public boolean isRestoreElementCmd() {
        return !this.isOpen() && !this.isEnabled() && !this.isReadOnly();
    }

    @Override
    public String getRestoreElementCmdName() {
        return RESTORE_ELEMENT_COMMAND_NAME;
    }

    @Override
    public String getRestoreElementCmdTooltip() {
        return RESTORE_ELEMENT_COMMAND_TOOLTIP;
    }
}

