/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.notifications.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.reviews.notifications.core.IMeetingData;
import org.eclipse.mylyn.reviews.notifications.internal.core.MeetingData;
import org.eclipse.mylyn.reviews.notifications.spi.NotificationsConnector;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotificationsCore {
    public static final String PLUGIN_ID = "org.eclipse.mylyn.reviews.notifications";

    public static List<String> getConnectorIds() {
        IExtension[] extensions;
        ArrayList<String> connectorIds = new ArrayList<String>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint connectorsExtensionPoint = registry.getExtensionPoint("org.eclipse.mylyn.reviews.notifications.connectors");
        IExtension[] iExtensionArray = extensions = connectorsExtensionPoint.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                connectorIds.add(element.getAttribute("id"));
                ++n4;
            }
            ++n2;
        }
        return connectorIds;
    }

    public static NotificationsConnector getFirstEnabled() {
        MultiStatus result = new MultiStatus(PLUGIN_ID, 0, "Notifications connectors failed to load.", null);
        Map<String, IConfigurationElement> configElements = NotificationsCore.resolveConfiguredElements();
        if (configElements.size() < 1) {
            result.add((IStatus)new Status(2, PLUGIN_ID, NLS.bind((String)"No connectors found extending ''{0}''", (Object)NotificationsConnector.class.getCanonicalName())));
            StatusHandler.log((IStatus)result);
            return null;
        }
        IConfigurationElement dConfigElement2 = null;
        for (IConfigurationElement dConfigElement2 : configElements.values()) {
            NotificationsConnector connector = NotificationsCore.loadElement(dConfigElement2, result);
            if (connector == null || !connector.isEnabled()) continue;
            return connector;
        }
        if (!result.isOK()) {
            StatusHandler.log((IStatus)result);
        }
        return null;
    }

    public static NotificationsConnector getFirstEnabled(String[] ids) {
        Assert.isNotNull((Object)ids);
        MultiStatus result = new MultiStatus(PLUGIN_ID, 0, "Notifications connectors failed to load.", null);
        Map<String, IConfigurationElement> configElements = NotificationsCore.resolveConfiguredElements();
        NotificationsConnector connector = null;
        IConfigurationElement dConfigElement = null;
        int i = 0;
        while (i < ids.length) {
            dConfigElement = configElements.get(ids[i]);
            if (dConfigElement != null && (connector = NotificationsCore.loadElement(dConfigElement, result)) != null && connector.isEnabled()) {
                return connector;
            }
            ++i;
        }
        if (!result.isOK()) {
            StatusHandler.log((IStatus)result);
        }
        if ((connector = NotificationsCore.getFirstEnabled()) != null) {
            return connector;
        }
        if (!result.isOK()) {
            StatusHandler.log((IStatus)result);
        }
        return null;
    }

    private static Map<String, IConfigurationElement> resolveConfiguredElements() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint connectorsExtensionPoint = registry.getExtensionPoint("org.eclipse.mylyn.reviews.notifications.connectors");
        IExtension[] extensions = connectorsExtensionPoint.getExtensions();
        HashMap<String, IConfigurationElement> configElements = new HashMap<String, IConfigurationElement>();
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                String eid = element.getAttribute("id");
                configElements.put(eid, element);
                ++n4;
            }
            ++n2;
        }
        return configElements;
    }

    private static NotificationsConnector loadElement(IConfigurationElement aElement, MultiStatus aStatus) {
        try {
            Object object = aElement.createExecutableExtension("core");
            if (object instanceof NotificationsConnector) {
                return (NotificationsConnector)object;
            }
            aStatus.add((IStatus)new Status(4, PLUGIN_ID, NLS.bind((String)"Notifications Connector core ''{0}'' does not extend expected class for extension contributed by {1}", (Object)object.getClass().getCanonicalName(), (Object)aElement.getContributor().getName())));
        }
        catch (Throwable e) {
            aStatus.add((IStatus)new Status(4, PLUGIN_ID, NLS.bind((String)"Notifications Connector core failed to load for extension contributed by {0}", (Object)aElement.getContributor().getName()), e));
        }
        return null;
    }

    public static NotificationsConnector loadConnector(String id) {
        IExtension[] extensions;
        Assert.isNotNull((Object)id);
        MultiStatus result = new MultiStatus(PLUGIN_ID, 0, "Notifications connectors failed to load.", null);
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint connectorsExtensionPoint = registry.getExtensionPoint("org.eclipse.mylyn.reviews.notifications.connectors");
        IExtension[] iExtensionArray = extensions = connectorsExtensionPoint.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                String eid = element.getAttribute("id");
                if (id.equals(eid)) {
                    try {
                        Object object = element.createExecutableExtension("core");
                        if (object instanceof NotificationsConnector) {
                            return (NotificationsConnector)object;
                        }
                        result.add((IStatus)new Status(4, PLUGIN_ID, NLS.bind((String)"Notifications Connector core ''{0}'' does not extend expected class for extension contributed by {1}", (Object)object.getClass().getCanonicalName(), (Object)element.getContributor().getName())));
                    }
                    catch (Throwable e) {
                        result.add((IStatus)new Status(4, PLUGIN_ID, NLS.bind((String)"Notifications Connector core failed to load for extension contributed by {0}", (Object)element.getContributor().getName()), e));
                    }
                }
                ++n4;
            }
            ++n2;
        }
        if (!result.isOK()) {
            StatusHandler.log((IStatus)result);
        }
        return null;
    }

    public static IMeetingData createMeetingData(String aCustomId, String aSubject, String aBody, String aLocation, long aStartTimeMilli, int aDuration, String aSender, String[] aReceivers) throws CoreException {
        return new MeetingData(aCustomId, aSubject, aBody, aLocation, aStartTimeMilli, aDuration, aSender, aReceivers);
    }
}

