/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.annotation.content;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModelEvent;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelListener;
import org.eclipse.jface.text.source.IAnnotationModelListenerExtension;
import org.eclipse.mylyn.reviews.frame.ui.annotation.IReviewAnnotation;
import org.eclipse.mylyn.reviews.frame.ui.annotation.IReviewAnnotationModel;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EID;
import org.eclipse.mylyn.reviews.r4e.ui.R4EUIPlugin;
import org.eclipse.mylyn.reviews.r4e.ui.internal.annotation.content.R4EAnnotation;
import org.eclipse.mylyn.reviews.r4e.ui.internal.annotation.content.R4EAnomalyAnnotation;
import org.eclipse.mylyn.reviews.r4e.ui.internal.annotation.content.R4EDeltaAnnotation;
import org.eclipse.mylyn.reviews.r4e.ui.internal.annotation.content.R4ESelectionAnnotation;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.IR4EUIModelElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIAnomalyBasic;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIAnomalyContainer;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIContent;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIContentsContainer;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIDelta;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIFileContext;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIPostponedFile;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUISelection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class R4EAnnotationModel
implements IReviewAnnotationModel {
    private final Set<IAnnotationModelListener> fAnnotationModelListeners = new HashSet<IAnnotationModelListener>(2);
    private final Map<R4EID, IReviewAnnotation> fAnnotationsMap = new HashMap<R4EID, IReviewAnnotation>();
    private final Map<String, List<IReviewAnnotation>> fSortedAnnotationsListsMap = new HashMap<String, List<IReviewAnnotation>>();
    private final Map<String, Integer> fSortedAnnotationsIndexMap = new HashMap<String, Integer>();
    private R4EUIFileContext fFileContext = null;
    private IDocument fDocument;
    private final IDocumentListener fDocumentListener = new IDocumentListener(){

        public void documentAboutToBeChanged(DocumentEvent aEvent) {
        }

        public void documentChanged(DocumentEvent aEvent) {
        }
    };
    private static final Comparator<IReviewAnnotation> ANNOTATION_COMPARATOR = new Comparator<IReviewAnnotation>(){

        @Override
        public int compare(IReviewAnnotation aObject1, IReviewAnnotation aObject2) {
            int sortOrder = aObject1.getPosition().getOffset() - aObject2.getPosition().getOffset();
            if (sortOrder == 0) {
                return aObject1.getPosition().getLength() - aObject2.getPosition().getLength();
            }
            return sortOrder;
        }
    };

    public Iterator<IReviewAnnotation> getAnnotationIterator() {
        return this.fAnnotationsMap.values().iterator();
    }

    public void setFile(Object aFileContext) {
        this.fFileContext = (R4EUIFileContext)aFileContext;
        if (aFileContext != null) {
            this.fFileContext.registerAnnotationModel(this);
        }
    }

    public Position getPosition(Annotation aAnnotation) {
        if (aAnnotation instanceof IReviewAnnotation) {
            return ((IReviewAnnotation)aAnnotation).getPosition();
        }
        return null;
    }

    public void addAnnotationModelListener(IAnnotationModelListener aListener) {
        this.fAnnotationModelListeners.add(aListener);
    }

    public void removeAnnotationModelListener(IAnnotationModelListener aListener) {
        this.fAnnotationModelListeners.remove(aListener);
    }

    public void connect(IDocument aDocument) {
        this.fDocument = aDocument;
        if (this.fDocument.getLength() > 0) {
            for (IReviewAnnotation annotation : this.fAnnotationsMap.values()) {
                try {
                    this.fDocument.addPosition(annotation.getPosition());
                }
                catch (BadLocationException e) {
                    R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                    R4EUIPlugin.getDefault().logError("Exception: " + e.toString(), (Exception)((Object)e));
                }
            }
            this.fDocument.addDocumentListener(this.fDocumentListener);
            this.refreshAnnotations();
        }
    }

    public void disconnect(IDocument aDocument) {
    }

    public void clearAnnotations() {
        AnnotationModelEvent event = new AnnotationModelEvent((IAnnotationModel)this);
        this.clear(event);
        this.fireModelChanged(event);
    }

    private void clear(AnnotationModelEvent aEvent) {
        for (IReviewAnnotation iReviewAnnotation : this.fAnnotationsMap.values()) {
            aEvent.annotationRemoved((Annotation)((R4EAnnotation)iReviewAnnotation), iReviewAnnotation.getPosition());
        }
        this.fAnnotationsMap.clear();
        for (List list : this.fSortedAnnotationsListsMap.values()) {
            list.clear();
        }
        this.fSortedAnnotationsIndexMap.clear();
    }

    public void refreshAnnotations() {
        AnnotationModelEvent event = new AnnotationModelEvent((IAnnotationModel)this);
        this.clear(event);
        if (this.fDocument != null && this.fFileContext != null) {
            R4EUIContentsContainer contents;
            int n;
            R4EUIAnomalyContainer anomalies = this.fFileContext.getAnomalyContainerElement();
            if (anomalies != null) {
                IR4EUIModelElement[] iR4EUIModelElementArray = anomalies.getChildren();
                n = iR4EUIModelElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IR4EUIModelElement anomaly = iR4EUIModelElementArray[n2];
                    this.addAnnotation(this.fDocument, event, anomaly);
                    ++n2;
                }
            }
            if ((contents = this.fFileContext.getContentsContainerElement()) != null) {
                IR4EUIModelElement[] iR4EUIModelElementArray = this.fFileContext.getContentsContainerElement().getChildren();
                int n3 = iR4EUIModelElementArray.length;
                n = 0;
                while (n < n3) {
                    IR4EUIModelElement content = iR4EUIModelElementArray[n];
                    this.addAnnotation(this.fDocument, event, content);
                    ++n;
                }
            }
            if (this.fFileContext instanceof R4EUIPostponedFile) {
                IR4EUIModelElement[] postponedAnomalies;
                IR4EUIModelElement[] iR4EUIModelElementArray = postponedAnomalies = ((R4EUIPostponedFile)this.fFileContext).getChildren();
                int n4 = postponedAnomalies.length;
                int n5 = 0;
                while (n5 < n4) {
                    IR4EUIModelElement anomaly = iR4EUIModelElementArray[n5];
                    this.addAnnotation(this.fDocument, event, anomaly);
                    ++n5;
                }
            }
        }
        this.fireModelChanged(event);
    }

    public void updateAnnotation(Object aAnnotationContent) {
        this.removeAnnotation(aAnnotationContent);
        this.addAnnotation(aAnnotationContent);
    }

    public void addAnnotation(Object aAnnotationContent) {
        AnnotationModelEvent event = new AnnotationModelEvent((IAnnotationModel)this);
        if (this.fDocument != null && this.fFileContext != null) {
            this.addAnnotation(this.fDocument, event, aAnnotationContent);
        }
        this.fireModelChanged(event);
    }

    private void addAnnotation(IDocument aDocument, AnnotationModelEvent aEvent, Object aAnnotationContent) {
        R4EAnnotation newAnnotation = null;
        if (aAnnotationContent instanceof R4EUIAnomalyBasic) {
            newAnnotation = new R4EAnomalyAnnotation((R4EUIAnomalyBasic)aAnnotationContent);
        } else if (aAnnotationContent instanceof R4EUIDelta) {
            newAnnotation = new R4EDeltaAnnotation((R4EUIDelta)aAnnotationContent);
        } else if (aAnnotationContent instanceof R4EUISelection) {
            newAnnotation = new R4ESelectionAnnotation((R4EUISelection)aAnnotationContent);
        }
        if (newAnnotation != null) {
            this.addAnnotation(newAnnotation, null);
            aEvent.annotationAdded((Annotation)newAnnotation);
        }
    }

    public void addAnnotation(Annotation aAnnotation, Position aPosition) {
        if (aAnnotation instanceof R4EAnnotation) {
            R4EAnnotation newAnnotation = (R4EAnnotation)aAnnotation;
            this.fAnnotationsMap.put((R4EID)newAnnotation.getId(), newAnnotation);
            List<IReviewAnnotation> annotationList = this.fSortedAnnotationsListsMap.get(newAnnotation.getType());
            if (annotationList == null) {
                annotationList = new ArrayList<IReviewAnnotation>();
                this.fSortedAnnotationsListsMap.put(newAnnotation.getType(), annotationList);
            }
            annotationList.add(newAnnotation);
            Collections.sort(annotationList, ANNOTATION_COMPARATOR);
            this.fSortedAnnotationsIndexMap.put(newAnnotation.getType(), annotationList.indexOf((Object)newAnnotation));
        }
    }

    public void removeAnnotation(Object aAnnotationContent) {
        R4EID id = null;
        if (aAnnotationContent instanceof R4EUIAnomalyBasic) {
            id = ((R4EUIAnomalyBasic)aAnnotationContent).getAnomaly().getId();
        } else if (aAnnotationContent instanceof R4EUIContent) {
            id = ((R4EUIContent)aAnnotationContent).getContent().getId();
        }
        if (id != null) {
            IReviewAnnotation removedAnnotation = this.fAnnotationsMap.remove(id);
            this.removeAnnotation((R4EAnnotation)removedAnnotation);
            AnnotationModelEvent event = new AnnotationModelEvent((IAnnotationModel)this);
            event.annotationRemoved((Annotation)((R4EAnnotation)removedAnnotation));
            this.fireModelChanged(event);
        }
    }

    public void removeAnnotation(Annotation aAnnotation) {
        if (aAnnotation instanceof R4EAnnotation) {
            R4EAnnotation remAnnotation = (R4EAnnotation)aAnnotation;
            this.fAnnotationsMap.remove(remAnnotation.getId());
            List<IReviewAnnotation> annotationList = this.fSortedAnnotationsListsMap.get(remAnnotation.getType());
            int remAnnotationIndex = annotationList.indexOf((Object)remAnnotation);
            annotationList.remove((Object)remAnnotation);
            if (remAnnotationIndex < 0) {
                this.fSortedAnnotationsIndexMap.remove(remAnnotation.getType());
            } else {
                this.fSortedAnnotationsIndexMap.put(remAnnotation.getType(), --remAnnotationIndex);
            }
        }
    }

    public void fireModelChanged(AnnotationModelEvent aEvent) {
        aEvent.markSealed();
        if (!aEvent.isEmpty()) {
            for (IAnnotationModelListener listener : this.fAnnotationModelListeners) {
                if (listener instanceof IAnnotationModelListenerExtension) {
                    ((IAnnotationModelListenerExtension)listener).modelChanged(aEvent);
                    continue;
                }
                listener.modelChanged((IAnnotationModel)this);
            }
        }
    }

    public boolean isAnnotationsAvailable(String aType) {
        return true;
    }

    public IReviewAnnotation getNextAnnotation(String aType) {
        List<IReviewAnnotation> annotationList = this.fSortedAnnotationsListsMap.get(aType);
        if (annotationList == null || annotationList.size() == 0) {
            return null;
        }
        int annotationIndex = this.fSortedAnnotationsIndexMap.get(aType);
        if (++annotationIndex == annotationList.size()) {
            annotationIndex = 0;
        }
        this.fSortedAnnotationsIndexMap.put(aType, annotationIndex);
        return annotationList.get(annotationIndex);
    }

    public IReviewAnnotation getPreviousAnnotation(String aType) {
        List<IReviewAnnotation> annotationList = this.fSortedAnnotationsListsMap.get(aType);
        if (annotationList == null || annotationList.size() == 0) {
            return null;
        }
        int annotationIndex = this.fSortedAnnotationsIndexMap.get(aType);
        if (--annotationIndex < 0) {
            annotationIndex = annotationList.size() - 1;
        }
        this.fSortedAnnotationsIndexMap.put(aType, annotationIndex);
        return annotationList.get(annotationIndex);
    }

    public IReviewAnnotation findAnnotation(String aType, Object aSourceElement) {
        List<IReviewAnnotation> annotationList = this.fSortedAnnotationsListsMap.get(aType);
        for (IReviewAnnotation annotation : annotationList) {
            if (!((R4EAnnotation)annotation).getSourceElement().equals(aSourceElement)) continue;
            return annotation;
        }
        return null;
    }

    public Object getFile() {
        return this.fFileContext;
    }
}

