/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.commands.handlers;

import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EAnomalyState;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewPhase;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.CompatibilityException;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.ResourceHandlingException;
import org.eclipse.mylyn.reviews.r4e.ui.R4EUIPlugin;
import org.eclipse.mylyn.reviews.r4e.ui.internal.dialogs.IChangeStateDialog;
import org.eclipse.mylyn.reviews.r4e.ui.internal.dialogs.R4EUIDialogFactory;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.IR4EUIModelElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIAnomalyBasic;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIAnomalyExtended;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelController;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIPostponedAnomaly;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReviewBasic;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReviewExtended;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.UIUtils;
import org.eclipse.swt.widgets.Display;

public class NextStateHandler
extends AbstractHandler {
    private static final String COMMAND_MESSAGE = "Progressing element to its Next State...";

    public Object execute(ExecutionEvent aEvent) {
        final List<IR4EUIModelElement> selectedElements = UIUtils.getCommandUIElements();
        Job job = new Job(COMMAND_MESSAGE){
            public String familyName;
            {
                super($anonymous0);
                this.familyName = "R4EUI";
            }

            public boolean belongsTo(Object family) {
                return this.familyName.equals(family);
            }

            public IStatus run(IProgressMonitor monitor) {
                if (!selectedElements.isEmpty()) {
                    R4EUIModelController.setJobInProgress(true);
                    monitor.beginTask(NextStateHandler.COMMAND_MESSAGE, selectedElements.size());
                    for (IR4EUIModelElement element : selectedElements) {
                        R4EUIPlugin.Ftracer.traceInfo("Progressing state for element " + element.getName());
                        if (element instanceof R4EUIReviewExtended) {
                            NextStateHandler.this.progressExtendedReview((R4EUIReviewExtended)element);
                        } else if (element instanceof R4EUIReviewBasic) {
                            NextStateHandler.this.progressBasicReview((R4EUIReviewBasic)element);
                        } else if (element instanceof R4EUIPostponedAnomaly) {
                            try {
                                if (((R4EUIPostponedAnomaly)element).checkCompatibility()) {
                                    NextStateHandler.this.progressAnomaly((R4EUIPostponedAnomaly)element);
                                }
                            }
                            catch (ResourceHandlingException e) {
                                UIUtils.displayResourceErrorDialog(e);
                            }
                            catch (CompatibilityException e) {
                                UIUtils.displayCompatibilityErrorDialog(e);
                            }
                        } else if (element instanceof R4EUIAnomalyExtended) {
                            NextStateHandler.this.progressAnomaly((R4EUIAnomalyExtended)element);
                        }
                        monitor.worked(1);
                        if (!monitor.isCanceled()) continue;
                        R4EUIModelController.setJobInProgress(false);
                        UIUtils.setNavigatorViewFocus(element, 0);
                        return Status.CANCEL_STATUS;
                    }
                    R4EUIModelController.setJobInProgress(false);
                    UIUtils.setNavigatorViewFocus((IR4EUIModelElement)selectedElements.get(0), 0);
                }
                R4EUIModelController.setJobInProgress(false);
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
        return null;
    }

    private void progressExtendedReview(R4EUIReviewExtended aReview) {
        final String[] newPhasesStr = aReview.getNextAvailablePhases();
        if (newPhasesStr.length > 1) {
            final IChangeStateDialog dialog = R4EUIDialogFactory.getInstance().getChangeStateDialog(R4EUIReviewBasic.class);
            final int[] result = new int[1];
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    dialog.create();
                    dialog.setStates(newPhasesStr);
                    result[0] = dialog.open();
                }
            });
            if (result[0] == 0) {
                R4EReviewPhase newPhase = aReview.getPhaseFromString(dialog.getState());
                UIUtils.changeReviewPhase(aReview, newPhase);
            }
        } else {
            R4EReviewPhase newPhase = aReview.getPhaseFromString(newPhasesStr[0]);
            UIUtils.changeReviewPhase(aReview, newPhase);
        }
    }

    private void progressBasicReview(R4EUIReviewBasic aReview) {
        R4EReviewPhase newPhase = aReview.getPhaseFromString("COMPLETED");
        UIUtils.changeReviewPhase(aReview, newPhase);
    }

    private void progressAnomaly(R4EUIAnomalyExtended aAnomaly) {
        final String[] newStatesStr = aAnomaly.getNextAvailableStates();
        if (newStatesStr.length > 1) {
            final IChangeStateDialog dialog = R4EUIDialogFactory.getInstance().getChangeStateDialog(R4EUIAnomalyBasic.class);
            final int[] result = new int[1];
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    dialog.create();
                    dialog.setStates(newStatesStr);
                    result[0] = dialog.open();
                }
            });
            if (result[0] == 0) {
                R4EAnomalyState newState = R4EUIAnomalyExtended.getStateFromString(dialog.getState());
                if (newState.equals((Object)R4EAnomalyState.R4E_ANOMALY_STATE_REJECTED)) {
                    boolean commentResult = aAnomaly.createComment(true);
                    if (commentResult) {
                        UIUtils.changeAnomalyState(aAnomaly, newState);
                    } else {
                        final ErrorDialog commentErrorDialog = new ErrorDialog(null, "R4E Error", "Cannot change Anomaly State", (IStatus)new Status(4, "org.eclipse.mylyn.reviews.r4e.ui", 0, "Please enter a reason for rejecting this anomaly", null), 4);
                        Display.getDefault().syncExec(new Runnable(){

                            public void run() {
                                commentErrorDialog.open();
                            }
                        });
                    }
                } else {
                    UIUtils.changeAnomalyState(aAnomaly, newState);
                }
            }
        } else {
            R4EAnomalyState newState = R4EUIAnomalyExtended.getStateFromString(newStatesStr[0]);
            UIUtils.changeAnomalyState(aAnomaly, newState);
        }
    }
}

