/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.commands.handlers;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.mylyn.reviews.r4e.report.impl.IR4EReport;
import org.eclipse.mylyn.reviews.r4e.report.impl.R4EReportFactory;
import org.eclipse.mylyn.reviews.r4e.ui.R4EUIPlugin;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.IR4EUIModelElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelController;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReviewBasic;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReviewGroup;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.UIUtils;

public class ReportElementHandler
extends AbstractHandler {
    private static final String COMMAND_MESSAGE = "Generating Report for Elements...";

    public Object execute(ExecutionEvent event) {
        final List<IR4EUIModelElement> selectedElements = UIUtils.getCommandUIElements();
        Job job = new Job(COMMAND_MESSAGE){
            public String familyName;
            {
                super($anonymous0);
                this.familyName = "R4EUI";
            }

            public boolean belongsTo(Object family) {
                return this.familyName.equals(family);
            }

            public IStatus run(IProgressMonitor monitor) {
                R4EUIModelController.setJobInProgress(true);
                monitor.beginTask(ReportElementHandler.COMMAND_MESSAGE, -1);
                if (!selectedElements.isEmpty()) {
                    String groupFile = null;
                    ArrayList<File> listSelectedReviews = new ArrayList<File>();
                    for (IR4EUIModelElement element : selectedElements) {
                        if (!(element instanceof R4EUIReviewBasic)) continue;
                        R4EUIReviewBasic extentElement = (R4EUIReviewBasic)element;
                        if (groupFile == null) {
                            groupFile = ((R4EUIReviewGroup)extentElement.getParent()).getGroupFile();
                            R4EUIPlugin.Ftracer.traceInfo("Info: Group file: " + groupFile);
                        }
                        R4EUIPlugin.Ftracer.traceInfo("Review name element " + extentElement.getReview().getName());
                        listSelectedReviews.add(new File(extentElement.getReview().getName()));
                    }
                    if (R4EUIPlugin.isUserReportAvailable()) {
                        IR4EReport reportGen = R4EReportFactory.getInstance();
                        reportGen.setReviewListSelection(listSelectedReviews.toArray(new File[listSelectedReviews.size()]));
                        reportGen.handleReportGeneration(groupFile, monitor);
                        R4EUIPlugin.Ftracer.traceInfo("Report element AVAILABLE");
                    } else {
                        R4EUIPlugin.Ftracer.traceWarning("Report element Not available");
                    }
                }
                monitor.done();
                R4EUIModelController.setJobInProgress(false);
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
        return null;
    }
}

