/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.commands.handlers;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EFormalReview;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReview;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewComponent;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewPhase;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewType;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.CompatibilityException;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.OutOfSyncException;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.ResourceHandlingException;
import org.eclipse.mylyn.reviews.r4e.ui.R4EUIPlugin;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.IR4EUIModelElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIContent;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelController;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReviewBasic;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReviewItem;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.MailServicesProxy;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.UIUtils;

public class RestoreElementHandler
extends AbstractHandler {
    private static final String COMMAND_MESSAGE = "Restoring Elements...";

    public Object execute(ExecutionEvent aEvent) {
        final List<IR4EUIModelElement> selectedElements = UIUtils.getCommandUIElements();
        Job job = new Job(COMMAND_MESSAGE){
            public String familyName;
            {
                super($anonymous0);
                this.familyName = "R4EUI";
            }

            public boolean belongsTo(Object family) {
                return this.familyName.equals(family);
            }

            public IStatus run(IProgressMonitor monitor) {
                R4EUIModelController.setJobInProgress(true);
                if (!selectedElements.isEmpty()) {
                    monitor.beginTask(RestoreElementHandler.COMMAND_MESSAGE, selectedElements.size());
                    R4EReview review = null;
                    if (R4EUIModelController.getActiveReview() != null) {
                        review = R4EUIModelController.getActiveReview().getReview();
                    }
                    ArrayList<R4EReviewComponent> addedItems = new ArrayList<R4EReviewComponent>();
                    for (IR4EUIModelElement element : selectedElements) {
                        try {
                            monitor.subTask("Restoring element " + element.getName());
                            R4EUIPlugin.Ftracer.traceInfo("Restoring element " + element.getName());
                            element.restore();
                            if (element instanceof R4EUIReviewBasic && R4EUIModelController.getActiveReview() != null) {
                                R4EUIModelController.getActiveReview().close();
                            }
                            element.open();
                            if (element instanceof R4EUIReviewItem) {
                                addedItems.add((R4EReviewComponent)((R4EUIReviewItem)element).getItem());
                            } else if (element instanceof R4EUIContent) {
                                addedItems.add((R4EReviewComponent)((R4EUIContent)element).getContent());
                            }
                        }
                        catch (ResourceHandlingException e) {
                            UIUtils.displayResourceErrorDialog(e);
                        }
                        catch (OutOfSyncException e) {
                            UIUtils.displaySyncErrorDialog(e);
                        }
                        catch (FileNotFoundException e) {
                            R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                            R4EUIPlugin.getDefault().logError("Exception: " + e.toString(), e);
                        }
                        catch (CompatibilityException e) {
                            UIUtils.displayCompatibilityErrorDialog(e);
                        }
                        monitor.worked(1);
                        if (!monitor.isCanceled()) continue;
                        R4EUIModelController.setJobInProgress(false);
                        UIUtils.setNavigatorViewFocus(element, 0);
                        return Status.CANCEL_STATUS;
                    }
                    if (review != null && addedItems.size() > 0 && review.getType().equals((Object)R4EReviewType.R4E_REVIEW_TYPE_FORMAL) && ((R4EFormalReview)review).getCurrent().getType().equals((Object)R4EReviewPhase.R4E_REVIEW_PHASE_PREPARATION)) {
                        try {
                            MailServicesProxy.sendItemsAddedNotification(addedItems);
                        }
                        catch (CoreException e) {
                            UIUtils.displayCoreErrorDialog(e);
                        }
                        catch (ResourceHandlingException e) {
                            UIUtils.displayResourceErrorDialog(e);
                        }
                    }
                    R4EUIModelController.setJobInProgress(false);
                    UIUtils.setNavigatorViewFocus((IR4EUIModelElement)selectedElements.get(0), 1);
                }
                R4EUIModelController.setJobInProgress(false);
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
        return null;
    }
}

