/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.internal.ui.player;

import org.eclipse.rcptt.tesla.core.protocol.GenericElementKind;
import org.eclipse.rcptt.tesla.internal.ui.player.PlayerTextUtils;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIElement;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIPlayer;
import org.eclipse.rcptt.tesla.swt.workbench.EclipseWorkbenchProvider;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.internal.WorkbenchPartReference;

public class WorkbenchUIElement
extends SWTUIElement {
    public IWorkbenchPartReference reference;

    public WorkbenchUIElement(IWorkbenchPartReference ref, SWTUIPlayer p) {
        super(null, p);
        this.reference = ref;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.reference == null ? 0 : this.reference.hashCode());
        return result;
    }

    @Override
    public GenericElementKind getKind() {
        return SWTUIPlayer.getKind(this.reference);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WorkbenchUIElement other = (WorkbenchUIElement)obj;
        return !(this.reference == null ? other.reference != null : !this.reference.equals(other.reference));
    }

    @Override
    public boolean match(Object c) {
        return this.reference != null && this.reference.equals(c);
    }

    @Override
    public String toString() {
        return this.reference == null ? "Empty" : this.reference.getClass().getSimpleName() + ":" + PlayerTextUtils.getText(this);
    }

    @Override
    public String getClassName() {
        return this.reference == null ? "null" : this.reference.getClass().getSimpleName();
    }

    public IWorkbenchPartReference getReference() {
        return this.reference;
    }

    public Menu getViewMenu() {
        IWorkbenchPart workbenchPart;
        if (this.isView() && this.reference != null && (workbenchPart = this.reference.getPart(false)) != null) {
            return EclipseWorkbenchProvider.getProvider().getViewMenu(workbenchPart, this.reference, true);
        }
        return null;
    }

    @Override
    public Rectangle getBounds() {
        Control pane;
        if (this.reference != null && (pane = ((WorkbenchPartReference)this.reference).getPane().getControl()) != null && !pane.isDisposed()) {
            Rectangle bounds = pane.getBounds();
            if (pane.getParent() != null) {
                Point point = pane.toDisplay(bounds.x, bounds.y);
                bounds.x = point.x;
                bounds.y = point.y;
            }
            return bounds;
        }
        return super.getBounds();
    }
}

