/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ctx.workbench.ui.views;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.rcptt.core.model.IContext;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.IQ7Project;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.model.search.ISearchScope;
import org.eclipse.rcptt.core.model.search.Q7SearchCore;
import org.eclipse.rcptt.core.scenario.FileEditor;
import org.eclipse.rcptt.core.scenario.NamedElement;
import org.eclipse.rcptt.ctx.workbench.ui.views.WorkspaceLabelProvider;
import org.eclipse.rcptt.internal.core.model.ReferencedProjectScope;
import org.eclipse.rcptt.internal.ui.Images;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.resources.WSUtils;
import org.eclipse.rcptt.resources.ui.viewers.WorkspaceContentProvider;
import org.eclipse.rcptt.workspace.WSFile;
import org.eclipse.rcptt.workspace.WSResource;
import org.eclipse.rcptt.workspace.WorkspaceContext;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;

public class SelectEditorFileDialog
extends Dialog {
    private Text text;
    private IQ7Project group;
    private String path = "";
    private static String DESCRIPTION_EMPTY_NAME = "Path must be non-blank string";
    private static String DESCRIPTION_DUPLICATE_NAME = "Current path is already added into context";
    protected ControlDecoration nameDecoration;
    private HashSet<String> disabledPaths = new HashSet();

    public SelectEditorFileDialog(Shell parentShell, IQ7Project group, List<Object> disabledFiles) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.group = group;
        for (Object file : disabledFiles) {
            if (!(file instanceof FileEditor)) continue;
            this.disabledPaths.add(((FileEditor)file).getPath());
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Select file path");
    }

    protected Point getInitialSize() {
        return new Point(520, 500);
    }

    public String getPath() {
        return this.path;
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.validate();
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        ((GridLayout)composite.getLayout()).numColumns = 2;
        composite.setLayoutData((Object)new GridData(1808));
        Label descriptionLabel = new Label(composite, 16448);
        descriptionLabel.setText("Enter file path to open or select file from the one of the workspace contexts");
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        descriptionLabel.setLayoutData((Object)data);
        Label filePathLabel = new Label(composite, 16384);
        filePathLabel.setText("File path: ");
        this.nameDecoration = new ControlDecoration((Control)filePathLabel, 131200);
        FieldDecoration errorFieldIndicator = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR");
        this.nameDecoration.setImage(errorFieldIndicator.getImage());
        this.nameDecoration.setShowHover(true);
        this.nameDecoration.hide();
        this.text = new Text(composite, 2048);
        data = new GridData(768);
        data.horizontalIndent = 5;
        this.text.setLayoutData((Object)data);
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SelectEditorFileDialog.this.path = SelectEditorFileDialog.this.text.getText();
                SelectEditorFileDialog.this.validate();
            }
        });
        this.createWorkspaces(composite);
        SelectEditorFileDialog.applyDialogFont((Control)composite);
        return composite;
    }

    private boolean validate() {
        boolean duplicate = this.disabledPaths.contains(this.path);
        boolean named = this.path.length() > 0;
        boolean validated = !duplicate && named;
        this.getButton(0).setEnabled(validated);
        if (validated) {
            this.nameDecoration.hide();
        } else {
            if (!duplicate) {
                this.nameDecoration.setDescriptionText(DESCRIPTION_EMPTY_NAME);
            } else {
                this.nameDecoration.setDescriptionText(DESCRIPTION_DUPLICATE_NAME);
            }
            this.nameDecoration.show();
        }
        return validated;
    }

    private void createWorkspaces(Composite parent) {
        IQ7NamedElement[] elements;
        Tree tree = new Tree(parent, 2048);
        TreeViewer viewer = new TreeViewer(tree);
        viewer.setLabelProvider((IBaseLabelProvider)new EditorLabelProvider(this.disabledPaths));
        viewer.setContentProvider((IContentProvider)new ContentProvider());
        ArrayList<WorkspaceContext> contexts = new ArrayList<WorkspaceContext>();
        IQ7NamedElement[] iQ7NamedElementArray = elements = Q7SearchCore.findAllElements((ISearchScope)new ReferencedProjectScope(this.group));
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IQ7NamedElement iq7NamedElement = iQ7NamedElementArray[n2];
            if (iq7NamedElement instanceof IContext) {
                try {
                    NamedElement element = iq7NamedElement.getNamedElement();
                    if (element instanceof WorkspaceContext) {
                        contexts.add((WorkspaceContext)element);
                    }
                }
                catch (ModelException e) {
                    Q7UIPlugin.log((Throwable)e);
                }
            }
            ++n2;
        }
        viewer.setInput((Object)contexts.toArray());
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                Object element = sel.getFirstElement();
                if (element instanceof WSFile) {
                    SelectEditorFileDialog.this.text.setText(WSUtils.getPath((WSResource)((WSFile)element)).toString());
                }
            }
        });
        viewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                Object element = sel.getFirstElement();
                if (element instanceof WSFile) {
                    SelectEditorFileDialog.this.text.setText(WSUtils.getPath((WSResource)((WSFile)element)).toString());
                    if (SelectEditorFileDialog.this.validate()) {
                        SelectEditorFileDialog.this.okPressed();
                    }
                }
            }
        });
        GridData data = new GridData(1808);
        data.horizontalSpan = 2;
        tree.setLayoutData((Object)data);
    }

    private class ContentProvider
    implements ITreeContentProvider {
        private WorkspaceContentProvider wcp = new WorkspaceContentProvider();

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof WorkspaceContext) {
                return this.wcp.getElements(parentElement);
            }
            return this.wcp.getChildren(parentElement);
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof WorkspaceContext) {
                return this.wcp.getElements(element).length > 0;
            }
            return this.wcp.hasChildren(element);
        }

        public Object[] getElements(Object inputElement) {
            return (Object[])inputElement;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class EditorLabelProvider
    extends StyledCellLabelProvider
    implements ILabelProvider {
        private WorkspaceLabelProvider wlp;
        private ItalicStyler styler;
        private Set<String> disabledItems;

        public EditorLabelProvider(Set<String> disabledItems) {
            super(1);
            this.styler = new ItalicStyler();
            this.wlp = new WorkspaceLabelProvider();
            this.disabledItems = disabledItems;
        }

        public void update(ViewerCell cell) {
            Object element = cell.getElement();
            StyledString styled = this.getStyledText(element);
            cell.setText(styled.getString());
            cell.setStyleRanges(styled.getStyleRanges());
            cell.setImage(this.getImage(element));
        }

        public StyledString getStyledText(Object element) {
            String elemPath;
            if (element instanceof WSFile && this.disabledItems.contains(elemPath = WSUtils.getPath((WSResource)((WSFile)element)).toString())) {
                StyledString styled = new StyledString(this.getText(element));
                int ind = styled.length() + 1;
                styled.append(" (already in use)");
                styled.setStyle(ind, styled.length() - ind, (StyledString.Styler)this.styler);
                return styled;
            }
            return new StyledString(this.getText(element));
        }

        public Image getImage(Object element) {
            if (element instanceof WorkspaceContext) {
                return Images.getImage((String)"icons/workspace.gif");
            }
            return this.wlp.getImage(element);
        }

        public String getText(Object element) {
            if (element instanceof WorkspaceContext) {
                return ((WorkspaceContext)element).getName();
            }
            return this.wlp.getText(element);
        }

        private class ItalicStyler
        extends StyledString.Styler {
            private ItalicStyler() {
            }

            public void applyStyles(TextStyle textStyle) {
                textStyle.foreground = Display.getCurrent().getSystemColor(16);
                textStyle.font = JFaceResources.getFontRegistry().getItalic("org.eclipse.jface.defaultfont");
            }
        }
    }
}

