/*
 * Decompiled with CFR 0.152.
 */
package com.gradleware.tooling.toolingmodel.repository.internal;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.gradleware.tooling.toolingmodel.OmniBuildInvocations;
import com.gradleware.tooling.toolingmodel.OmniProjectTask;
import com.gradleware.tooling.toolingmodel.OmniTaskSelector;
import com.gradleware.tooling.toolingmodel.Path;
import com.gradleware.tooling.toolingmodel.repository.internal.DefaultOmniProjectTask;
import com.gradleware.tooling.toolingmodel.repository.internal.DefaultOmniTaskSelector;
import java.util.List;
import org.gradle.tooling.model.DomainObjectSet;
import org.gradle.tooling.model.Task;
import org.gradle.tooling.model.TaskSelector;
import org.gradle.tooling.model.gradle.BuildInvocations;

public final class DefaultOmniBuildInvocations
implements OmniBuildInvocations {
    private final ImmutableList<OmniProjectTask> projectTasks;
    private final ImmutableList<OmniTaskSelector> taskSelectors;

    private DefaultOmniBuildInvocations(List<OmniProjectTask> projectTasks, List<OmniTaskSelector> taskSelectors) {
        this.projectTasks = ImmutableList.copyOf(projectTasks);
        this.taskSelectors = ImmutableList.copyOf(taskSelectors);
    }

    public ImmutableList<OmniProjectTask> getProjectTasks() {
        return this.projectTasks;
    }

    public ImmutableList<OmniTaskSelector> getTaskSelectors() {
        return this.taskSelectors;
    }

    public static DefaultOmniBuildInvocations from(BuildInvocations buildInvocations, Path projectPath) {
        return new DefaultOmniBuildInvocations((List<OmniProjectTask>)DefaultOmniBuildInvocations.createProjectTasks((DomainObjectSet<? extends Task>)buildInvocations.getTasks()), (List<OmniTaskSelector>)DefaultOmniBuildInvocations.createTaskSelectors((DomainObjectSet<? extends TaskSelector>)buildInvocations.getTaskSelectors(), projectPath));
    }

    private static ImmutableList<OmniProjectTask> createProjectTasks(DomainObjectSet<? extends Task> projectTasks) {
        return FluentIterable.from(projectTasks).transform((Function)new Function<Task, OmniProjectTask>(){

            public OmniProjectTask apply(Task input) {
                return DefaultOmniProjectTask.from(input);
            }
        }).toList();
    }

    private static ImmutableList<OmniTaskSelector> createTaskSelectors(DomainObjectSet<? extends TaskSelector> taskSelectors, final Path projectPath) {
        return FluentIterable.from(taskSelectors).transform((Function)new Function<TaskSelector, OmniTaskSelector>(){

            public OmniTaskSelector apply(TaskSelector input) {
                return DefaultOmniTaskSelector.from(input, projectPath);
            }
        }).toList();
    }

    public static DefaultOmniBuildInvocations from(List<OmniProjectTask> projectTasks, List<OmniTaskSelector> taskSelectors) {
        return new DefaultOmniBuildInvocations(projectTasks, taskSelectors);
    }
}

