/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.arduino.ui.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.arduino.core.internal.board.ArduinoLibrary;
import org.eclipse.cdt.arduino.core.internal.board.ArduinoManager;
import org.eclipse.cdt.arduino.core.internal.board.ArduinoPlatform;
import org.eclipse.cdt.arduino.ui.internal.Activator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;

public class LibraryTree
extends FilteredTree {
    private static final String PLATFORMS = "Platform Libraries";
    private static final String UNCATEGORIZED = "Others";
    private boolean includePlatforms;
    private Set<ArduinoLibrary> checkedLibs = new HashSet<ArduinoLibrary>();
    private ArduinoManager manager = Activator.getService(ArduinoManager.class);

    public LibraryTree(Composite parent) {
        super(parent, 2848, (PatternFilter)new LibPatternFilter(), true);
        TreeViewer viewer = this.getViewer();
        viewer.setContentProvider((IContentProvider)new ContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        Tree tree = viewer.getTree();
        tree.setHeaderVisible(true);
        TreeColumn column1 = new TreeColumn(tree, 16384);
        column1.setText("Library");
        column1.setWidth(200);
        TreeColumn column2 = new TreeColumn(tree, 16384);
        column2.setText("Version");
        column2.setWidth(100);
        TreeColumn column3 = new TreeColumn(tree, 16384);
        column3.setText("Description");
        column3.setWidth(300);
    }

    public void setIncludePlatforms(boolean includePlatforms) {
        this.includePlatforms = includePlatforms;
    }

    public void setChecked(Collection<ArduinoLibrary> checkedLibs) {
        this.checkedLibs = new HashSet<ArduinoLibrary>(checkedLibs);
    }

    public Collection<ArduinoLibrary> getChecked() {
        return this.checkedLibs;
    }

    protected TreeViewer doCreateTreeViewer(Composite parent, int style) {
        CheckboxTreeViewer viewer = new CheckboxTreeViewer(parent, style);
        viewer.setCheckStateProvider(new ICheckStateProvider(){

            public boolean isGrayed(Object element) {
                block9: {
                    block8: {
                        if (!(element instanceof String)) break block8;
                        String category = (String)element;
                        if (category == LibraryTree.PLATFORMS) {
                            for (ArduinoLibrary lib : LibraryTree.this.checkedLibs) {
                                if (lib.getPlatform() == null) continue;
                                return true;
                            }
                        } else if (category == LibraryTree.UNCATEGORIZED) {
                            for (ArduinoLibrary lib : LibraryTree.this.checkedLibs) {
                                if (lib.getPlatform() != null || lib.getCategory() != null) continue;
                                return true;
                            }
                        } else {
                            for (ArduinoLibrary lib : LibraryTree.this.checkedLibs) {
                                if (!element.equals(lib.getCategory())) continue;
                                return true;
                            }
                        }
                        break block9;
                    }
                    if (!(element instanceof ArduinoPlatform)) break block9;
                    for (ArduinoLibrary lib : LibraryTree.this.checkedLibs) {
                        if (element != lib.getPlatform()) continue;
                        return true;
                    }
                }
                return false;
            }

            public boolean isChecked(Object element) {
                if (element instanceof ArduinoLibrary) {
                    return LibraryTree.this.checkedLibs.contains(element);
                }
                return this.isGrayed(element);
            }
        });
        viewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object element = event.getElement();
                if (element instanceof ArduinoLibrary) {
                    if (event.getChecked()) {
                        LibraryTree.this.checkedLibs.add((ArduinoLibrary)element);
                    } else {
                        LibraryTree.this.checkedLibs.remove(element);
                    }
                } else if (element instanceof String && !event.getChecked()) {
                    for (ArduinoLibrary lib : new ArrayList(LibraryTree.this.checkedLibs)) {
                        if (!element.equals(lib.getCategory())) continue;
                        LibraryTree.this.checkedLibs.remove(lib);
                    }
                }
            }
        });
        return viewer;
    }

    public class ContentProvider
    implements ITreeContentProvider {
        public Map<String, List<ArduinoLibrary>> categories = new HashMap<String, List<ArduinoLibrary>>();
        public List<ArduinoLibrary> uncategorized;

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput == null) {
                return;
            }
            Collection libraries = (Collection)newInput;
            for (ArduinoLibrary library : libraries) {
                if (library.getPlatform() != null) continue;
                String category = library.getCategory();
                if (category != null) {
                    List<ArduinoLibrary> libs = this.categories.get(category);
                    if (libs == null) {
                        libs = new ArrayList<ArduinoLibrary>();
                        this.categories.put(category, libs);
                    }
                    libs.add(library);
                    continue;
                }
                if (this.uncategorized == null) {
                    this.uncategorized = new ArrayList<ArduinoLibrary>();
                }
                this.uncategorized.add(library);
            }
        }

        public Object[] getElements(Object inputElement) {
            ArrayList<String> elements = new ArrayList<String>(this.categories.keySet());
            Collections.sort(elements, (o1, o2) -> o1.compareToIgnoreCase((String)o2));
            if (this.uncategorized != null) {
                elements.add(LibraryTree.UNCATEGORIZED);
            }
            if (LibraryTree.this.includePlatforms) {
                elements.add(LibraryTree.PLATFORMS);
            }
            return elements.toArray();
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof String) {
                if (parentElement == LibraryTree.UNCATEGORIZED) {
                    return this.uncategorized.toArray();
                }
                if (parentElement == LibraryTree.PLATFORMS) {
                    ArrayList<ArduinoPlatform> platforms = new ArrayList<ArduinoPlatform>();
                    try {
                        for (ArduinoPlatform platform : LibraryTree.this.manager.getInstalledPlatforms()) {
                            if (platform.getLibraries().isEmpty()) continue;
                            platforms.add(platform);
                        }
                    }
                    catch (CoreException e) {
                        Activator.log((Exception)((Object)e));
                    }
                    Collections.sort(platforms, (o1, o2) -> o1.getName().compareToIgnoreCase(o2.getName()));
                    return platforms.toArray();
                }
                String category = (String)parentElement;
                List<ArduinoLibrary> libs = this.categories.get(category);
                Collections.sort(libs, (o1, o2) -> o1.getName().compareToIgnoreCase(o2.getName()));
                return libs.toArray();
            }
            if (parentElement instanceof ArduinoPlatform) {
                try {
                    ArrayList libs = new ArrayList(((ArduinoPlatform)parentElement).getLibraries());
                    Collections.sort(libs, (o1, o2) -> o1.getName().compareToIgnoreCase(o2.getName()));
                    return libs.toArray();
                }
                catch (CoreException e) {
                    Activator.log((Exception)((Object)e));
                }
            }
            return null;
        }

        public Object getParent(Object element) {
            if (element instanceof ArduinoLibrary) {
                ArduinoLibrary library = (ArduinoLibrary)element;
                ArduinoPlatform platform = library.getPlatform();
                if (platform != null) {
                    return platform;
                }
                String category = library.getCategory();
                return category != null ? category : LibraryTree.UNCATEGORIZED;
            }
            if (element instanceof ArduinoPlatform) {
                return ((ArduinoPlatform)element).getName();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof String || element instanceof ArduinoPlatform;
        }
    }

    private static class LabelProvider
    extends BaseLabelProvider
    implements ITableLabelProvider {
        private LabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof String) {
                return columnIndex == 0 ? (String)element : null;
            }
            if (element instanceof ArduinoPlatform) {
                return columnIndex == 0 ? ((ArduinoPlatform)element).getName() : null;
            }
            if (element instanceof ArduinoLibrary) {
                ArduinoLibrary library = (ArduinoLibrary)element;
                switch (columnIndex) {
                    case 0: {
                        return library.getName();
                    }
                    case 1: {
                        return library.getVersion();
                    }
                    case 2: {
                        return library.getSentence();
                    }
                }
                return null;
            }
            return null;
        }
    }

    private static class LibPatternFilter
    extends PatternFilter {
        private LibPatternFilter() {
        }

        protected boolean isLeafMatch(Viewer viewer, Object element) {
            if (element instanceof String) {
                return this.wordMatches((String)element);
            }
            if (element instanceof ArduinoLibrary) {
                ArduinoLibrary lib = (ArduinoLibrary)element;
                return this.wordMatches(lib.getName()) || this.wordMatches(lib.getSentence()) || this.wordMatches(lib.getParagraph());
            }
            return false;
        }
    }
}

