/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.corrosion;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.corrosion.CommandJob;
import org.eclipse.corrosion.CorrosionPlugin;
import org.eclipse.corrosion.CorrosionPreferenceInitializer;
import org.eclipse.corrosion.Messages;
import org.eclipse.corrosion.RustManager;
import org.eclipse.corrosion.ui.InputComponent;
import org.eclipse.corrosion.ui.OptionalDefaultInputComponent;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.osgi.framework.Bundle;

public class CorrosionPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String PAGE_ID = "org.eclipse.corrosion.preferencePage";
    protected static final List<String> RUST_SOURCE_OPTIONS = Arrays.asList("rustup", "other", "disabled");
    protected static final List<String> RUSTUP_TOOLCHAIN_OPTIONS = Arrays.asList("Stable", "Beta", "Nightly", "Other");
    private IPreferenceStore store;
    private Button rustupRadioButton;
    private Button otherRadioButton;
    private Button disableRadioButton;
    private Button installButton;
    private Button useDefaultPathsCheckbox;
    private InputComponent rustupInput;
    private InputComponent cargoInput;
    private InputComponent workingDirectoryInput;
    private boolean installInProgress = false;
    private Label rustupToolchainLabel;
    private Combo rustupToolchainCombo;
    private Composite otherIdComposite;
    private InputComponent otherIdInput;
    private InputComponent rlsInput;
    private InputComponent sysrootInput;

    public void init(IWorkbench workbench) {
        this.store = this.doGetPreferenceStore();
    }

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(4, false));
        this.createCommandPathsPart(container);
        Label rlsLocationLabel = new Label(container, 0);
        rlsLocationLabel.setText(Messages.CorrosionPreferencePage_rlsLocation);
        rlsLocationLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 4, 1));
        this.disableRadioButton = new Button(container, 16);
        this.disableRadioButton.setText(Messages.CorrosionPreferencePage_disableRustEdition);
        this.disableRadioButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 4, 1));
        this.disableRadioButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.setRadioSelection(2)));
        this.otherRadioButton = new Button(container, 16);
        this.otherRadioButton.setText(Messages.CorrosionPreferencePage_otherInstallation);
        this.otherRadioButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 4, 1));
        this.otherRadioButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.setRadioSelection(1)));
        this.createOtherPart(container);
        this.rustupRadioButton = new Button(container, 16);
        this.rustupRadioButton.setText(Messages.CorrosionPreferencePage_useRustup);
        this.rustupRadioButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 4, 1));
        this.rustupRadioButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.setRadioSelection(0)));
        this.createRustupPart(container);
        this.initializeContent();
        return container;
    }

    private void initializeContent() {
        int sourceIndex = RUST_SOURCE_OPTIONS.indexOf(this.store.getString("corrosion.rustSource"));
        this.setRadioSelection(sourceIndex);
        int toolchainIndex = RUSTUP_TOOLCHAIN_OPTIONS.indexOf(this.store.getString("corrosion.rustup_toolchain_type"));
        String toolchainId = this.store.getString("corrosion.rustup_toolchain_Id");
        this.otherIdInput.setValue(toolchainId);
        int i = 0;
        while (i < RUSTUP_TOOLCHAIN_OPTIONS.size()) {
            if (RUSTUP_TOOLCHAIN_OPTIONS.get(i).equalsIgnoreCase(toolchainId.toLowerCase())) {
                toolchainIndex = i;
                break;
            }
            ++i;
        }
        this.setToolchainSelection(toolchainIndex);
        this.rustupInput.setValue(this.store.getString("corrosion.rustup_rustupPath"));
        this.cargoInput.setValue(this.store.getString("corrosion.rustup_cargoPath"));
        this.setDefaultPathsSelection(this.store.getBoolean("corrosion.rustup_defaultPaths"));
        this.rlsInput.setValue(this.store.getString("corrosion.rslPath"));
        this.sysrootInput.setValue(this.store.getString("corrosion.sysrootPath"));
        this.workingDirectoryInput.setValue(this.store.getString("corrosion.workingDirectory"));
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return CorrosionPlugin.getDefault().getPreferenceStore();
    }

    private boolean isPageValid() {
        if (!this.isCommandPathsValid()) {
            return false;
        }
        int radioIndex = this.getRadioSelection();
        return radioIndex == 0 && this.isRustupSectionValid() || radioIndex == 1 && this.isOtherInstallSectionValid() || radioIndex == 2;
    }

    private boolean isCommandPathsValid() {
        String error = "";
        if (this.rustupInput.getValue().isEmpty() || this.cargoInput.getValue().isEmpty()) {
            error = Messages.CorrosionPreferencePage_emptyRustupCargoPath;
        } else {
            File rustup = new File(this.varParse(this.rustupInput.getValue()));
            File cargo = new File(this.varParse(this.cargoInput.getValue()));
            if (!rustup.exists() || !rustup.isFile()) {
                error = Messages.CorrosionPreferencePage_invalidRustup;
            } else if (!rustup.canExecute()) {
                error = Messages.CorrosionPreferencePage_rustupNonExecutable;
            } else if (!CorrosionPlugin.validateCommandVersion(this.varParse(this.rustupInput.getValue()), RustManager.RUSTUP_VERSION_FORMAT_PATTERN)) {
                error = NLS.bind((String)Messages.CorrosionPreferencePage_invalidVersion, (Object)"rustup");
            } else if (!cargo.exists() || !cargo.isFile()) {
                error = Messages.CorrosionPreferencePage_invalidCargo;
            } else if (!cargo.canExecute()) {
                error = Messages.CorrosionPreferencePage_cargoNonExecutable;
            } else if (!CorrosionPlugin.validateCommandVersion(this.varParse(this.cargoInput.getValue()), RustManager.CARGO_VERSION_FORMAT_PATTERN)) {
                error = NLS.bind((String)Messages.CorrosionPreferencePage_invalidVersion, (Object)"cargo");
            }
        }
        if (!error.isEmpty()) {
            this.setErrorMessage(error);
            this.setInstallRequired(true);
            return false;
        }
        File workingDirectory = new File(this.varParse(this.workingDirectoryInput.getValue()));
        if (this.workingDirectoryInput.getValue().isEmpty()) {
            error = Messages.CorrosionPreferencePage_emptyWorkingDirectory;
        } else if (!workingDirectory.isDirectory() || !workingDirectory.exists()) {
            error = Messages.CorrosionPreferencePage_invaildWorkingDirectory;
        }
        if (!error.isEmpty()) {
            this.setErrorMessage(error);
        }
        return error.isEmpty();
    }

    private boolean isRustupSectionValid() {
        if (this.rustupToolchainCombo.getSelectionIndex() == 3 && this.otherIdInput.getValue().isEmpty()) {
            this.setErrorMessage(Messages.CorrosionPreferencePage_emptyToolchain);
            return false;
        }
        String rlsPath = String.valueOf(this.varParse(this.rustupInput.getValue())) + " run " + this.getToolchainId() + " rls";
        if (!CorrosionPlugin.validateCommandVersion(rlsPath, RustManager.RLS_VERSION_FORMAT_PATTERN)) {
            this.setErrorMessage(Messages.CorrosionPreferencePage_rustupMissingRLS);
            this.setInstallRequired(true);
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    private boolean isOtherInstallSectionValid() {
        if (this.rlsInput.getValue().isEmpty() || this.sysrootInput.getValue().isEmpty()) {
            this.setErrorMessage(Messages.CorrosionPreferencePage_emptyPath);
            return false;
        }
        File rls = new File(this.varParse(this.rlsInput.getValue()));
        if (!rls.exists() || !rls.isFile()) {
            this.setErrorMessage(Messages.CorrosionPreferencePage_invalidRlsPath);
            return false;
        }
        if (!rls.canExecute()) {
            this.setErrorMessage(Messages.CorrosionPreferencePage_rlsNonExecutable);
            return false;
        }
        if (!CorrosionPlugin.validateCommandVersion(this.varParse(this.rlsInput.getValue()), RustManager.RLS_VERSION_FORMAT_PATTERN)) {
            this.setErrorMessage(NLS.bind((String)Messages.CorrosionPreferencePage_invalidVersion, (Object)"rls"));
            return false;
        }
        File sysrootPath = new File(this.varParse(this.sysrootInput.getValue()));
        boolean a = sysrootPath.exists();
        boolean b = sysrootPath.isDirectory();
        if (!a || !b) {
            this.setErrorMessage(Messages.CorrosionPreferencePage_invalidSysroot);
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    private String varParse(String unparsedString) {
        IStringVariableManager manager = VariablesPlugin.getDefault().getStringVariableManager();
        try {
            return manager.performStringSubstitution(unparsedString);
        }
        catch (CoreException e) {
            return unparsedString;
        }
    }

    protected void performDefaults() {
        int sourceIndex = RUST_SOURCE_OPTIONS.indexOf(this.store.getDefaultString("corrosion.rustSource"));
        this.setRadioSelection(sourceIndex);
        int toolchainIndex = RUSTUP_TOOLCHAIN_OPTIONS.indexOf(this.store.getDefaultString("corrosion.rustup_toolchain_type"));
        String toolchainId = this.store.getDefaultString("corrosion.rustup_toolchain_Id");
        this.otherIdInput.setValue(toolchainId);
        int i = 0;
        while (i < RUSTUP_TOOLCHAIN_OPTIONS.size()) {
            if (RUSTUP_TOOLCHAIN_OPTIONS.get(i).equalsIgnoreCase(toolchainId.toLowerCase())) {
                toolchainIndex = i;
                break;
            }
            ++i;
        }
        this.setToolchainSelection(toolchainIndex);
        this.setDefaultPathsSelection(this.store.getDefaultBoolean("corrosion.rustup_defaultPaths"));
        this.rustupInput.setValue(this.store.getDefaultString("corrosion.rustup_rustupPath"));
        this.cargoInput.setValue(this.store.getDefaultString("corrosion.rustup_cargoPath"));
        this.rlsInput.setValue(this.store.getDefaultString("corrosion.rslPath"));
        this.sysrootInput.setValue(this.store.getDefaultString("corrosion.sysrootPath"));
        this.workingDirectoryInput.setValue(this.store.getDefaultString("corrosion.workingDirectory"));
        super.performDefaults();
    }

    private void setDefaultPathsSelection(boolean selection) {
        this.useDefaultPathsCheckbox.setSelection(selection);
        if (selection) {
            this.rustupInput.setValue(this.store.getDefaultString("corrosion.rustup_rustupPath"));
            this.cargoInput.setValue(this.store.getDefaultString("corrosion.rustup_cargoPath"));
        }
        this.setDefaultPathsEnabled(!selection);
    }

    private void setToolchainSelection(int selection) {
        this.rustupToolchainCombo.select(selection);
        GridData otherIdData = (GridData)this.otherIdComposite.getLayoutData();
        otherIdData.exclude = selection != 3;
        this.otherIdComposite.getParent().layout();
        this.otherIdComposite.setVisible(!otherIdData.exclude);
        this.otherIdComposite.getParent().getParent().layout(true);
    }

    private int getRadioSelection() {
        if (this.rustupRadioButton.getSelection()) {
            return 0;
        }
        if (this.otherRadioButton.getSelection()) {
            return 1;
        }
        return 2;
    }

    private void setRadioSelection(int selection) {
        this.setOtherEnabled(false);
        this.setRustupEnabled(false);
        this.rustupRadioButton.setSelection(false);
        this.otherRadioButton.setSelection(false);
        this.disableRadioButton.setSelection(false);
        if (selection == 0) {
            this.rustupRadioButton.setSelection(true);
            this.setRustupEnabled(true);
        } else if (selection == 1) {
            this.otherRadioButton.setSelection(true);
            this.setOtherEnabled(true);
        } else {
            this.disableRadioButton.setSelection(true);
        }
        this.isPageValid();
    }

    public boolean performOk() {
        int source = this.getRadioSelection();
        this.store.setValue("corrosion.rustSource", RUST_SOURCE_OPTIONS.get(source));
        this.store.setValue("corrosion.workingDirectory", this.workingDirectoryInput.getValue());
        if (source == 0) {
            this.store.setValue("corrosion.rustup_toolchain_type", this.rustupToolchainCombo.getText());
            this.store.setValue("corrosion.rustup_defaultPaths", this.useDefaultPathsCheckbox.getSelection());
            this.store.setValue("corrosion.rustup_rustupPath", this.rustupInput.getValue());
            this.store.setValue("corrosion.rustup_cargoPath", this.cargoInput.getValue());
            String id = this.getToolchainId();
            if (!this.store.getString("corrosion.rustup_toolchain_Id").equals(id)) {
                RustManager.setDefaultToolchain(id);
                this.store.setValue("corrosion.rustup_toolchain_Id", id);
            }
        } else if (source == 1) {
            this.store.setValue("corrosion.rslPath", this.rlsInput.getValue());
            this.store.setValue("corrosion.sysrootPath", this.sysrootInput.getValue());
        }
        return true;
    }

    private String getToolchainId() {
        int index = this.rustupToolchainCombo.getSelectionIndex();
        if (index == -1) {
            return "";
        }
        if (index < 3) {
            return RUSTUP_TOOLCHAIN_OPTIONS.get(index).toLowerCase();
        }
        return this.otherIdInput.getValue();
    }

    private void createCommandPathsPart(Composite container) {
        Composite parent = new Composite(container, 0);
        parent.setLayout((Layout)new GridLayout(4, false));
        parent.setLayoutData((Object)new GridData(4, 4, true, true, 4, 1));
        this.useDefaultPathsCheckbox = new Button(parent, 32);
        this.useDefaultPathsCheckbox.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 3, 1));
        this.useDefaultPathsCheckbox.setText(Messages.CorrosionPreferencePage_useDefaultPathsRustupCargo);
        this.useDefaultPathsCheckbox.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.setDefaultPathsEnabled(!this.useDefaultPathsCheckbox.getSelection());
            if (this.useDefaultPathsCheckbox.getSelection()) {
                this.rustupInput.setValue(this.store.getDefaultString("corrosion.rustup_rustupPath"));
                this.cargoInput.setValue(this.store.getDefaultString("corrosion.rustup_cargoPath"));
            }
            this.setValid(this.isPageValid());
        }));
        this.installButton = new Button(parent, 0);
        this.installButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.installButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            if (Platform.getOS().equals("win32")) {
                Program.launch((String)"https://rustup.rs/");
            } else {
                this.installCommands();
            }
        }));
        this.rustupInput = new InputComponent(parent, Messages.CorrosionPreferencePage_Rustup, e -> this.setValid(this.isPageValid()));
        this.rustupInput.createComponent();
        this.rustupInput.createVariableSelection();
        this.rustupInput.createFileSelection();
        this.cargoInput = new InputComponent(parent, Messages.CorrosionPreferencePage_caro, e -> this.setValid(this.isPageValid()));
        this.cargoInput.createComponent();
        this.cargoInput.createVariableSelection();
        this.cargoInput.createFileSelection();
        this.workingDirectoryInput = new OptionalDefaultInputComponent(container, Messages.LaunchUI_workingDirectory, e -> this.setValid(this.isPageValid()), () -> this.store.getString("corrosion.workingDirectory"));
        this.workingDirectoryInput.createComponent();
        GridData wdTextData = this.workingDirectoryInput.getTextGridData();
        wdTextData.widthHint = this.convertWidthInCharsToPixels(40);
        this.workingDirectoryInput.setTextGridData(wdTextData);
        this.workingDirectoryInput.createVariableSelection();
        this.workingDirectoryInput.createFolderSelection();
    }

    private void installCommands() {
        String[] command;
        this.installButton.setText(Messages.CorrosionPreferencePage_installing);
        this.installButton.setEnabled(false);
        try {
            Bundle bundle = CorrosionPlugin.getDefault().getBundle();
            URL fileURL = FileLocator.toFileURL((URL)bundle.getEntry("scripts/rustup-init.sh"));
            File file = new File(new URI(fileURL.getProtocol(), fileURL.getPath(), null));
            if (!file.setExecutable(true)) {
                CorrosionPlugin.showError(Messages.CorrosionPreferencePage_cannotInstallRustupCargo, Messages.CorrosionPreferencePage_cannotInstallRustupCargo_details);
                return;
            }
            command = new String[]{String.valueOf(file.getAbsolutePath()) + " -y"};
        }
        catch (IOException | URISyntaxException e) {
            CorrosionPlugin.showError(Messages.CorrosionPreferencePage_cannotInstallRustupCargo, Messages.CorrosionPreferencePage_cannotInstallRustupCargo_details, e);
            return;
        }
        CommandJob installCommandJob = new CommandJob(command, Messages.CorrosionPreferencePage_installingRustupCargo, Messages.CorrosionPreferencePage_cannotInstallRustupCargo, Messages.CorrosionPreferencePage_cannotInstallRustupCargo_details, 15);
        final String toolchain = this.getToolchainId();
        installCommandJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getResult() == Status.OK_STATUS) {
                    CorrosionPreferenceInitializer initializer = new CorrosionPreferenceInitializer();
                    initializer.initializeDefaultPreferences();
                    Job setDefaultToolchainJob = RustManager.setDefaultToolchain(toolchain.isEmpty() ? RUSTUP_TOOLCHAIN_OPTIONS.get(0).toLowerCase() : toolchain);
                    setDefaultToolchainJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                        public void done(IJobChangeEvent event) {
                            CorrosionPreferencePage.this.installInProgress = false;
                            Display.getDefault().asyncExec(() -> {
                                if (CorrosionPreferencePage.this.installButton.isDisposed()) {
                                    return;
                                }
                                CorrosionPreferencePage.this.setInstallRequired(false);
                                CorrosionPreferencePage.this.performDefaults();
                                CorrosionPreferencePage.this.setValid(CorrosionPreferencePage.this.isPageValid());
                            });
                        }
                    });
                } else {
                    CorrosionPreferencePage.this.installInProgress = false;
                }
            }
        });
        this.installInProgress = true;
        installCommandJob.schedule();
    }

    private void setInstallRequired(Boolean required) {
        if (this.installInProgress) {
            return;
        }
        if (required.booleanValue()) {
            this.installButton.setText(Messages.CorrosionPreferencePage_install);
        } else {
            this.installButton.setText(Messages.CorrosionPreferencePage_installed);
        }
        this.installButton.setEnabled(required.booleanValue());
    }

    private void createRustupPart(Composite container) {
        Composite parent = new Composite(container, 0);
        parent.setLayout((Layout)new GridLayout(4, false));
        parent.setLayoutData((Object)new GridData(4, 4, true, true, 4, 1));
        this.rustupToolchainLabel = new Label(parent, 0);
        this.rustupToolchainLabel.setText(Messages.CorrosionPreferencePage_toolchain);
        GridData rustupToolchainGridData = new GridData(131072, 0x1000000, false, false);
        rustupToolchainGridData.horizontalIndent = 25;
        this.rustupToolchainLabel.setLayoutData((Object)rustupToolchainGridData);
        this.rustupToolchainCombo = new Combo(parent, 12);
        this.rustupToolchainCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        for (String toolchain : RUSTUP_TOOLCHAIN_OPTIONS) {
            this.rustupToolchainCombo.add(toolchain);
        }
        this.rustupToolchainCombo.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.setToolchainSelection(this.rustupToolchainCombo.getSelectionIndex());
            this.getShell().pack();
            this.getShell().layout();
            this.setValid(this.isPageValid());
        }));
        new Label(parent, 0);
        new Label(parent, 0);
        this.otherIdComposite = new Composite(parent, 0);
        this.otherIdComposite.setLayout((Layout)new GridLayout(3, false));
        GridData otherIdData = new GridData(4, 0x1000000, true, false);
        otherIdData.exclude = false;
        this.otherIdComposite.setLayoutData((Object)otherIdData);
        this.otherIdInput = new InputComponent(this.otherIdComposite, Messages.CorrosionPreferencePage_id, e -> this.setValid(this.isPageValid()));
        this.otherIdInput.createComponent();
        new Label(parent, 0);
    }

    private void setDefaultPathsEnabled(boolean enabled) {
        this.rustupInput.setEnabled(enabled);
        this.cargoInput.setEnabled(enabled);
    }

    private void setRustupEnabled(boolean enabled) {
        this.rustupToolchainLabel.setEnabled(enabled);
        this.rustupToolchainCombo.setEnabled(enabled);
        this.otherIdInput.setEnabled(enabled);
    }

    private void createOtherPart(Composite container) {
        Composite parent = new Composite(container, 0);
        parent.setLayout((Layout)new GridLayout(4, false));
        parent.setLayoutData((Object)new GridData(4, 4, true, true, 4, 1));
        GridData labelIndent = new GridData(4, 0x1000000, true, false, 4, 1);
        labelIndent.horizontalIndent = 25;
        GridData textIndent = new GridData(4, 0x1000000, true, false);
        textIndent.horizontalIndent = 50;
        textIndent.widthHint = this.convertWidthInCharsToPixels(50);
        this.rlsInput = new InputComponent(parent, Messages.CorrosionPreferencePage_rlsPath, e -> this.setValid(this.isPageValid()));
        this.rlsInput.createComponent();
        this.rlsInput.createVariableSelection();
        this.rlsInput.createFileSelection();
        this.rlsInput.setLabelGridData(labelIndent);
        this.rlsInput.setTextGridData(textIndent);
        this.sysrootInput = new InputComponent(parent, Messages.CorrosionPreferencePage_sysrootPath, e -> this.setValid(this.isPageValid()));
        this.sysrootInput.createComponent();
        this.sysrootInput.createVariableSelection();
        this.sysrootInput.createFileSelection();
        this.sysrootInput.setLabelGridData(labelIndent);
        this.sysrootInput.setTextGridData(textIndent);
    }

    private void setOtherEnabled(boolean enabled) {
        this.rlsInput.setEnabled(enabled);
        this.sysrootInput.setEnabled(enabled);
    }
}

