/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.corrosion.edit;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.corrosion.CorrosionPlugin;
import org.eclipse.corrosion.Messages;
import org.eclipse.corrosion.RustManager;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.lsp4e.server.StreamConnectionProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class RLSStreamConnectionProvider
implements StreamConnectionProvider {
    private static boolean hasCancelledSetup = false;
    private Process process;

    public void start() throws IOException {
        String rls = RustManager.getRLS();
        if (rls.isEmpty() || !RustManager.setSystemProperties() || !CorrosionPlugin.validateCommandVersion(rls, RustManager.RLS_VERSION_FORMAT_PATTERN)) {
            this.showSetupRustNotification();
            return;
        }
        this.process = CorrosionPlugin.getProcessForCommand(rls);
    }

    private void showSetupRustNotification() {
        Display.getDefault().asyncExec(() -> {
            if (hasCancelledSetup) {
                return;
            }
            RLSStreamConnectionProvider.setHasCancelledSetup(true);
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            int dialogResponse = MessageDialog.open((int)5, (Shell)shell, (String)Messages.RLSStreamConnectionProvider_rustSupportNotFound, (String)Messages.RLSStreamConnectionProvider_requirementsNotFound, (int)0, (String[])new String[]{Messages.RLSStreamConnectionProvider_OpenPreferences, IDialogConstants.CANCEL_LABEL});
            if (dialogResponse == 0) {
                PreferenceDialog preferenceDialog = PreferencesUtil.createPreferenceDialogOn((Shell)shell, (String)"org.eclipse.corrosion.preferencePage", (String[])new String[]{"org.eclipse.corrosion.preferencePage"}, null);
                preferenceDialog.setBlockOnOpen(true);
                preferenceDialog.open();
                RLSStreamConnectionProvider.setHasCancelledSetup(false);
            }
        });
    }

    private static synchronized void setHasCancelledSetup(Boolean newValue) {
        hasCancelledSetup = newValue;
    }

    public InputStream getInputStream() {
        return this.process == null ? null : this.process.getInputStream();
    }

    public OutputStream getOutputStream() {
        return this.process == null ? null : this.process.getOutputStream();
    }

    public void stop() {
        if (this.process != null) {
            this.process.destroy();
        }
    }

    public InputStream getErrorStream() {
        return this.process == null ? null : this.process.getErrorStream();
    }
}

