/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.subquery;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.datatools.modelbase.sql.query.QueryExpressionRoot;
import org.eclipse.datatools.modelbase.sql.query.QuerySelectStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryValueExpression;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionScalarSelect;
import org.eclipse.datatools.sqltools.parsers.sql.SQLParserException;
import org.eclipse.datatools.sqltools.parsers.sql.SQLParserInternalException;
import org.eclipse.datatools.sqltools.sqlbuilder.Messages;
import org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.ExpressionBuilderWizard;
import org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.subquery.SubQueryWizard;
import org.eclipse.datatools.sqltools.sqlbuilder.model.ExpressionHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SQLDomainModel;
import org.eclipse.datatools.sqltools.sqlbuilder.util.ViewUtility;
import org.eclipse.datatools.sqltools.sqlbuilder.util.WorkbenchUtility;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.PageBook;

public class SubQueryPage
extends WizardPage
implements SelectionListener {
    private SQLDomainModel domainModel;
    private QueryValueExpression inputSQLExpression;
    private Text newExpressionText;
    private QueryExpressionRoot choiceQueryExpr;
    private Button existingSelectButton;
    private Button createNewSelectButton;
    private PageBook pageBook;
    private Composite mainPanel;
    private Composite existingSelectWorkArea;
    private Composite createNewSelectWorkArea;
    private Text freeFormText;
    Combo queryStatementCombo;
    List stmtsList = new ArrayList(0);

    public SubQueryPage(SQLDomainModel domainModel, QueryValueExpression sqlExpr) {
        super(Messages._UI_WIZARD_SUBQUERY_HEADING);
        this.setTitle(Messages._UI_WIZARD_SUBQUERY_HEADING);
        this.setDescription(Messages._UI_WIZARD_SUBQUERY_EXPL);
        this.setPageComplete(false);
        this.domainModel = domainModel;
        this.inputSQLExpression = sqlExpr;
    }

    public void createControl(Composite parent) {
        this.mainPanel = new Composite(parent, 0);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.mainPanel, "org.eclipse.datatools.sqltools.sqlbuilder.sqle0900");
        GridLayout mainPanelLayout = new GridLayout();
        this.mainPanel.setLayout((Layout)mainPanelLayout);
        this.mainPanel.setLayoutData((Object)ViewUtility.createFill());
        Label infoLabel = new Label(this.mainPanel, 16640);
        infoLabel.setText(Messages._UI_LABEL_CHOICES);
        infoLabel.setLayoutData((Object)ViewUtility.createHorizontalFill());
        this.existingSelectButton = new Button(this.mainPanel, 16);
        this.existingSelectButton.setText(Messages._UI_RADIO_EXISTING_STATEMENTS);
        this.existingSelectButton.addSelectionListener((SelectionListener)this);
        this.existingSelectButton.setSelection(true);
        this.createNewSelectButton = new Button(this.mainPanel, 16);
        this.createNewSelectButton.setText(Messages._UI_RADIO_SCRATCH_SELECT);
        this.createNewSelectButton.addSelectionListener((SelectionListener)this);
        this.createNewSelectButton.setSelection(false);
        this.pageBook = new PageBook(this.mainPanel, 0);
        this.existingSelectWorkArea = new Composite((Composite)this.pageBook, 0);
        this.existingSelectWorkArea.setLayout((Layout)new GridLayout());
        this.existingSelectWorkArea.setLayoutData((Object)ViewUtility.createFill());
        this.queryStatementCombo = ViewUtility.createComboBox(this.existingSelectWorkArea);
        this.queryStatementCombo.addSelectionListener((SelectionListener)this);
        Label previewFunctionLabel = new Label(this.existingSelectWorkArea, 16640);
        previewFunctionLabel.setText(Messages._UI_LABEL_EXISTING_SELECT);
        this.newExpressionText = new Text(this.existingSelectWorkArea, 2816);
        this.newExpressionText.setLayoutData((Object)ViewUtility.createFill());
        this.newExpressionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (SubQueryPage.this.getExistingSelectButton().getSelection() && !SubQueryPage.this.getNewExpressionText().getText().equals("")) {
                    SubQueryPage.this.setPageComplete(true);
                    if (SubQueryPage.this.getWizard() instanceof ExpressionBuilderWizard) {
                        ExpressionBuilderWizard wiz = (ExpressionBuilderWizard)SubQueryPage.this.getWizard();
                        wiz.setAllPagesComplete(true);
                    }
                } else {
                    SubQueryPage.this.setPageComplete(false);
                }
            }
        });
        this.createNewSelectWorkArea = new Composite((Composite)this.pageBook, 0);
        this.createNewSelectWorkArea.setLayout((Layout)new GridLayout());
        this.createNewSelectWorkArea.setLayoutData((Object)ViewUtility.createFill());
        Label createNewSelectInfoLabel = new Label(this.createNewSelectWorkArea, 16640);
        createNewSelectInfoLabel.setText(Messages._UI_LABEL_NEW_SELECT_INFO);
        this.freeFormText = new Text(this.createNewSelectWorkArea, 2816);
        this.freeFormText.setLayoutData((Object)ViewUtility.createFill());
        this.freeFormText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (SubQueryPage.this.getCreateNewSelectButton().getSelection() && !SubQueryPage.this.getFreeFormText().getText().equals("")) {
                    SubQueryPage.this.setPageComplete(true);
                    if (SubQueryPage.this.getWizard() instanceof ExpressionBuilderWizard) {
                        ExpressionBuilderWizard wiz = (ExpressionBuilderWizard)SubQueryPage.this.getWizard();
                        wiz.setAllPagesComplete(true);
                    }
                } else {
                    SubQueryPage.this.setPageComplete(false);
                }
            }
        });
        GridData gd = new GridData();
        GC gc = new GC((Drawable)previewFunctionLabel);
        Point pointSize = gc.stringExtent(Messages._UI_LABEL_NEW_SELECT_INFO);
        gd.widthHint = pointSize.x + gc.getAdvanceWidth('M');
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        this.pageBook.setLayoutData((Object)gd);
        this.pageBook.showPage((Control)this.existingSelectWorkArea);
        this.setControl((Control)this.mainPanel);
    }

    public Button getCreateNewSelectButton() {
        return this.createNewSelectButton;
    }

    public Button getExistingSelectButton() {
        return this.existingSelectButton;
    }

    public Text getFreeFormText() {
        return this.freeFormText;
    }

    public Text getNewExpressionText() {
        return this.newExpressionText;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent se) {
        if (se.widget == this.queryStatementCombo) {
            int index = this.queryStatementCombo.getSelectionIndex();
            if (index >= 0) {
                String selection = this.queryStatementCombo.getItem(index);
                this.choiceQueryExpr = this.getQueryExprForName(selection);
            }
            this.updateFinishButton();
            this.updateNewExpressionText();
        } else if (se.widget == this.existingSelectButton) {
            this.pageBook.showPage((Control)this.existingSelectWorkArea);
            this.updateFinishButton();
        } else if (se.widget == this.createNewSelectButton) {
            this.pageBook.showPage((Control)this.createNewSelectWorkArea);
            this.updateFinishButton();
        }
    }

    QueryExpressionRoot getQueryExprForName(String name) {
        QueryStatement stmt = null;
        QueryExpressionRoot root = null;
        Iterator stmtsItr = this.stmtsList.iterator();
        if (stmtsItr != null) {
            IFile file = null;
            while (stmtsItr.hasNext()) {
                file = (IFile)stmtsItr.next();
                String fileName = file.getName();
                if (name.equals(fileName = fileName.substring(0, fileName.indexOf(".sql")))) break;
            }
            if (file != null) {
                String fileContent = WorkbenchUtility.readFileContentsToString(file, true).trim();
                try {
                    stmt = this.domainModel.parse(fileContent, true);
                }
                catch (SQLParserException sQLParserException) {
                }
                catch (SQLParserInternalException sQLParserInternalException) {}
                if (stmt instanceof QuerySelectStatement) {
                    root = ((QuerySelectStatement)stmt).getQueryExpr();
                }
            }
        }
        return root;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.initializeFields();
            if (this.inputSQLExpression instanceof ValueExpressionScalarSelect) {
                QueryExpressionRoot inputExpr = ((ValueExpressionScalarSelect)this.inputSQLExpression).getQueryExpr();
                if (inputExpr != null) {
                    this.existingSelectButton.setSelection(true);
                    this.createNewSelectButton.setSelection(false);
                    this.existingSelectButton.notifyListeners(13, new Event());
                    this.choiceQueryExpr = inputExpr;
                    this.queryStatementCombo.clearSelection();
                    this.updateNewExpressionText();
                } else {
                    this.existingSelectButton.setSelection(false);
                    this.createNewSelectButton.setSelection(true);
                    this.createNewSelectButton.notifyListeners(13, new Event());
                    this.choiceQueryExpr = null;
                    this.freeFormText.setText(this.inputSQLExpression.getSQL());
                    this.freeFormText.notifyListeners(24, new Event());
                }
            }
            this.updateFinishButton();
        }
    }

    private void initializeFields() {
        this.queryStatementCombo.removeAll();
        IProject project = this.domainModel.getProject();
        this.stmtsList = WorkbenchUtility.getSelectStatementsFromProject(project, this.domainModel);
        for (IFile file : this.stmtsList) {
            String name = file.getName();
            name = name.substring(0, name.indexOf(".sql"));
            this.queryStatementCombo.add(name);
        }
    }

    private void updateFinishButton() {
        boolean isComplete = false;
        if (this.existingSelectButton.getSelection() && !this.newExpressionText.getText().equals("")) {
            isComplete = true;
        } else if (this.createNewSelectButton.getSelection() && !this.freeFormText.getText().equals("")) {
            isComplete = true;
        }
        this.setPageComplete(isComplete);
        if (this.getWizard() instanceof ExpressionBuilderWizard) {
            ExpressionBuilderWizard wiz = (ExpressionBuilderWizard)this.getWizard();
            wiz.setAllPagesComplete(isComplete);
        }
    }

    public boolean performOk() {
        ValueExpressionScalarSelect newExpr = null;
        if (this.existingSelectButton.getSelection()) {
            newExpr = this.parseIt(this.newExpressionText.getText());
        } else if (this.createNewSelectButton.getSelection()) {
            newExpr = this.parseIt(this.freeFormText.getText());
        }
        if (newExpr != null) {
            if (this.getWizard() instanceof ExpressionBuilderWizard) {
                ExpressionBuilderWizard wiz = (ExpressionBuilderWizard)this.getWizard();
                wiz.setSQLExpression((QueryValueExpression)newExpr);
            } else if (this.getWizard() instanceof SubQueryWizard) {
                SubQueryWizard wiz = (SubQueryWizard)this.getWizard();
                wiz.setSQLExpression((QueryValueExpression)newExpr);
            }
            return true;
        }
        return false;
    }

    private ValueExpressionScalarSelect parseIt(String selectText) {
        ValueExpressionScalarSelect expr = null;
        QueryStatement query = null;
        try {
            query = this.domainModel.parse(selectText);
        }
        catch (SQLParserException sQLParserException) {
        }
        catch (SQLParserInternalException sQLParserInternalException) {}
        ExpressionHelper eh = new ExpressionHelper();
        expr = eh.createScalarSelect(query);
        return expr;
    }

    private void updateNewExpressionText() {
        if (this.choiceQueryExpr != null) {
            this.newExpressionText.setText(this.choiceQueryExpr.getSQL());
        } else {
            this.newExpressionText.setText("");
        }
    }

    public boolean currentPage() {
        return this.isCurrentPage();
    }
}

