/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.github.core.service;

import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.egit.github.core.Blob;
import org.eclipse.egit.github.core.Commit;
import org.eclipse.egit.github.core.IRepositoryIdProvider;
import org.eclipse.egit.github.core.Reference;
import org.eclipse.egit.github.core.ShaResource;
import org.eclipse.egit.github.core.Tag;
import org.eclipse.egit.github.core.Tree;
import org.eclipse.egit.github.core.TreeEntry;
import org.eclipse.egit.github.core.TypedResource;
import org.eclipse.egit.github.core.client.GitHubClient;
import org.eclipse.egit.github.core.client.GitHubRequest;
import org.eclipse.egit.github.core.client.PagedRequest;
import org.eclipse.egit.github.core.service.GitHubService;

public class DataService
extends GitHubService {
    public DataService() {
    }

    public DataService(GitHubClient client) {
        super(client);
    }

    public Blob getBlob(IRepositoryIdProvider repository, String sha) throws IOException {
        String id = this.getId(repository);
        if (sha == null) {
            throw new IllegalArgumentException("SHA-1 cannot be null");
        }
        if (sha.length() == 0) {
            throw new IllegalArgumentException("SHA-1 cannot be empty");
        }
        StringBuilder uri = new StringBuilder();
        uri.append("/repos");
        uri.append('/').append(id);
        uri.append("/git");
        uri.append("/blobs");
        uri.append('/').append(sha);
        GitHubRequest request = this.createRequest();
        request.setType((Type)((Object)Blob.class));
        request.setUri(uri);
        return (Blob)this.client.get(request).getBody();
    }

    public String createBlob(IRepositoryIdProvider repository, Blob blob) throws IOException {
        String id = this.getId(repository);
        if (blob == null) {
            throw new IllegalArgumentException("Blob cannot be null");
        }
        StringBuilder uri = new StringBuilder();
        uri.append("/repos");
        uri.append('/').append(id);
        uri.append("/git");
        uri.append("/blobs");
        ShaResource created = (ShaResource)this.client.post(uri.toString(), blob, (Type)((Object)ShaResource.class));
        return created != null ? created.getSha() : null;
    }

    public Tree getTree(IRepositoryIdProvider repository, String sha) throws IOException {
        return this.getTree(repository, sha, false);
    }

    public Tree getTree(IRepositoryIdProvider repository, String sha, boolean recursive) throws IOException {
        String id = this.getId(repository);
        if (sha == null) {
            throw new IllegalArgumentException("SHA-1 cannot be null");
        }
        if (sha.length() == 0) {
            throw new IllegalArgumentException("SHA-1 cannot be empty");
        }
        StringBuilder uri = new StringBuilder();
        uri.append("/repos");
        uri.append('/').append(id);
        uri.append("/git");
        uri.append("/trees");
        uri.append('/').append(sha);
        GitHubRequest request = this.createRequest();
        request.setType((Type)((Object)Tree.class));
        request.setUri(uri);
        if (recursive) {
            request.setParams(Collections.singletonMap("recursive", "1"));
        }
        return (Tree)this.client.get(request).getBody();
    }

    public Tree createTree(IRepositoryIdProvider repository, Collection<TreeEntry> entries) throws IOException {
        return this.createTree(repository, entries, null);
    }

    public Tree createTree(IRepositoryIdProvider repository, Collection<TreeEntry> entries, String baseTree) throws IOException {
        String id = this.getId(repository);
        StringBuilder uri = new StringBuilder();
        uri.append("/repos");
        uri.append('/').append(id);
        uri.append("/git");
        uri.append("/trees");
        GitHubRequest request = this.createRequest();
        request.setType((Type)((Object)Tree.class));
        request.setUri(uri);
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (entries != null) {
            params.put("tree", entries.toArray());
        }
        if (baseTree != null) {
            params.put("base_tree", baseTree);
        }
        return (Tree)this.client.post(uri.toString(), params, (Type)((Object)Tree.class));
    }

    public Reference getReference(IRepositoryIdProvider repository, String name) throws IOException {
        String id = this.getId(repository);
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        if (name.length() == 0) {
            throw new IllegalArgumentException("Name cannot be empty");
        }
        StringBuilder uri = new StringBuilder();
        uri.append("/repos");
        uri.append('/').append(id);
        uri.append("/git");
        if (!name.startsWith("refs/")) {
            uri.append("/refs");
        }
        uri.append('/').append(name);
        GitHubRequest request = this.createRequest();
        request.setType((Type)((Object)Reference.class));
        request.setUri(uri);
        return (Reference)this.client.get(request).getBody();
    }

    public List<Reference> getReferences(IRepositoryIdProvider repository) throws IOException {
        String id = this.getId(repository);
        StringBuilder uri = new StringBuilder();
        uri.append("/repos");
        uri.append('/').append(id);
        uri.append("/git");
        uri.append("/refs");
        PagedRequest request = this.createPagedRequest();
        request.setType(new TypeToken<List<Reference>>(){}.getType());
        request.setUri(uri);
        return this.getAll(request);
    }

    public Reference createReference(IRepositoryIdProvider repository, Reference reference) throws IOException {
        String id = this.getId(repository);
        if (reference == null) {
            throw new IllegalArgumentException("Reference cannot be null");
        }
        TypedResource object = reference.getObject();
        if (object == null) {
            throw new IllegalArgumentException("Reference object cannot be null");
        }
        StringBuilder uri = new StringBuilder();
        uri.append("/repos");
        uri.append('/').append(id);
        uri.append("/git");
        uri.append("/refs");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("sha", object.getSha());
        params.put("ref", reference.getRef());
        return (Reference)this.client.post(uri.toString(), params, (Type)((Object)Reference.class));
    }

    public Reference editReference(IRepositoryIdProvider repository, Reference reference) throws IOException {
        return this.editReference(repository, reference, false);
    }

    public Reference editReference(IRepositoryIdProvider repository, Reference reference, boolean force) throws IOException {
        String id = this.getId(repository);
        if (reference == null) {
            throw new IllegalArgumentException("Reference cannot be null");
        }
        TypedResource object = reference.getObject();
        if (object == null) {
            throw new IllegalArgumentException("Object cannot be null");
        }
        String ref = reference.getRef();
        if (ref == null) {
            throw new IllegalArgumentException("Ref cannot be null");
        }
        if (ref.length() == 0) {
            throw new IllegalArgumentException("Ref cannot be empty");
        }
        StringBuilder uri = new StringBuilder();
        uri.append("/repos");
        uri.append('/').append(id);
        uri.append("/git");
        if (!ref.startsWith("refs/")) {
            uri.append("/refs");
        }
        uri.append('/').append(ref);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("sha", object.getSha());
        if (force) {
            params.put("force", true);
        }
        return (Reference)this.client.post(uri.toString(), params, (Type)((Object)Reference.class));
    }

    public Commit getCommit(IRepositoryIdProvider repository, String sha) throws IOException {
        String id = this.getId(repository);
        if (sha == null) {
            throw new IllegalArgumentException("SHA-1 cannot be null");
        }
        if (sha.length() == 0) {
            throw new IllegalArgumentException("SHA-1 cannot be empty");
        }
        StringBuilder uri = new StringBuilder();
        uri.append("/repos");
        uri.append('/').append(id);
        uri.append("/git");
        uri.append("/commits");
        uri.append('/').append(sha);
        GitHubRequest request = this.createRequest();
        request.setType((Type)((Object)Commit.class));
        request.setUri(uri);
        return (Commit)this.client.get(request).getBody();
    }

    public Commit createCommit(IRepositoryIdProvider repository, Commit commit) throws IOException {
        Tree tree;
        String id = this.getId(repository);
        if (commit == null) {
            throw new IllegalArgumentException("Commit cannot be null");
        }
        StringBuilder uri = new StringBuilder();
        uri.append("/repos");
        uri.append('/').append(id);
        uri.append("/git");
        uri.append("/commits");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("author", commit.getAuthor());
        params.put("committer", commit.getCommitter());
        params.put("message", commit.getMessage());
        List<Commit> parents = commit.getParents();
        if (parents != null && parents.size() > 0) {
            ArrayList<String> parentIds = new ArrayList<String>();
            for (Commit parent : parents) {
                parentIds.add(parent.getSha());
            }
            params.put("parents", parentIds);
        }
        if ((tree = commit.getTree()) != null) {
            params.put("tree", tree.getSha());
        }
        return (Commit)this.client.post(uri.toString(), params, (Type)((Object)Commit.class));
    }

    public Tag getTag(IRepositoryIdProvider repository, String sha) throws IOException {
        String id = this.getId(repository);
        if (sha == null) {
            throw new IllegalArgumentException("SHA-1 cannot be null");
        }
        if (sha.length() == 0) {
            throw new IllegalArgumentException("SHA-1 cannot be empty");
        }
        StringBuilder uri = new StringBuilder();
        uri.append("/repos");
        uri.append('/').append(id);
        uri.append("/git");
        uri.append("/tags");
        uri.append('/').append(sha);
        GitHubRequest request = this.createRequest();
        request.setType((Type)((Object)Tag.class));
        request.setUri(uri);
        return (Tag)this.client.get(request).getBody();
    }

    public Tag createTag(IRepositoryIdProvider repository, Tag tag) throws IOException {
        String id = this.getId(repository);
        if (tag == null) {
            throw new IllegalArgumentException("Tag cannot be null");
        }
        StringBuilder uri = new StringBuilder();
        uri.append("/repos");
        uri.append('/').append(id);
        uri.append("/git");
        uri.append("/tags");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("tag", tag.getTag());
        params.put("message", tag.getMessage());
        TypedResource object = tag.getObject();
        if (object != null) {
            params.put("object", object.getSha());
            params.put("type", object.getType());
        }
        params.put("tagger", tag.getTagger());
        return (Tag)this.client.post(uri.toString(), params, (Type)((Object)Tag.class));
    }
}

