/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.ui.sirius;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.diffmerge.api.IDiffPolicy;
import org.eclipse.emf.diffmerge.api.IMatchPolicy;
import org.eclipse.emf.diffmerge.api.IMergePolicy;
import org.eclipse.emf.diffmerge.api.Role;
import org.eclipse.emf.diffmerge.sirius.SiriusDiffPolicy;
import org.eclipse.emf.diffmerge.sirius.SiriusMatchPolicy;
import org.eclipse.emf.diffmerge.sirius.SiriusMergePolicy;
import org.eclipse.emf.diffmerge.ui.EMFDiffMergeUIPlugin;
import org.eclipse.emf.diffmerge.ui.gmf.GMFComparisonMethod;
import org.eclipse.emf.diffmerge.ui.sirius.Messages;
import org.eclipse.emf.diffmerge.ui.sirius.SiriusDiffMergeLabelProvider;
import org.eclipse.emf.diffmerge.ui.sirius.SiriusDifferenceCategoryProvider;
import org.eclipse.emf.diffmerge.ui.specification.IComparisonMethodFactory;
import org.eclipse.emf.diffmerge.ui.specification.IModelScopeDefinition;
import org.eclipse.emf.diffmerge.ui.specification.ext.URIScopeDefinition;
import org.eclipse.emf.diffmerge.ui.viewers.IDifferenceCategoryProvider;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class SiriusComparisonMethod
extends GMFComparisonMethod {
    protected final Map<Role, Session> _roleToSession = new HashMap<Role, Session>(3);

    public SiriusComparisonMethod(IModelScopeDefinition leftScopeDef_p, IModelScopeDefinition rightScopeDef_p, IModelScopeDefinition ancestorScopeDef_p, IComparisonMethodFactory factory_p) {
        super(leftScopeDef_p, rightScopeDef_p, ancestorScopeDef_p, factory_p);
    }

    protected Session checkSession(Role role_p) {
        IModelScopeDefinition scopeDefinition;
        Session result = null;
        if ((role_p != Role.ANCESTOR || this.isThreeWay()) && (scopeDefinition = this.getModelScopeDefinition(role_p)) instanceof URIScopeDefinition) {
            URIScopeDefinition uriScopeDefinition = (URIScopeDefinition)scopeDefinition;
            URI uri = uriScopeDefinition.getEntrypoint();
            result = SessionManager.INSTANCE.getExistingSession(uri);
        }
        return result;
    }

    protected EditingDomain checkSessions() {
        EditingDomain result;
        Role[] roleArray = Role.values();
        int n = roleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Role role = roleArray[n2];
            this._roleToSession.put(role, this.checkSession(role));
            ++n2;
        }
        HashSet<Session> sessions = new HashSet<Session>(this._roleToSession.values());
        sessions.remove(null);
        int nbResourceSets = sessions.size();
        switch (nbResourceSets) {
            case 0: {
                result = this.createEditingDomain();
                this._isDedicatedEditingDomain = true;
                break;
            }
            case 1: {
                result = ((Session)sessions.iterator().next()).getTransactionalEditingDomain();
                break;
            }
            case 2: {
                if (this.isThreeWay() && this._roleToSession.get(Role.ANCESTOR) != null) {
                    Session sideSession = this._roleToSession.get(Role.TARGET);
                    if (sideSession == null) {
                        sideSession = this._roleToSession.get(Role.REFERENCE);
                    }
                    result = sideSession.getTransactionalEditingDomain();
                    break;
                }
                result = null;
                break;
            }
            default: {
                result = null;
            }
        }
        return result;
    }

    protected IDiffPolicy createDiffPolicy() {
        return new SiriusDiffPolicy();
    }

    protected IMatchPolicy createMatchPolicy() {
        return new SiriusMatchPolicy();
    }

    protected IMergePolicy createMergePolicy() {
        return new SiriusMergePolicy();
    }

    protected EditingDomain doGetEditingDomain() {
        EditingDomain result = this.checkSessions();
        if (result == null && this.isVerbose()) {
            this.showNoEditingDomainWarning();
        }
        return result;
    }

    protected IDifferenceCategoryProvider getCustomCategoryProvider() {
        return new SiriusDifferenceCategoryProvider();
    }

    protected ILabelProvider getCustomLabelProvider() {
        return SiriusDiffMergeLabelProvider.getInstance();
    }

    public ResourceSet getResourceSet(Role role_p) {
        TransactionalEditingDomain sessionDomain;
        Session roleSession;
        ResourceSet result = null;
        EditingDomain centralDomain = this.getEditingDomain();
        if (centralDomain == null && (roleSession = this._roleToSession.get(role_p)) != null && (sessionDomain = roleSession.getTransactionalEditingDomain()) != null) {
            result = sessionDomain.getResourceSet();
        }
        return result;
    }

    protected void showNoEditingDomainWarning() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = SiriusComparisonMethod.this.getShell();
                if (shell != null) {
                    String message = Messages.SiriusComparisonMethod_UndoRedoWarning;
                    MessageDialog.openWarning((Shell)shell, (String)EMFDiffMergeUIPlugin.LABEL, (String)message);
                }
            }
        });
    }
}

