/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.editor.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.editor.EEditor;
import org.eclipse.emf.editor.ui.binding.EmfSwtBindingFactory;
import org.eclipse.emf.editor.ui.binding.MultipleFeatureControl;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.TextActionHandler;
import org.eclipse.ui.forms.AbstractFormPart;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.widgets.Section;

public class GenericDetailsPage
extends AbstractFormPart
implements ISelectionProvider,
IDetailsPage {
    private EEditor editor;
    private EmfSwtBindingFactory factory;
    private EObject input;
    private Composite main;
    private ISelection partSelection = null;
    private List<ISelectionChangedListener> selListeners = new ArrayList<ISelectionChangedListener>();

    public GenericDetailsPage(EObject object, EEditor editor) {
        this.input = object;
        this.editor = editor;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selListeners.add(listener);
    }

    private void cleanUpMainComposite() {
        Control[] controlArray = this.main.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.dispose();
            ++n2;
        }
    }

    public void createContents(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        Section sec = this.getManagedForm().getToolkit().createSection(parent, 256);
        sec.marginWidth = 10;
        sec.marginHeight = 5;
        sec.setText("Properties");
        this.main = this.getManagedForm().getToolkit().createComposite((Composite)sec);
        this.main.setLayout((Layout)new GridLayout(2, false));
        MenuManager mm = new MenuManager("#DetailsPartMenu");
        mm.setRemoveAllWhenShown(false);
        mm.add((IAction)new Action("Reset to default"){

            public void run() {
                GenericDetailsPage.this.main.getDisplay().syncExec((Runnable)new ResetToDefaultRunnable());
            }
        });
        IWorkbenchWindow window = this.editor.getSite().getWorkbenchWindow();
        mm.add((IAction)ActionFactory.COPY.create(window));
        mm.add((IContributionItem)new Separator("additions"));
        Menu menu = mm.createContextMenu((Control)this.main);
        this.editor.getSite().registerContextMenu(mm.getId(), mm, (ISelectionProvider)this);
        this.createGenericPart(menu);
        sec.setClient((Control)this.main);
    }

    private void createGenericPart(Menu menu) {
        if (this.input != null) {
            this.cleanUpMainComposite();
            BasicEList allStructuralFeatures = new BasicEList((Collection)this.input.eClass().getEAllStructuralFeatures());
            Collections.sort(allStructuralFeatures, new EStructuralfeatureComparator());
            this.factory = new EmfSwtBindingFactory(this.editor.getAdapterFactory(), this.editor.getEditingDomain(), this.input, this.main, this.getManagedForm().getToolkit(), this.editor.getExtXptFacade());
            final IActionBars actionBars = this.editor.getActionBars();
            final IAction ecoreCopy = actionBars.getGlobalActionHandler(ActionFactory.COPY.getId());
            final IAction ecoreCut = actionBars.getGlobalActionHandler(ActionFactory.CUT.getId());
            final IAction ecorePaste = actionBars.getGlobalActionHandler(ActionFactory.PASTE.getId());
            final IAction ecoreDelete = actionBars.getGlobalActionHandler(ActionFactory.DELETE.getId());
            for (final EStructuralFeature feature : allStructuralFeatures) {
                if (!feature.isChangeable() || feature.isDerived() || feature instanceof EReference && (((EReference)feature).isContainment() || ((EReference)feature).isContainer())) continue;
                this.createLabel(this.editor.getExtendedReflectiveItemProvider().getTextForFeature(feature));
                final Control contr = this.factory.create(feature);
                contr.setMenu(menu);
                contr.addFocusListener((FocusListener)new FocusAdapter(){

                    public void focusGained(FocusEvent e) {
                        if (contr instanceof Text) {
                            TextActionHandler textHandlerh = new TextActionHandler(actionBars);
                            Text t = (Text)contr;
                            textHandlerh.addText(t);
                            textHandlerh.setCopyAction(ecoreCopy);
                            textHandlerh.setCutAction(ecoreCut);
                            textHandlerh.setPasteAction(ecorePaste);
                            textHandlerh.setDeleteAction(ecoreDelete);
                            actionBars.updateActionBars();
                        }
                        GenericDetailsPage.this.setSelection((ISelection)new StructuredSelection((Object)feature));
                    }

                    public void focusLost(FocusEvent e) {
                        actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), ecoreCopy);
                        actionBars.setGlobalActionHandler(ActionFactory.CUT.getId(), ecoreCut);
                        actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), ecoreDelete);
                        actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), ecorePaste);
                    }
                });
            }
            this.getManagedForm().getToolkit().paintBordersFor(this.main);
        }
    }

    private Label createLabel(String string) {
        Label lab = this.getManagedForm().getToolkit().createLabel(this.main, string);
        lab.setLayoutData((Object)new GridData());
        return lab;
    }

    public void dispose() {
        if (this.factory != null) {
            this.factory.dispose();
        }
        if (!this.main.isDisposed() && !this.main.getParent().isDisposed()) {
            this.main.getParent().dispose();
        }
    }

    public ISelection getSelection() {
        return this.partSelection;
    }

    public Control locateControl(String key, Object data) {
        Control[] controlArray = this.main.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            Object controlsData = c.getData(key);
            if (controlsData != null && controlsData.equals(data)) {
                return c;
            }
            ++n2;
        }
        return null;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selListeners.remove(listener);
    }

    public void selectionChanged(IFormPart part, ISelection selection) {
    }

    public void setFocus() {
        this.main.setFocus();
    }

    public void setSelection(ISelection selection) {
        this.partSelection = selection;
        for (ISelectionChangedListener listener : this.selListeners) {
            listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, selection));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class EStructuralfeatureComparator
    implements Comparator<EStructuralFeature> {
        private EStructuralfeatureComparator() {
        }

        @Override
        public int compare(EStructuralFeature o1, EStructuralFeature o2) {
            return this.nullSafe(o1).compareTo(this.nullSafe(o2));
        }

        private String nullSafe(EStructuralFeature o) {
            String name = o.getName();
            return name != null ? name : "";
        }
    }

    private final class ResetToDefaultRunnable
    implements Runnable {
        private ResetToDefaultRunnable() {
        }

        public void run() {
            Object o;
            if (GenericDetailsPage.this.getSelection() instanceof StructuredSelection && (o = ((StructuredSelection)GenericDetailsPage.this.getSelection()).getFirstElement()) instanceof EStructuralFeature) {
                EStructuralFeature feature = (EStructuralFeature)o;
                ItemPropertyDescriptor desc = new ItemPropertyDescriptor(GenericDetailsPage.this.editor.getAdapterFactory(), null, feature.getName(), "", feature, true);
                if (desc.isPropertySet((Object)GenericDetailsPage.this.input)) {
                    Control locatedControl;
                    desc.resetPropertyValue((Object)GenericDetailsPage.this.input);
                    if (feature.isMany() && (locatedControl = GenericDetailsPage.this.locateControl(EcorePackage.Literals.ESTRUCTURAL_FEATURE.getName(), feature)) instanceof MultipleFeatureControl) {
                        MultipleFeatureControl mfc = (MultipleFeatureControl)locatedControl;
                        mfc.quietClearSelection();
                    }
                }
            }
        }
    }
}

