/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.servletbridge;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.equinox.servletbridge.FrameworkLauncher;

public class BridgeServlet
extends HttpServlet {
    static final String INCLUDE_REQUEST_URI_ATTRIBUTE = "javax.servlet.include.request_uri";
    static final String INCLUDE_SERVLET_PATH_ATTRIBUTE = "javax.servlet.include.servlet_path";
    static final String INCLUDE_PATH_INFO_ATTRIBUTE = "javax.servlet.include.path_info";
    private static final long serialVersionUID = 2825667412474494674L;
    private static BridgeServlet instance;
    private HttpServlet delegate;
    private FrameworkLauncher framework;
    private int delegateReferenceCount;
    private boolean enableFrameworkControls;

    public void init() throws ServletException {
        String frameworkLauncherClassParameter;
        String initSSLSocketFactory;
        Object clazz;
        super.init();
        String enableFrameworkControlsParameter = this.getServletConfig().getInitParameter("enableFrameworkControls");
        this.enableFrameworkControls = enableFrameworkControlsParameter != null && enableFrameworkControlsParameter.equals("true");
        String frameworkPreloads = this.getServletConfig().getInitParameter("_contextPreloads");
        if (frameworkPreloads != null) {
            StringTokenizer st = new StringTokenizer(frameworkPreloads, ",");
            while (st.hasMoreElements()) {
                clazz = st.nextToken().trim();
                if (((String)clazz).length() == 0) continue;
                try {
                    ((Object)((Object)this)).getClass().getClassLoader().loadClass((String)clazz);
                }
                catch (Exception e) {
                    this.getServletContext().log("Bridge Servlet _contextPreloads (" + (String)clazz + ") " + e.getMessage());
                }
            }
        }
        if (!"false".equals(initSSLSocketFactory = this.getServletConfig().getInitParameter("_initSSLSocketFactory"))) {
            try {
                clazz = ((Object)((Object)this)).getClass().getClassLoader().loadClass("javax.net.ssl.SSLSocketFactory");
                Method getDefaultMethod = ((Class)clazz).getMethod("getDefault", new Class[0]);
                getDefaultMethod.invoke(null, new Object[0]);
            }
            catch (Exception e) {
                this.getServletContext().log("Bridge Servlet _initSSLSocketFactory - failed - " + e.getMessage());
            }
        }
        if ((frameworkLauncherClassParameter = this.getServletConfig().getInitParameter("frameworkLauncherClass")) != null) {
            try {
                Class<?> frameworkLauncherClass = ((Object)((Object)this)).getClass().getClassLoader().loadClass(frameworkLauncherClassParameter);
                this.framework = (FrameworkLauncher)frameworkLauncherClass.newInstance();
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
        } else {
            this.framework = new FrameworkLauncher();
        }
        boolean frameworkStarted = false;
        BridgeServlet.setInstance(this);
        try {
            this.framework.init(this.getServletConfig());
            this.framework.deploy();
            this.framework.start();
            frameworkStarted = true;
        }
        finally {
            if (!frameworkStarted) {
                BridgeServlet.setInstance(null);
            }
        }
    }

    public void destroy() {
        this.framework.stop();
        this.framework.destroy();
        BridgeServlet.setInstance(null);
        super.destroy();
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String pathInfo = req.getPathInfo();
        if (pathInfo == null && this.isExtensionMapping(req.getServletPath())) {
            req = new ExtensionMappingRequest((HttpServletRequest)req);
        }
        if (req.getAttribute(INCLUDE_REQUEST_URI_ATTRIBUTE) == null) {
            if (this.enableFrameworkControls && pathInfo != null && pathInfo.startsWith("/sp_") && this.serviceFrameworkControls((HttpServletRequest)req, resp)) {
                return;
            }
        } else {
            String servletPath;
            String includePathInfo = (String)req.getAttribute(INCLUDE_PATH_INFO_ATTRIBUTE);
            if ((includePathInfo == null || includePathInfo.length() == 0) && this.isExtensionMapping(servletPath = (String)req.getAttribute(INCLUDE_SERVLET_PATH_ATTRIBUTE))) {
                req = new IncludedExtensionMappingRequest((HttpServletRequest)req);
            }
        }
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        HttpServlet servletReference = this.acquireDelegateReference();
        if (servletReference == null) {
            resp.sendError(404, "BridgeServlet: " + req.getRequestURI());
            return;
        }
        try {
            Thread.currentThread().setContextClassLoader(this.framework.getFrameworkContextClassLoader());
            servletReference.service((ServletRequest)req, (ServletResponse)resp);
        }
        finally {
            this.releaseDelegateReference();
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    private boolean isExtensionMapping(String servletPath) {
        if (servletPath == null) {
            return false;
        }
        String lastSegment = servletPath;
        int lastSlash = servletPath.lastIndexOf(47);
        if (lastSlash != -1) {
            lastSegment = servletPath.substring(lastSlash + 1);
        }
        return lastSegment.indexOf(46) != -1;
    }

    private boolean serviceFrameworkControls(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String pathInfo = req.getPathInfo();
        if (pathInfo.equals("/sp_start")) {
            this.framework.start();
            resp.getWriter().write("Platform Started");
            return true;
        }
        if (pathInfo.equals("/sp_stop")) {
            this.framework.stop();
            resp.getWriter().write("Platform Stopped");
            return true;
        }
        if (pathInfo.equals("/sp_deploy")) {
            this.framework.deploy();
            resp.getWriter().write("Platform Deployed");
            return true;
        }
        if (pathInfo.equals("/sp_undeploy")) {
            this.framework.undeploy();
            resp.getWriter().write("Platform Undeployed");
            return true;
        }
        if (pathInfo.equals("/sp_reset")) {
            this.framework.stop();
            this.framework.start();
            resp.getWriter().write("Platform Reset");
            return true;
        }
        if (pathInfo.equals("/sp_redeploy")) {
            this.framework.stop();
            this.framework.undeploy();
            this.framework.deploy();
            this.framework.start();
            resp.getWriter().write("Platform Redeployed");
            return true;
        }
        if (pathInfo.equals("/sp_test")) {
            if (this.delegate == null) {
                resp.getWriter().write("Servlet delegate not registered.");
            } else {
                resp.getWriter().write("Servlet delegate registered - " + this.delegate.getClass().getName());
            }
            return true;
        }
        return false;
    }

    private static synchronized void setInstance(BridgeServlet servlet) {
        if (instance != null && servlet != null) {
            throw new IllegalStateException("instance already set");
        }
        instance = servlet;
    }

    private synchronized void releaseDelegateReference() {
        --this.delegateReferenceCount;
        ((Object)((Object)this)).notifyAll();
    }

    private synchronized HttpServlet acquireDelegateReference() {
        if (this.delegate != null) {
            ++this.delegateReferenceCount;
        }
        return this.delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void registerServletDelegate(HttpServlet servletDelegate) {
        if (instance == null) {
            return;
        }
        if (servletDelegate == null) {
            throw new NullPointerException("cannot register a null servlet delegate");
        }
        BridgeServlet bridgeServlet = instance;
        synchronized (bridgeServlet) {
            if (BridgeServlet.instance.delegate != null) {
                throw new IllegalStateException("A Servlet Proxy is already registered");
            }
            try {
                servletDelegate.init(instance.getServletConfig());
            }
            catch (ServletException e) {
                instance.getServletContext().log("Error initializing servlet delegate", (Throwable)e);
                return;
            }
            BridgeServlet.instance.delegate = servletDelegate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void unregisterServletDelegate(HttpServlet servletDelegate) {
        if (instance == null) {
            return;
        }
        BridgeServlet bridgeServlet = instance;
        synchronized (bridgeServlet) {
            if (BridgeServlet.instance.delegate == null) {
                throw new IllegalStateException("No servlet delegate is registered");
            }
            if (BridgeServlet.instance.delegate != servletDelegate) {
                throw new IllegalStateException("Servlet delegate does not match registered servlet delegate");
            }
            HttpServlet oldProxy = BridgeServlet.instance.delegate;
            BridgeServlet.instance.delegate = null;
            while (BridgeServlet.instance.delegateReferenceCount != 0) {
                try {
                    ((Object)((Object)instance)).wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            oldProxy.destroy();
        }
    }

    static class ExtensionMappingRequest
    extends HttpServletRequestWrapper {
        public ExtensionMappingRequest(HttpServletRequest req) {
            super(req);
        }

        public String getPathInfo() {
            return super.getServletPath();
        }

        public String getServletPath() {
            return "";
        }
    }

    static class IncludedExtensionMappingRequest
    extends HttpServletRequestWrapper {
        public IncludedExtensionMappingRequest(HttpServletRequest req) {
            super(req);
        }

        public Object getAttribute(String attributeName) {
            if (attributeName.equals(BridgeServlet.INCLUDE_SERVLET_PATH_ATTRIBUTE)) {
                return "";
            }
            if (attributeName.equals(BridgeServlet.INCLUDE_PATH_INFO_ATTRIBUTE)) {
                String servletPath = (String)super.getAttribute(BridgeServlet.INCLUDE_SERVLET_PATH_ATTRIBUTE);
                return servletPath;
            }
            return super.getAttribute(attributeName);
        }
    }
}

