/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facelet.core.internal.util;

import org.eclipse.core.resources.IProject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jst.jsf.common.metadata.Entity;
import org.eclipse.jst.jsf.common.metadata.Model;
import org.eclipse.jst.jsf.common.metadata.Trait;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataDomainContext;
import org.eclipse.jst.jsf.common.metadata.query.internal.MetaDataQueryContextFactory;
import org.eclipse.jst.jsf.common.metadata.query.internal.MetaDataQueryFactory;
import org.eclipse.jst.jsf.common.metadata.query.internal.taglib.ITaglibDomainMetaDataQuery;
import org.eclipse.jst.jsf.facelet.core.internal.cm.addtagmd.ElementData;
import org.eclipse.jst.jsf.tagdisplay.internal.paletteinfos.PaletteInfo;
import org.eclipse.jst.jsf.tagdisplay.internal.paletteinfos.PaletteInfos;

public class TagMetadataLoader {
    private static final String PALETTE_INFOS = "paletteInfos";
    private static final String TRAIT_DISPLAY_NAME = "displayName";
    private static final String TRAIT_DESCRIPTION = "description";
    private static final String TRAIT_ADDITIONALELEMENTDATA = "additionalElementData";
    private final IProject _project;

    public TagMetadataLoader(IProject project) {
        this._project = project;
    }

    public String getDisplayName(String nsUri, String tagName) {
        return this.getString(nsUri, tagName, TRAIT_DISPLAY_NAME);
    }

    public String getDescription(String nsUri, String tagName) {
        return this.getString(nsUri, tagName, TRAIT_DESCRIPTION);
    }

    public ElementData getElementData(String nsUri, String tagName) {
        EObject value;
        Trait trait;
        IMetaDataDomainContext context = MetaDataQueryContextFactory.getInstance().createTaglibDomainModelContext(this._project);
        ITaglibDomainMetaDataQuery query = (ITaglibDomainMetaDataQuery)MetaDataQueryFactory.getInstance().createQuery(context);
        Entity entity = query.getQueryHelper().getEntity(nsUri, tagName);
        if (entity != null && (trait = query.findTrait(entity, TRAIT_ADDITIONALELEMENTDATA)) != null && (value = trait.getValue()) instanceof ElementData) {
            return (ElementData)value;
        }
        return null;
    }

    private String getString(String nsUri, String tagName, String key) {
        String value = null;
        IMetaDataDomainContext context = MetaDataQueryContextFactory.getInstance().createTaglibDomainModelContext(this._project);
        ITaglibDomainMetaDataQuery query = (ITaglibDomainMetaDataQuery)MetaDataQueryFactory.getInstance().createQuery(context);
        Model model = this.getModel(query, nsUri);
        if (model != null) {
            value = this.getString(query, key, model, tagName);
        }
        return value;
    }

    private String getString(ITaglibDomainMetaDataQuery query, String key, Model model, String tagName) {
        String value = null;
        Trait trait = query.findTrait((Entity)model, PALETTE_INFOS);
        if (trait != null) {
            PaletteInfos tags = (PaletteInfos)trait.getValue();
            for (PaletteInfo tag : tags.getInfos()) {
                Object strValue;
                EStructuralFeature feature;
                if (!tag.getId().equalsIgnoreCase(tagName) || (feature = tag.eClass().getEStructuralFeature(key)) == null || !tag.eIsSet(feature) || !((strValue = tag.eGet(feature)) instanceof String)) continue;
                value = (String)strValue;
            }
        }
        return value;
    }

    private Model getModel(ITaglibDomainMetaDataQuery query, String nsUri) {
        Model model = query.findTagLibraryModel(nsUri);
        return model;
    }
}

