/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.businessprocess.treeoperations;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.utils.AbstractNonPostOperatingTreeNodeOperation;
import org.eclipse.jubula.client.core.utils.ITreeTraverserContext;

public class CheckIfCAPisDeprecated
extends AbstractNonPostOperatingTreeNodeOperation<INodePO> {
    private Set<INodePO> m_nodes = new HashSet<INodePO>();

    @Override
    public boolean operate(ITreeTraverserContext<INodePO> ctx, INodePO parent, INodePO node, boolean alreadyVisited) {
        if (node instanceof IExecTestCasePO) {
            String name;
            IExecTestCasePO exec = (IExecTestCasePO)node;
            IProjectPO project = GeneralStorage.getInstance().getProject();
            ISpecTestCasePO specTestCase = exec.getSpecTestCase();
            if (project == null) {
                return false;
            }
            if (specTestCase == null) {
                return true;
            }
            Long projectId = project.getId();
            if (specTestCase.getParentProjectId() != projectId && (projectId.equals(exec.getParentProjectId()) || projectId.equals(exec.getParentNode().getParentProjectId())) && StringUtils.containsIgnoreCase((String)(name = specTestCase.getName()), (String)"deprecated")) {
                this.m_nodes.add(exec);
            }
        }
        return true;
    }

    public Set<INodePO> getDeprecatedNodes() {
        return this.m_nodes;
    }
}

