/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swt.tester.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class RowManager {
    private static final int EXTRA_ROWS = 20;
    private Tree m_tree;
    private List<TreeItem> m_cachedRows = new ArrayList<TreeItem>();
    private boolean m_fullScanned;
    private int m_rowIndex;
    private Stack<Object> m_stackToSet;
    private TreeItem m_searchRow = null;

    public RowManager(Tree tree) {
        this.m_tree = tree;
    }

    public TreeItem getRow(int ind) {
        if (ind < 0) {
            return null;
        }
        this.m_stackToSet = new Stack();
        if (ind >= this.m_cachedRows.size() && !this.m_fullScanned) {
            if (!this.m_cachedRows.isEmpty()) {
                TreeItem curr = this.m_cachedRows.get(this.m_cachedRows.size() - 1);
                while (curr != null) {
                    this.m_stackToSet.add(curr);
                    curr = curr.getParentItem();
                }
            }
            this.m_stackToSet.add(this.m_tree);
            this.m_rowIndex = ind;
            this.traverse(this.m_tree);
        }
        if (ind < this.m_cachedRows.size()) {
            return this.m_cachedRows.get(ind);
        }
        return null;
    }

    private void traverse(Object current) {
        TreeItem[] children = current instanceof Tree ? ((Tree)current).getItems() : ((TreeItem)current).getItems();
        Object targChild = null;
        if (this.m_stackToSet.isEmpty()) {
            if (current instanceof TreeItem) {
                this.m_cachedRows.add((TreeItem)current);
                if (current == this.m_searchRow) {
                    this.m_rowIndex = -20;
                    return;
                }
            }
        } else {
            this.m_stackToSet.pop();
            if (!this.m_stackToSet.isEmpty()) {
                targChild = this.m_stackToSet.peek();
            }
        }
        if (this.m_stackToSet.isEmpty() && current instanceof TreeItem && !((TreeItem)current).getExpanded()) {
            return;
        }
        int currInd = 0;
        while (currInd < children.length) {
            if (children[currInd] == targChild) {
                targChild = null;
            }
            if (targChild == null) {
                this.traverse(children[currInd]);
            }
            if (this.m_cachedRows.size() > this.m_rowIndex + 20) {
                return;
            }
            ++currInd;
        }
        this.m_fullScanned = true;
    }

    public int getRowCount() {
        this.getRow(0x7FFFFFD7);
        return this.m_cachedRows.size();
    }

    public int getRowIndex(TreeItem row) {
        this.m_searchRow = row;
        this.m_stackToSet = new Stack();
        this.traverse(this.m_tree);
        int i = 0;
        while (i < this.m_cachedRows.size() && this.m_cachedRows.get(i) != row) {
            ++i;
        }
        return i;
    }
}

