/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.editor.scanner;

import java.io.IOException;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.linuxtools.internal.docker.editor.Activator;
import org.eclipse.linuxtools.internal.docker.editor.util.AssetLoader;

public class InstructionWordRule
extends WordRule {
    public static final String[] INSTRUCTIONS;
    private static final String INSTRUCTION_FILE_PATH = "assets/instructions.txt";

    static {
        String[] loadedInstructions = new String[]{};
        try {
            String contentsString = AssetLoader.loadAsset(INSTRUCTION_FILE_PATH);
            String lineSeparator = contentsString.contains("\r\n") ? "\r\n" : "\n";
            loadedInstructions = contentsString.split(lineSeparator);
        }
        catch (IOException e) {
            Activator.log(2, "No content assist available: error while reading instruction file: assets/instructions.txt", e);
        }
        INSTRUCTIONS = loadedInstructions;
    }

    public InstructionWordRule(IToken instructionToken) {
        super((IWordDetector)new InstructionWordDetector(), Token.UNDEFINED, true);
        this.setColumnConstraint(0);
        String[] stringArray = INSTRUCTIONS;
        int n = INSTRUCTIONS.length;
        int n2 = 0;
        while (n2 < n) {
            String instruction = stringArray[n2];
            this.addWord(instruction, instructionToken);
            ++n2;
        }
    }

    private static class InstructionWordDetector
    implements IWordDetector {
        private InstructionWordDetector() {
        }

        public boolean isWordStart(char c) {
            return Character.isJavaIdentifierStart(c);
        }

        public boolean isWordPart(char c) {
            return Character.isJavaIdentifierPart(c);
        }
    }
}

