/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.ide.editors.stp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ContextInformation;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.editors.stp.Messages;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.editors.stp.STPMetadataSingleton;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.editors.stp.proposals.STPFunctionCompletionProposal;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.editors.stp.proposals.STPProbeCompletionProposal;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.editors.stp.proposals.STPProbevarCompletionProposal;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.structures.ManpageCacher;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.structures.TapsetItemType;
import org.eclipse.linuxtools.systemtap.structures.TreeNode;

public class STPCompletionProcessor
implements IContentAssistProcessor,
ITextHover {
    private final IContextInformation[] NO_CONTEXTS = new IContextInformation[0];
    private final char[] PROPOSAL_ACTIVATION_CHARS = new char[]{'.'};
    private ICompletionProposal[] NO_COMPLETIONS = new ICompletionProposal[0];
    private static final String GLOBAL_KEYWORD = "global ";
    private static final String PROBE_KEYWORD = "probe ";
    private static final String FUNCTION_KEYWORD = "function ";
    private static final String[][] GLOBAL_KEYWORDS = new String[][]{{"global ", Messages.STPCompletionProcessor_global}, {"probe ", Messages.STPCompletionProcessor_probe}, {"function ", Messages.STPCompletionProcessor_function}};
    private STPMetadataSingleton stpMetadataSingleton = STPMetadataSingleton.getInstance();

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        return this.computeCompletionProposals(viewer.getDocument(), offset);
    }

    public ICompletionProposal[] computeCompletionProposals(IDocument document, int offset) {
        ITypedRegion partition = null;
        boolean useGlobal = false;
        try {
            partition = ((IDocumentExtension3)document).getPartition("__stp_probe_partitioning", offset, false);
            if (partition.getOffset() == offset && partition.getType() != "__dftl_partition_content_type" && partition.getType() != "__stp_probe") {
                ITypedRegion prevPartition;
                useGlobal = offset > 0 ? (prevPartition = ((IDocumentExtension3)document).getPartition("__stp_probe_partitioning", offset - 1, false)).getType() == "__dftl_partition_content_type" : true;
            }
        }
        catch (BadLocationException | BadPartitioningException e) {
            return this.NO_COMPLETIONS;
        }
        String prefix = "";
        String prePrefix = "";
        try {
            prefix = this.getPrefix(document, offset);
            Token previousToken = this.getPrecedingToken(document, offset - prefix.length() - 1);
            while (previousToken.tokenString.equals("=") || previousToken.tokenString.equals(",")) {
                previousToken = this.getPrecedingToken(document, previousToken.offset - 1);
                previousToken = this.getPrecedingToken(document, previousToken.offset - 1);
            }
            prePrefix = previousToken.tokenString;
        }
        catch (BadLocationException e) {
            return this.NO_COMPLETIONS;
        }
        if (prePrefix.startsWith("probe")) {
            return this.getProbeCompletionList(prefix, offset);
        }
        if (partition.getType() == "__stp_probe") {
            ICompletionProposal[] variableCompletions = this.getProbeVariableCompletions(document, offset, prefix);
            ICompletionProposal[] functionCompletions = this.getFunctionCompletions(offset, prefix);
            ArrayList<ICompletionProposal> completions = new ArrayList<ICompletionProposal>(variableCompletions.length + functionCompletions.length);
            completions.addAll(Arrays.asList(variableCompletions));
            completions.addAll(Arrays.asList(functionCompletions));
            return completions.toArray(new ICompletionProposal[0]);
        }
        if (partition.getType() == "__dftl_partition_content_type" || useGlobal) {
            return this.getGlobalKeywordCompletion(prefix, offset);
        }
        return this.NO_COMPLETIONS;
    }

    private ICompletionProposal[] getFunctionCompletions(int offset, String prefix) {
        TreeNode[] completionData = this.stpMetadataSingleton.getFunctionCompletions(prefix);
        ICompletionProposal[] result = new ICompletionProposal[completionData.length];
        int i = 0;
        while (i < completionData.length) {
            result[i] = new STPFunctionCompletionProposal(completionData[i], prefix.length(), offset);
            ++i;
        }
        return result;
    }

    private ICompletionProposal[] getProbeVariableCompletions(IDocument document, int offset, String prefix) {
        try {
            String probeName = this.getProbe(document, offset);
            TreeNode[] completionData = this.stpMetadataSingleton.getProbeVariableCompletions(probeName, prefix);
            ICompletionProposal[] result = new ICompletionProposal[completionData.length];
            int i = 0;
            while (i < completionData.length) {
                result[i] = new STPProbevarCompletionProposal(completionData[i], prefix.length(), offset, probeName);
                ++i;
            }
            return result;
        }
        catch (BadLocationException | BadPartitioningException e) {
            return this.NO_COMPLETIONS;
        }
    }

    private String getProbe(IDocument document, int offset) throws BadLocationException, BadPartitioningException {
        String probePoint = null;
        ITypedRegion partition = ((IDocumentExtension3)document).getPartition("__stp_probe_partitioning", offset, false);
        String probe = document.get(partition.getOffset(), partition.getLength());
        if (probe.startsWith(PROBE_KEYWORD)) {
            probePoint = probe.substring(PROBE_KEYWORD.length(), probe.indexOf(123));
            probePoint = probePoint.trim();
        }
        return probePoint;
    }

    private ICompletionProposal[] getProbeCompletionList(String prefix, int offset) {
        prefix = this.canonicalizePrefix(prefix);
        TreeNode[] completionData = this.stpMetadataSingleton.getProbeCompletions(prefix);
        ICompletionProposal[] result = new ICompletionProposal[completionData.length];
        int i = 0;
        while (i < completionData.length) {
            result[i] = new STPProbeCompletionProposal(completionData[i], prefix.length(), offset);
            ++i;
        }
        return result;
    }

    private String canonicalizePrefix(String prefix) {
        if (prefix.isEmpty()) {
            return "";
        }
        prefix = prefix.replaceAll("(?s)\\(\\s*\".*\"\\s*\\)", "(string)");
        prefix = prefix.replaceAll("(?s)\\(\\s*\\d*\\s*\\)", "(number)");
        return prefix;
    }

    private ICompletionProposal[] getGlobalKeywordCompletion(String prefix, int offset) {
        ArrayList<CompletionProposal> completions = new ArrayList<CompletionProposal>();
        int prefixLength = prefix.length();
        String[][] stringArray = GLOBAL_KEYWORDS;
        int n = GLOBAL_KEYWORDS.length;
        int n2 = 0;
        while (n2 < n) {
            String[] keyword = stringArray[n2];
            if (keyword[0].startsWith(prefix)) {
                CompletionProposal proposal = new CompletionProposal(keyword[0].substring(prefixLength), offset, 0, keyword[0].length() - prefixLength, null, keyword[0], (IContextInformation)new ContextInformation("contextDisplayString", "informationDisplayString"), keyword[1]);
                completions.add(proposal);
            }
            ++n2;
        }
        return completions.toArray(new ICompletionProposal[0]);
    }

    private Token getPrecedingToken(IDocument doc, int offset) throws BadLocationException {
        int n = offset;
        while (n >= 0 && Character.isSpaceChar(doc.getChar(n))) {
            --n;
        }
        char c = doc.getChar(n);
        if (this.isTokenDelimiter(c)) {
            return new Token(Character.toString(c), n);
        }
        int end = n;
        while (n >= 0 && !this.isTokenDelimiter(doc.getChar(n))) {
            --n;
        }
        return new Token(doc.get(n + 1, end - n), n + 1);
    }

    private Token getCurrentToken(IDocument doc, int offset) throws BadLocationException {
        char c = doc.getChar(offset);
        if (this.isDelimiter(c)) {
            return new Token(Character.toString(c), offset);
        }
        int start = offset;
        while (start >= 0 && !this.isDelimiter(doc.getChar(start))) {
            --start;
        }
        int end = offset;
        while (end < doc.getLength() && !this.isDelimiter(doc.getChar(end))) {
            ++end;
        }
        return new Token(doc.get(++start, end - start), start);
    }

    private boolean isFunctionRegion(IDocument doc, IRegion region) throws BadLocationException {
        int start = region.getLength() + region.getOffset();
        while (this.isTokenDelimiter(doc.getChar(start))) {
            ++start;
        }
        return doc.getChar(start) == '(';
    }

    private String getPrefix(IDocument doc, int offset) throws BadLocationException {
        int n = offset - 1;
        while (n >= 0) {
            char c = doc.getChar(n);
            if (this.isTokenDelimiter(c)) {
                return doc.get(n + 1, offset - n - 1);
            }
            --n;
        }
        return "";
    }

    private boolean isTokenDelimiter(char c) {
        if (Character.isWhitespace(c)) {
            return true;
        }
        switch (c) {
            case '\u0000': 
            case '\n': 
            case ',': 
            case '[': 
            case ']': 
            case '{': 
            case '}': {
                return true;
            }
        }
        return false;
    }

    private boolean isDelimiter(char c) {
        if (this.isTokenDelimiter(c)) {
            return true;
        }
        switch (c) {
            case '$': 
            case '.': {
                return false;
            }
        }
        return Pattern.matches("\\W", Character.toString(c));
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return this.NO_CONTEXTS;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return this.PROPOSAL_ACTIVATION_CHARS;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return this.PROPOSAL_ACTIVATION_CHARS;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public String getErrorMessage() {
        return "Error.";
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        String documentation = null;
        try {
            String keyword = textViewer.getDocument().get(hoverRegion.getOffset(), hoverRegion.getLength());
            int offset = hoverRegion.getOffset();
            IDocument document = textViewer.getDocument();
            if (this.getPrecedingToken((IDocument)document, (int)(offset - 1)).tokenString.equals(PROBE_KEYWORD.trim())) {
                documentation = ManpageCacher.getDocumentation(TapsetItemType.PROBE, keyword);
            } else {
                ITypedRegion partition = ((IDocumentExtension3)document).getPartition("__stp_probe_partitioning", offset, false);
                if (partition.getType() == "__stp_probe") {
                    if (this.isFunctionRegion(document, hoverRegion)) {
                        documentation = ManpageCacher.getDocumentation(TapsetItemType.FUNCTION, keyword);
                    } else {
                        String probe = this.getProbe(document, offset);
                        if (this.stpMetadataSingleton.isVariableInProbe(probe, keyword)) {
                            documentation = ManpageCacher.getDocumentation(TapsetItemType.PROBEVAR, probe, keyword);
                        }
                    }
                }
            }
        }
        catch (BadLocationException | BadPartitioningException throwable) {
            // empty catch block
        }
        return documentation;
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        try {
            return this.getCurrentToken(textViewer.getDocument(), offset);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    private static class Token
    implements IRegion {
        String tokenString;
        int offset;

        public Token(String string, int n) {
            this.tokenString = string;
            this.offset = n;
        }

        public int getLength() {
            return this.tokenString.length();
        }

        public int getOffset() {
            return this.offset;
        }
    }
}

