/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.ide.structures;

import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.IDEPlugin;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.structures.TapsetItemType;
import org.eclipse.linuxtools.man.parser.ManPage;
import org.eclipse.linuxtools.systemtap.ui.consolelog.internal.ConsoleLogPlugin;

public class ManpageCacher {
    private static final String SPLITTER = "::";
    private static final String NO_MAN_ENTRY = "No manual entry for ";
    private static HashMap<String, String> pages = new HashMap();

    public static boolean isEmptyDocumentation(String documentation) {
        return documentation != null && documentation.startsWith(NO_MAN_ENTRY);
    }

    private static String makeEmptyDocumentation(String element) {
        return NO_MAN_ENTRY + element;
    }

    public static synchronized void clear() {
        ManpageCacher.clear(TapsetItemType.values());
    }

    public static synchronized void clear(TapsetItemType ... types) {
        Iterator<String> keys = pages.keySet().iterator();
        block0: while (keys.hasNext()) {
            TapsetItemType[] tapsetItemTypeArray = types;
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                TapsetItemType type = tapsetItemTypeArray[n2];
                if (keys.next().startsWith(type.toString())) {
                    keys.remove();
                    continue block0;
                }
                ++n2;
            }
        }
    }

    public static synchronized String getDocumentation(TapsetItemType prefix, String ... elements) {
        String fullElement = ManpageCacher.createFullElement(prefix, elements);
        String documentation = pages.get(fullElement);
        if (documentation == null) {
            if (prefix == TapsetItemType.PROBEVAR) {
                ManpageCacher.getDocumentation(TapsetItemType.PROBE, elements[0]);
                documentation = pages.get(fullElement);
                if (documentation == null) {
                    documentation = ManpageCacher.makeEmptyDocumentation(fullElement);
                    pages.put(fullElement, documentation);
                }
                return documentation;
            }
            IPreferenceStore p = IDEPlugin.getDefault().getPreferenceStore();
            ManPage manpage = null;
            if (!p.getBoolean("RemoteProbes")) {
                manpage = new ManPage(fullElement);
            } else {
                p = ConsoleLogPlugin.getDefault().getPreferenceStore();
                String user = p.getString("scpuser");
                String host = p.getString("host");
                String password = p.getString("scppassword");
                manpage = new ManPage(fullElement, user, host, password);
            }
            documentation = manpage.getStrippedTextPage().toString();
            pages.put(fullElement, documentation);
            if (!ManpageCacher.isEmptyDocumentation(documentation) && prefix == TapsetItemType.PROBE) {
                ManpageCacher.getProbeVariableDocumentation(documentation, elements[0]);
            }
        }
        return documentation;
    }

    private static void getProbeVariableDocumentation(String documentation, String probe) {
        String[] sections = documentation.split("VALUES");
        if (sections.length > 1) {
            String variablesString = sections[1].split("CONTEXT|DESCRIPTION|SystemTap Tapset Reference")[0].trim();
            String[] variables = variablesString.split("\n");
            int i = 0;
            if (!variables[0].equals("None")) {
                while (i < variables.length) {
                    String variableName = variables[i].trim();
                    StringBuilder variableDocumentation = new StringBuilder();
                    ++i;
                    while (i < variables.length && !variables[i].isEmpty()) {
                        variableDocumentation.append(variables[i].trim());
                        variableDocumentation.append("\n");
                        ++i;
                    }
                    pages.put(ManpageCacher.createFullElement(TapsetItemType.PROBEVAR, probe, variableName), variableDocumentation.toString().trim());
                    ++i;
                }
            }
        }
    }

    private static String createFullElement(TapsetItemType prefix, String ... elements) {
        StringBuilder fullElement = new StringBuilder();
        fullElement.append(prefix.toString());
        String[] stringArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            fullElement.append(SPLITTER + element);
            ++n2;
        }
        return fullElement.toString();
    }
}

