/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.api.collection;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.php.composer.api.entities.AbstractJsonObject;
import org.eclipse.php.composer.api.json.ParseException;
import org.eclipse.php.composer.api.objects.Namespace;

public class Psr
extends AbstractJsonObject<Namespace>
implements Iterable<Namespace> {
    private transient PropertyChangeListener listener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Psr.this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
        }
    };

    public Psr() {
    }

    public Psr(String json) throws ParseException {
        this.fromJson(json);
    }

    @Override
    protected void doParse(Object obj) {
        this.clear();
        if (obj instanceof LinkedHashMap) {
            LinkedHashMap json = (LinkedHashMap)obj;
            for (Map.Entry entry : json.entrySet()) {
                Namespace nmspc = new Namespace();
                nmspc.setNamespace((String)entry.getKey());
                if (entry.getValue() instanceof LinkedList) {
                    for (Object path : (LinkedList)entry.getValue()) {
                        nmspc.add((String)path);
                    }
                } else {
                    nmspc.add((String)entry.getValue());
                }
                this.add(nmspc);
            }
        }
    }

    @Override
    protected Object buildJson() {
        LinkedHashMap<String, Object> out = new LinkedHashMap<String, Object>();
        for (Namespace nmspc : this) {
            Object value = "";
            if (nmspc.size() > 1) {
                value = this.getJsonValue(nmspc.getPaths());
            } else if (nmspc.size() == 1) {
                value = nmspc.getFirst();
            }
            out.put(nmspc.getNamespace(), value);
        }
        return out;
    }

    public void add(Namespace namespace) {
        if (this.has(namespace)) {
            ((Namespace)this.get(namespace.getNamespace())).addPaths(namespace.getPaths());
        } else {
            namespace.addPropertyChangeListener(this.listener);
            this.set(namespace.getNamespace(), namespace);
        }
    }

    public void remove(Namespace namespace) {
        namespace.removePropertyChangeListener(this.listener);
        super.remove(namespace.getNamespace());
    }

    public Collection<Namespace> getNamespaces() {
        return this.properties.values();
    }

    @Override
    public Iterator<Namespace> iterator() {
        return this.properties.values().iterator();
    }

    public Namespace getFirst() {
        if (this.properties.values().iterator().hasNext()) {
            return (Namespace)this.properties.values().iterator().next();
        }
        return null;
    }

    @Override
    public int size() {
        return this.properties.keySet().size();
    }

    @Override
    public boolean has(String namespace) {
        return this.properties.containsKey(namespace);
    }

    public boolean has(Namespace namespace) {
        return this.has(namespace.getNamespace());
    }

    public boolean hasPath(String path) {
        for (Namespace nmspc : this.properties.values()) {
            if (!nmspc.has(path)) continue;
            return true;
        }
        return false;
    }

    public Namespace getNamespaceForPath(String path) {
        for (Namespace nmspc : this.properties.values()) {
            if (!nmspc.has(path)) continue;
            return nmspc;
        }
        return null;
    }
}

