/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.ui.editor.composer;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.jface.fieldassist.AutoCompleteField;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.composer.api.ComposerConstants;
import org.eclipse.php.composer.ui.converter.Keywords2StringConverter;
import org.eclipse.php.composer.ui.converter.License2StringConverter;
import org.eclipse.php.composer.ui.converter.String2KeywordsConverter;
import org.eclipse.php.composer.ui.converter.String2LicenseConverter;
import org.eclipse.php.composer.ui.editor.ComboFormEntryAdapter;
import org.eclipse.php.composer.ui.editor.ComposerFormPage;
import org.eclipse.php.composer.ui.editor.ComposerSection;
import org.eclipse.php.composer.ui.editor.FormEntryAdapter;
import org.eclipse.php.composer.ui.editor.FormLayoutFactory;
import org.eclipse.php.composer.ui.editor.composer.LicenseContentAdapter;
import org.eclipse.php.composer.ui.editor.composer.Messages;
import org.eclipse.php.composer.ui.parts.ComboFormEntry;
import org.eclipse.php.composer.ui.parts.FormEntry;
import org.eclipse.php.composer.ui.parts.WeblinkFormEntry;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;

public class GeneralSection
extends ComposerSection {
    private FormEntry nameEntry;
    private FormEntry descriptionEntry;
    private FormEntry typeEntry;
    private FormEntry keywordsEntry;
    private FormEntry homepageEntry;
    private FormEntry licenseEntry;
    private ComboFormEntry minimumStabilityEntry;

    public GeneralSection(ComposerFormPage page, Composite parent) {
        super(page, parent, 128);
        this.createClient(this.getSection(), page.getManagedForm().getToolkit());
    }

    @Override
    protected void createClient(Section section, FormToolkit toolkit) {
        section.setText(Messages.GeneralSection_Title);
        section.setDescription(Messages.GeneralSection_Description);
        section.setLayoutData((Object)new TableWrapData(256));
        Composite client = toolkit.createComposite((Composite)section);
        client.setLayout((Layout)FormLayoutFactory.createSectionClientTableWrapLayout(false, 2));
        section.setClient((Control)client);
        this.createNameEntry(client, toolkit);
        this.createDescriptionEntry(client, toolkit);
        this.createTypeEntry(client, toolkit);
        this.createKeywordsEntry(client, toolkit);
        this.createHomepageEntry(client, toolkit);
        this.createLicenseEntry(client, toolkit);
        this.createStabilityEntry(client, toolkit);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.nameEntry.setEnabled(enabled);
        this.descriptionEntry.setEnabled(enabled);
        this.typeEntry.setEnabled(enabled);
        this.keywordsEntry.setEnabled(enabled);
        this.homepageEntry.setEnabled(enabled);
        this.licenseEntry.setEnabled(enabled);
        this.minimumStabilityEntry.setEditable(enabled);
    }

    private void createNameEntry(Composite client, FormToolkit toolkit) {
        this.nameEntry = new FormEntry(client, toolkit, Messages.GeneralSection_NameLabel, null, false);
        this.nameEntry.setValue(this.composerPackage.getName(), true);
        this.nameEntry.addFormEntryListener(new FormEntryAdapter(){

            @Override
            public void textValueChanged(FormEntry entry) {
                GeneralSection.this.composerPackage.set("name", (Object)entry.getValue());
            }
        });
        this.composerPackage.addPropertyChangeListener("name", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                GeneralSection.this.nameEntry.setValue(GeneralSection.this.composerPackage.getName(), true);
            }
        });
    }

    private void createDescriptionEntry(Composite client, FormToolkit toolkit) {
        this.descriptionEntry = new FormEntry(client, toolkit, Messages.GeneralSection_DescriptionLabel, null, false);
        this.descriptionEntry.setValue(this.composerPackage.getDescription(), true);
        this.descriptionEntry.addFormEntryListener(new FormEntryAdapter(){

            @Override
            public void textValueChanged(FormEntry entry) {
                GeneralSection.this.composerPackage.set("description", (Object)entry.getValue());
            }
        });
        this.composerPackage.addPropertyChangeListener("description", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                GeneralSection.this.descriptionEntry.setValue(GeneralSection.this.composerPackage.getDescription(), true);
            }
        });
    }

    private void createTypeEntry(Composite client, FormToolkit toolkit) {
        this.typeEntry = new FormEntry(client, toolkit, Messages.GeneralSection_TypeLabel, null, false);
        this.typeEntry.setValue(this.composerPackage.getType(), true);
        ControlDecoration decoration = new ControlDecoration((Control)this.typeEntry.getText(), 16512);
        FieldDecoration indicator = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_CONTENT_PROPOSAL");
        decoration.setImage(indicator.getImage());
        decoration.setDescriptionText(NLS.bind((String)Messages.GeneralSection_ContentAssistDecorationText, (Object)indicator.getDescription()));
        decoration.setShowOnlyOnFocus(true);
        new AutoCompleteField((Control)this.typeEntry.getText(), (IControlContentAdapter)new TextContentAdapter(), ComposerConstants.TYPES);
        this.typeEntry.addFormEntryListener(new FormEntryAdapter(){

            @Override
            public void textValueChanged(FormEntry entry) {
                GeneralSection.this.composerPackage.set("type", (Object)entry.getValue());
            }
        });
        this.composerPackage.addPropertyChangeListener("type", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                GeneralSection.this.typeEntry.setValue(GeneralSection.this.composerPackage.getType(), true);
            }
        });
    }

    private void createKeywordsEntry(Composite client, FormToolkit toolkit) {
        this.keywordsEntry = new FormEntry(client, toolkit, Messages.GeneralSection_KeywordsLabel, null, false);
        final Keywords2StringConverter converter = new Keywords2StringConverter();
        this.keywordsEntry.setValue(converter.convert(this.composerPackage.getKeywords()), true);
        this.keywordsEntry.addFormEntryListener(new FormEntryAdapter(){
            String2KeywordsConverter converter;

            @Override
            public void focusGained(FormEntry entry) {
                this.converter = new String2KeywordsConverter(GeneralSection.this.composerPackage);
            }

            @Override
            public void focusLost(FormEntry entry) {
                this.converter.convert(entry.getValue());
            }
        });
        this.composerPackage.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().startsWith("keywords")) {
                    GeneralSection.this.keywordsEntry.setValue(converter.convert(GeneralSection.this.composerPackage.getKeywords()), true);
                }
            }
        });
    }

    private void createHomepageEntry(Composite client, FormToolkit toolkit) {
        this.homepageEntry = new WeblinkFormEntry(client, toolkit, Messages.GeneralSection_HomepageLabel);
        this.homepageEntry.setValue(this.composerPackage.getHomepage());
        this.homepageEntry.addFormEntryListener(new FormEntryAdapter(){

            @Override
            public void textValueChanged(FormEntry entry) {
                GeneralSection.this.composerPackage.set("homepage", (Object)entry.getValue());
            }
        });
        this.composerPackage.addPropertyChangeListener("homepage", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                GeneralSection.this.homepageEntry.setValue(GeneralSection.this.composerPackage.getHomepage(), true);
            }
        });
    }

    private void createLicenseEntry(Composite client, FormToolkit toolkit) {
        this.licenseEntry = new FormEntry(client, toolkit, Messages.GeneralSection_LicenseLabel, null, false);
        ControlDecoration decoration = new ControlDecoration((Control)this.licenseEntry.getText(), 16512);
        FieldDecoration indicator = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_CONTENT_PROPOSAL");
        decoration.setImage(indicator.getImage());
        decoration.setDescriptionText(NLS.bind((String)Messages.GeneralSection_ContentAssistDecorationText, (Object)indicator.getDescription()));
        decoration.setShowOnlyOnFocus(true);
        new AutoCompleteField((Control)this.licenseEntry.getText(), (IControlContentAdapter)new LicenseContentAdapter(), ComposerConstants.LICENSES);
        final License2StringConverter converter = new License2StringConverter();
        this.licenseEntry.setValue(converter.convert(this.composerPackage.getLicense()), true);
        this.licenseEntry.addFormEntryListener(new FormEntryAdapter(){
            String2LicenseConverter converter;

            @Override
            public void focusGained(FormEntry entry) {
                this.converter = new String2LicenseConverter(GeneralSection.this.composerPackage);
            }

            @Override
            public void focusLost(FormEntry entry) {
                this.converter.convert(entry.getValue());
            }
        });
        this.composerPackage.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().startsWith("license")) {
                    GeneralSection.this.licenseEntry.setValue(converter.convert(GeneralSection.this.composerPackage.getLicense()), true);
                }
            }
        });
    }

    private void createStabilityEntry(Composite client, FormToolkit toolkit) {
        this.minimumStabilityEntry = new ComboFormEntry(client, toolkit, Messages.GeneralSection_MinimumStabilityLabel, 0x800008);
        this.minimumStabilityEntry.getComboPart().setItems(ComposerConstants.STABILITIES);
        this.minimumStabilityEntry.setValue(this.composerPackage.getMinimumStability(), true);
        this.minimumStabilityEntry.addComboFormEntryListener(new ComboFormEntryAdapter(){

            @Override
            public void selectionChanged(ComboFormEntry entry) {
                GeneralSection.this.composerPackage.set("minimum-stability", (Object)entry.getValue());
            }
        });
        this.composerPackage.addPropertyChangeListener("minimum-stability", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                GeneralSection.this.minimumStabilityEntry.setValue(GeneralSection.this.composerPackage.getMinimumStability(), true);
            }
        });
    }
}

