/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.ui.editor.toolbar;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.php.composer.ui.ComposerUIPluginImages;
import org.eclipse.php.composer.ui.editor.toolbar.Messages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class SearchControl
extends ControlContribution {
    private final IManagedForm managedForm;
    Text searchText;
    private List<ModifyListener> modifyListeners = new ArrayList<ModifyListener>();

    public SearchControl(String id, IManagedForm managedForm) {
        super(id);
        this.managedForm = managedForm;
    }

    public String getText() {
        return this.searchText.getText().trim();
    }

    protected Control createControl(Composite parent) {
        if (parent instanceof ToolBar) {
            parent.setCursor(null);
        }
        FormToolkit toolkit = this.managedForm.getToolkit();
        Composite composite = toolkit.createComposite(parent);
        GridLayout layout = new GridLayout(3, false);
        layout.verticalSpacing = 0;
        layout.marginWidth = 0;
        switch (Platform.getOS()) {
            case "linux": {
                layout.marginHeight = -2;
                break;
            }
            case "macosx": {
                layout.marginHeight = 1;
                break;
            }
            default: {
                layout.marginHeight = 0;
            }
        }
        composite.setLayout((Layout)layout);
        composite.setBackground(null);
        composite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label label = toolkit.createLabel(composite, Messages.SearchControl_SearchLabel);
        label.setBackground(null);
        this.searchText = toolkit.createText(composite, "", 0x800080);
        this.searchText.setData("textBorder", (Object)Boolean.TRUE);
        this.searchText.setLayoutData((Object)new GridData(200, -1));
        ToolBar cancelBar = new ToolBar(composite, 0x800000);
        final ToolItem clearToolItem = new ToolItem(cancelBar, 0);
        clearToolItem.setEnabled(false);
        clearToolItem.setImage(ComposerUIPluginImages.CLEAR.createImage());
        clearToolItem.setDisabledImage(ComposerUIPluginImages.CLEAR_DISABLED.createImage());
        clearToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchControl.this.searchText.setText("");
            }
        });
        this.searchText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                clearToolItem.setEnabled(SearchControl.this.searchText.getText().length() > 0);
                for (ModifyListener listener : SearchControl.this.modifyListeners) {
                    listener.modifyText(e);
                }
            }
        });
        toolkit.paintBordersFor(composite);
        return composite;
    }

    public void addModifyListener(ModifyListener listener) {
        if (!this.modifyListeners.contains(listener)) {
            this.modifyListeners.add(listener);
        }
    }
}

