/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.ui.wizard.project.template;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.AbstractDiscoveryItem;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.DiscoveryResources;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.php.composer.api.ComposerPackage;
import org.eclipse.php.composer.api.MinimalPackage;
import org.eclipse.php.composer.api.RepositoryPackage;
import org.eclipse.php.composer.api.collection.Versions;
import org.eclipse.php.composer.api.entities.JsonValue;
import org.eclipse.php.composer.api.packages.AsyncPackagistDownloader;
import org.eclipse.php.composer.api.packages.PackageListenerInterface;
import org.eclipse.php.composer.core.log.Logger;
import org.eclipse.php.composer.ui.ComposerUIPluginImages;
import org.eclipse.php.composer.ui.wizard.project.template.Messages;
import org.eclipse.php.composer.ui.wizard.project.template.PackageFilterChangedListener;
import org.eclipse.php.composer.ui.wizard.project.template.PackageFilterItem;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;

public class PackagistItem
extends AbstractDiscoveryItem<PackageFilterItem> {
    private MinimalPackage item;
    private Label nameLabel;
    private Label description;
    private Button downloadButton;
    private final PackageFilterItem filterItem;
    private Button favorButton;
    private Combo versionCombo;
    private boolean isLoadingVersions = false;
    private List<PackageFilterChangedListener> listeners = new ArrayList<PackageFilterChangedListener>();

    public PackagistItem(Composite parent, int style, DiscoveryResources resources, PackageFilterItem element) {
        super(parent, style, resources, (Object)element);
        this.filterItem = element;
        this.item = element.getPackage();
        this.createContent();
    }

    protected void refresh() {
    }

    private void createContent() {
        GridLayout layout = new GridLayout(4, false);
        layout.marginLeft = 7;
        layout.marginTop = 2;
        layout.marginBottom = 2;
        this.setLayout((Layout)layout);
        this.nameLabel = new Label((Composite)this, 0);
        GridDataFactory.fillDefaults().grab(true, false).span(4, 1).align(1, 0x1000000).applyTo((Control)this.nameLabel);
        this.nameLabel.setFont(this.resources.getSmallHeaderFont());
        this.nameLabel.setText(this.item.getName());
        this.description = new Label((Composite)this, 64);
        GridDataFactory.fillDefaults().grab(true, false).span(4, 1).applyTo((Control)this.description);
        String descriptionText = this.item.getDescription();
        int maxDescriptionLength = 162;
        if (descriptionText == null) {
            descriptionText = "";
        }
        if (descriptionText.length() > maxDescriptionLength) {
            descriptionText = descriptionText.substring(0, maxDescriptionLength);
        }
        this.description.setText(descriptionText.replaceAll("\\r\\n?|\\n", " "));
        this.createStatsPart();
        this.createSeparator();
        this.initializeListeners();
        this.initState();
    }

    protected void initState() {
        if (this.filterItem.isChecked()) {
            this.setBackground(this.resources.getGradientEndColor());
            if (this.filterItem.getVersions() != null) {
                this.loadVersionsFromCache();
            } else {
                this.loadVersionCombo();
            }
        } else {
            this.versionCombo.setVisible(false);
        }
    }

    protected void createStatsPart() {
        this.favorButton = new Button((Composite)this, 8);
        this.favorButton.setToolTipText(Messages.PackagistItem_FavoritesToolTipText);
        this.favorButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.favorButton.setImage(ComposerUIPluginImages.STAR.createImage());
        GridDataFactory.swtDefaults().align(0x1000000, 0x1000000).span(1, 2).applyTo((Control)this.favorButton);
        CLabel label = new CLabel((Composite)this, 0);
        this.versionCombo = new Combo((Composite)this, 8);
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).span(1, 2).hint(200, -1).applyTo((Control)this.versionCombo);
        this.downloadButton = new Button((Composite)this, 2);
        this.downloadButton.setToolTipText(Messages.PackagistItem_DownloadToolTipText);
        if (this.filterItem.isChecked()) {
            this.downloadButton.setSelection(true);
        }
        GridDataFactory.swtDefaults().align(1, 0x1000000).grab(true, false).span(1, 2).applyTo((Control)label);
        GridDataFactory.swtDefaults().align(1, 0x1000000).span(1, 2).applyTo((Control)this.downloadButton);
        JsonValue downloads = (JsonValue)this.item.get("downloads");
        JsonValue favorites = (JsonValue)this.item.get("favers");
        if (downloads != null && favorites != null) {
            label.setImage(ComposerUIPluginImages.DOWNLOAD.createImage());
            label.setText(String.valueOf(Messages.PackagistItem_InstallLabelText) + downloads.getAsString());
            this.downloadButton.setText(Messages.PackagistItem_DownloadLabelText);
            this.favorButton.setText(favorites.getAsString());
        }
    }

    protected void createSeparator() {
        Label separator = new Label((Composite)this, 258);
        GridDataFactory.fillDefaults().indent(0, 8).grab(true, false).span(4, 1).align(4, 1).applyTo((Control)separator);
    }

    protected void initializeListeners() {
        this.downloadButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean selected = PackagistItem.this.downloadButton.getSelection();
                PackagistItem.this.filterItem.setChecked(selected);
                for (PackageFilterChangedListener listener : PackagistItem.this.listeners) {
                    listener.filterChanged(PackagistItem.this.filterItem);
                }
            }
        });
        this.favorButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    IWebBrowser browser = PlatformUI.getWorkbench().getBrowserSupport().createBrowser(null);
                    browser.openURL(new URL(PackagistItem.this.item.getAsString("url")));
                }
                catch (Exception e1) {
                    Logger.logException((Throwable)e1);
                }
            }
        });
        this.versionCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PackagistItem.this.filterItem.setSelectedVersion(PackagistItem.this.versionCombo.getText());
                for (PackageFilterChangedListener listener : PackagistItem.this.listeners) {
                    listener.filterChanged(PackagistItem.this.filterItem);
                }
            }
        });
    }

    protected void loadVersionsFromCache() {
        if (!this.versionCombo.isDisposed()) {
            String[] versions = this.filterItem.getVersions();
            this.versionCombo.setItems(versions);
            int index = 0;
            String[] stringArray = versions;
            int n = versions.length;
            int n2 = 0;
            while (n2 < n) {
                String version = stringArray[n2];
                if (StringUtils.equals((CharSequence)version, (CharSequence)this.filterItem.getSelectedVersion())) {
                    this.versionCombo.select(index);
                    break;
                }
                ++index;
                ++n2;
            }
            if (index == versions.length && versions.length > 0) {
                this.versionCombo.select(0);
            }
            this.versionCombo.setVisible(true);
            if (this.versionCombo.getSelectionIndex() != -1) {
                this.filterItem.setSelectedVersion(this.versionCombo.getText());
            } else {
                this.filterItem.setSelectedVersion(null);
            }
        } else {
            this.filterItem.setSelectedVersion(null);
        }
        for (PackageFilterChangedListener listener : this.listeners) {
            listener.filterChanged(this.filterItem);
        }
    }

    protected void loadVersionCombo() {
        this.versionCombo.setItems(new String[]{Messages.PackagistItem_LoadingVersionsMessage});
        this.versionCombo.select(0);
        AsyncPackagistDownloader dl = new AsyncPackagistDownloader();
        dl.addPackageListener(new PackageListenerInterface(){

            public void errorOccured(Exception e) {
                PackagistItem.this.isLoadingVersions = false;
            }

            public void aborted(String url) {
                PackagistItem.this.isLoadingVersions = false;
            }

            public void packageLoaded(RepositoryPackage repositoryPackage) {
                final Versions versions = repositoryPackage.getVersions();
                final ArrayList<String> versionNames = new ArrayList<String>();
                for (Map.Entry version : versions) {
                    versionNames.add(((ComposerPackage)version.getValue()).getVersion());
                }
                PackagistItem.this.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        PackagistItem.this.filterItem.setVersions(versionNames.toArray(new String[versionNames.size()]));
                        PackagistItem.this.filterItem.setSelectedVersion(versions.getDefaultVersion());
                        PackagistItem.this.loadVersionsFromCache();
                    }
                });
                PackagistItem.this.isLoadingVersions = false;
            }
        });
        dl.loadPackage(this.item.getName());
        this.isLoadingVersions = true;
    }

    public void addFilterChangedListener(PackageFilterChangedListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }
}

