/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pmf.pim.data.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.pmf.pim.Application;
import org.eclipse.pmf.pim.DataAssocication;
import org.eclipse.pmf.pim.DataCollection;
import org.eclipse.pmf.pim.DataForm;
import org.eclipse.pmf.pim.DataFormFolder;
import org.eclipse.pmf.pim.DataInheritance;
import org.eclipse.pmf.pim.DataItem;
import org.eclipse.pmf.pim.ElementalDataForm;
import org.eclipse.pmf.pim.PMFFactory;
import org.eclipse.pmf.pim.data.DataModelManager;
import org.eclipse.pmf.pim.data.DataPackage;
import org.eclipse.pmf.pim.data.DataProperty;
import org.eclipse.pmf.pim.data.DataType;
import org.eclipse.pmf.pim.databinding.DataBinding;
import org.eclipse.pmf.pim.databinding.DataBindingLeaf;
import org.eclipse.pmf.pim.databinding.DatabindingFactory;
import org.eclipse.pmf.pim.ui.Label;
import org.eclipse.pmf.pim.ui.UiFactory;
import org.eclipse.pmf.pim.util.PMFUtil;

public abstract class DataModelManagerImpl
extends EObjectImpl
implements DataModelManager {
    protected DataModelManagerImpl() {
    }

    protected EClass eStaticClass() {
        return DataPackage.Literals.DATA_MODEL_MANAGER;
    }

    @Override
    public boolean isTargetFor(EObject type) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DataType getDataModelType(EObject type) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void loadFor(ElementalDataForm dataForm, DataType dataType) {
        Application application = PMFUtil.getApplication(this);
        for (DataProperty property : dataType.getProperties()) {
            DataItem dataItem;
            if (!(property instanceof DataProperty) || PMFUtil.hasRootPropertyItem(dataForm, property) || (dataItem = this.createDataItem(application, property)) == null) continue;
            dataForm.getChildren().add((Object)dataItem);
        }
        for (DataType superType : dataType.getSuperTypes()) {
            DataInheritance inheritance = PMFFactory.eINSTANCE.createDataInheritance();
            inheritance.setDataType(superType);
            DataBinding dataBinding = DatabindingFactory.eINSTANCE.createDataBinding();
            inheritance.setDataBinding(dataBinding);
            DataFormFolder dataFormFolder = (DataFormFolder)application.getDataFormFolders().get((Object)superType);
            if (dataFormFolder != null) {
                inheritance.setDataForm(dataFormFolder.getDefaultDataForm());
            }
            dataForm.getChildren().add((Object)inheritance);
        }
    }

    public void loadFor(DataForm dataForm, DataType dataType) {
    }

    protected DataItem createDataItem(Application application, DataProperty property) {
        if (application == null || property == null) {
            return null;
        }
        DataType propertType = property.getType();
        DataItem dataItem = null;
        if (!property.isMany()) {
            if (propertType.isPrimitive()) {
                dataItem = PMFFactory.eINSTANCE.createDataField();
            } else {
                DataAssocication reference = PMFFactory.eINSTANCE.createDataAssocication();
                DataFormFolder dataFormFolder = (DataFormFolder)application.getDataFormFolders().get((Object)propertType);
                reference.setDataType(propertType);
                reference.setDataForm(dataFormFolder.getDefaultDataForm());
                dataItem = reference;
            }
        } else {
            DataCollection collection = PMFFactory.eINSTANCE.createDataCollection();
            collection.setDataContextType(propertType);
            dataItem = collection;
        }
        DataBinding dataBinding = DatabindingFactory.eINSTANCE.createDataBinding();
        DataBindingLeaf path = DatabindingFactory.eINSTANCE.createDataBindingLeaf();
        dataItem.setDataBinding(dataBinding);
        path.setFeature(property);
        dataBinding.setPath(path);
        Label label = UiFactory.eINSTANCE.createLabel();
        label.setText(property.getName());
        label.setName(String.valueOf(dataItem.getName()) + "_label");
        dataItem.setLabel(label);
        return dataItem;
    }
}

