/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.news.impl.poll;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.fluent.Executor;
import org.eclipse.core.internal.net.ProxyManager;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.jdt.annotation.Nullable;

public final class Proxies {
    private static final String NTLM_SCHEME = "ntlm";
    private static final String DOUBLEBACKSLASH = "\\\\";
    private static final String ENV_USERDOMAIN = "USERDOMAIN";
    private static final String PROP_HTTP_AUTH_NTLM_DOMAIN = "http.auth.ntlm.domain";

    private Proxies() {
    }

    @Nullable
    public static String getUserDomain(String userName) {
        String domain = System.getProperty(PROP_HTTP_AUTH_NTLM_DOMAIN);
        if (domain != null) {
            return domain;
        }
        domain = System.getenv(ENV_USERDOMAIN);
        if (domain != null) {
            return domain;
        }
        if (StringUtils.contains((CharSequence)userName, (CharSequence)DOUBLEBACKSLASH)) {
            return StringUtils.substringBefore((String)userName, (String)DOUBLEBACKSLASH);
        }
        return null;
    }

    @Nullable
    public static String getWorkstation() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    @Nullable
    public static String getUserName(@Nullable String userName) {
        if (userName == null) {
            return null;
        }
        return StringUtils.contains((CharSequence)userName, (CharSequence)DOUBLEBACKSLASH) ? StringUtils.substringAfterLast((String)userName, (String)DOUBLEBACKSLASH) : userName;
    }

    @Nullable
    public static HttpHost getProxyHost(URI target) {
        return Proxies.getProxyHost(ProxyManager.getProxyManager(), target);
    }

    @VisibleForTesting
    @Nullable
    static HttpHost getProxyHost(IProxyService proxyService, URI target) {
        IProxyData proxy = Proxies.getProxyData(proxyService, target);
        if (proxy == null) {
            return null;
        }
        return new HttpHost(proxy.getHost(), proxy.getPort());
    }

    public static Executor proxyAuthentication(Executor executor, URI target) throws IOException {
        return Proxies.proxyAuthentication(ProxyManager.getProxyManager(), executor, target);
    }

    @VisibleForTesting
    static Executor proxyAuthentication(IProxyService proxyService, Executor executor, URI target) throws IOException {
        IProxyData proxy = Proxies.getProxyData(proxyService, target);
        if (proxy == null) {
            return executor;
        }
        String userId = proxy.getUserId();
        if (userId == null) {
            return executor;
        }
        String userName = Proxies.getUserName(userId);
        String password = proxy.getPassword();
        String workstation = Proxies.getWorkstation();
        String domain = Proxies.getUserDomain(userId);
        HttpHost proxyHost = new HttpHost(proxy.getHost(), proxy.getPort());
        return executor.auth(new AuthScope(proxyHost, AuthScope.ANY_REALM, NTLM_SCHEME), (Credentials)new NTCredentials(userName, password, workstation, domain)).auth(new AuthScope(proxyHost, AuthScope.ANY_REALM, AuthScope.ANY_SCHEME), (Credentials)new UsernamePasswordCredentials(userName, password));
    }

    @Nullable
    private static IProxyData getProxyData(IProxyService service, URI target) {
        if (target == null || service == null) {
            return null;
        }
        Object[] proxies = service.select(target);
        if (ArrayUtils.isEmpty((Object[])proxies)) {
            return null;
        }
        return proxies[0];
    }
}

