/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.editor.properties.sections.common;

import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.sirius.editor.editorPlugin.SiriusEditor;
import org.eclipse.sirius.editor.properties.ViewpointPropertySheetPage;
import org.eclipse.sirius.editor.properties.sections.common.AbstractViewpointPropertySection;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public abstract class AbstractRadioButtonPropertySection
extends AbstractViewpointPropertySection {
    protected Button[] button;
    protected CLabel nameLabel;
    protected Group group;
    protected Composite composite;
    protected boolean buttonGroup = true;

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        FormData data;
        if (aTabbedPropertySheetPage instanceof ViewpointPropertySheetPage) {
            super.createControls(parent, (ViewpointPropertySheetPage)aTabbedPropertySheetPage);
        } else {
            super.createControls(parent, aTabbedPropertySheetPage);
        }
        this.composite = this.getWidgetFactory().createFlatFormComposite(parent);
        List values = this.getChoiceOfValues();
        this.button = new Button[values.size()];
        int index = 0;
        if (this.buttonGroup) {
            this.group = this.getWidgetFactory().createGroup(this.composite, "");
            this.group.setLayout((Layout)new RowLayout(256));
            Iterator iterator = values.iterator();
            while (iterator.hasNext()) {
                String buttonText = this.getText(iterator.next());
                this.button[index] = this.getWidgetFactory().createButton((Composite)this.group, buttonText, 16);
                ++index;
            }
            data = new FormData();
            data.left = new FormAttachment(0, 232);
            data.top = new FormAttachment(0, 4);
            this.group.setLayoutData((Object)data);
            this.nameLabel = this.getWidgetFactory().createCLabel(this.composite, this.getLabelText());
            data = new FormData();
            data.left = new FormAttachment(0, 0);
            data.right = new FormAttachment((Control)this.group, -25);
            data.top = new FormAttachment((Control)this.group, 0, 0x1000000);
            this.nameLabel.setLayoutData((Object)data);
        } else {
            int buttonWidthPercentage = 100 / (values.size() + 1);
            Iterator iterator = values.iterator();
            while (iterator.hasNext()) {
                String buttonText = this.getText(iterator.next());
                this.button[index] = this.getWidgetFactory().createButton(this.composite, buttonText, 16);
                data = new FormData();
                if (index == 0) {
                    data.left = new FormAttachment(buttonWidthPercentage, 0);
                    data.right = new FormAttachment(2 * buttonWidthPercentage, 0);
                    data.top = new FormAttachment(0, 4);
                } else {
                    data.left = new FormAttachment((Control)this.button[index - 1], 0);
                    data.right = new FormAttachment((index + 2) * buttonWidthPercentage, 0);
                    data.top = new FormAttachment((Control)this.button[index - 1], 0, 0x1000000);
                }
                this.button[index].setLayoutData((Object)data);
                ++index;
            }
            this.nameLabel = this.getWidgetFactory().createCLabel(this.composite, this.getLabelText());
            data = new FormData();
            data.left = new FormAttachment(0, 0);
            data.right = new FormAttachment((Control)this.button[0], -5);
            data.top = new FormAttachment((Control)this.button[0], 0, 0x1000000);
            this.nameLabel.setLayoutData((Object)data);
        }
        int i = 0;
        while (i < this.button.length) {
            final int buttonIndex = i++;
            this.button[buttonIndex].addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AbstractRadioButtonPropertySection.this.handleSelectionChanged(buttonIndex);
                }
            });
        }
    }

    public void aboutToBeShown() {
        super.aboutToBeShown();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.composite, "org.eclipse.sirius." + this.eObject.eClass().getName());
    }

    @Override
    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        this.nameLabel.setText(this.getLabelText());
    }

    public void handleSelectionChanged(int index) {
        boolean equals = this.isEqual(index);
        if (!equals) {
            EditingDomain editingDomain = ((SiriusEditor)this.getPart()).getEditingDomain();
            Object value = this.getFeatureValue(index);
            if (this.eObjectList.size() == 1) {
                editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)editingDomain, (Object)this.eObject, (Object)this.getFeature(), (Object)value));
            } else {
                CompoundCommand compoundCommand = new CompoundCommand();
                for (EObject nextObject : this.eObjectList) {
                    compoundCommand.append(SetCommand.create((EditingDomain)editingDomain, (Object)nextObject, (Object)this.getFeature(), (Object)value));
                }
                editingDomain.getCommandStack().execute((Command)compoundCommand);
            }
        }
    }

    public void refresh() {
        if (this.getFeatureAsText() != null) {
            Button[] buttonArray = this.button;
            int n = this.button.length;
            int n2 = 0;
            while (n2 < n) {
                Button element = buttonArray[n2];
                if (element.getText().equalsIgnoreCase(this.getFeatureAsText())) {
                    element.setSelection(true);
                } else {
                    element.setSelection(false);
                }
                ++n2;
            }
        }
    }

    protected abstract List getChoiceOfValues();

    protected abstract boolean isEqual(int var1);

    @Override
    protected abstract EStructuralFeature getFeature();

    protected String getDefaultFeatureAsText() {
        String value = new String();
        if (this.eObject.eGet(this.getFeature()) != null) {
            value = this.eObject.eGet(this.getFeature()).toString();
        }
        return value;
    }

    protected String getText(Object object) {
        EStructuralFeature eFeature = this.getFeature();
        IItemPropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(eFeature);
        if (propertyDescriptor != null) {
            return propertyDescriptor.getLabelProvider((Object)this.eObject).getText(object);
        }
        return object.toString();
    }

    protected String getFeatureAsText() {
        EStructuralFeature eFeature = this.getFeature();
        IItemPropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(eFeature);
        if (propertyDescriptor != null) {
            return propertyDescriptor.getLabelProvider((Object)this.eObject).getText(this.eObject.eGet(eFeature));
        }
        return this.getDefaultFeatureAsText();
    }

    protected abstract Object getFeatureValue(int var1);

    protected abstract String getDefaultLabelText();

    protected String getLabelText() {
        EStructuralFeature eFeature;
        IItemPropertyDescriptor propertyDescriptor;
        if (this.eObject != null && (propertyDescriptor = this.getPropertyDescriptor(eFeature = this.getFeature())) != null) {
            return propertyDescriptor.getDisplayName((Object)this.eObject);
        }
        return this.getDefaultLabelText();
    }

    @Override
    protected void makeReadonly() {
        this.group.setEnabled(false);
    }

    @Override
    protected void makeWrittable() {
        this.group.setEnabled(true);
    }
}

