/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.editor.tools.internal.assist;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.bindings.Trigger;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalListener2;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.sirius.editor.properties.sections.description.eattributecustomization.EAttributeCustomizationAttributeNamePropertySection;
import org.eclipse.sirius.editor.tools.internal.assist.EStructuralFeatureContentProposal;
import org.eclipse.sirius.viewpoint.description.EAttributeCustomization;
import org.eclipse.sirius.viewpoint.description.style.StyleDescription;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.keys.IBindingService;

public class EAttributeCustomizationAttributeNameContentProposalProvider
implements IContentProposalProvider {
    private EAttributeCustomization eAttributeCustomization;

    public EAttributeCustomizationAttributeNameContentProposalProvider(EAttributeCustomization eAttributeCustomization) {
        this.eAttributeCustomization = eAttributeCustomization;
    }

    public IContentProposal[] getProposals(String contents, int position) {
        ArrayList<EStructuralFeatureContentProposal> proposals = new ArrayList<EStructuralFeatureContentProposal>();
        String incompleteText = contents.substring(0, position);
        EList appliedOn = this.eAttributeCustomization.getAppliedOn();
        ArrayList<EObject> styleDescriptionsToCustomize = new ArrayList<EObject>();
        for (EObject eObject : appliedOn) {
            if (!(eObject instanceof StyleDescription) && !(eObject.eContainer() instanceof StyleDescription)) continue;
            styleDescriptionsToCustomize.add(eObject);
        }
        Set<EAttribute> commonAttributes = this.getCommonEAttributeNames(styleDescriptionsToCustomize);
        for (EAttribute commonAttribute : commonAttributes) {
            if (commonAttribute.getName() == null || !commonAttribute.getName().startsWith(incompleteText)) continue;
            proposals.add(new EStructuralFeatureContentProposal((EStructuralFeature)commonAttribute, position));
        }
        return proposals.toArray(new IContentProposal[0]);
    }

    private Set<EAttribute> getCommonEAttributeNames(List<EObject> styleDescriptionsToCustomize) {
        LinkedHashSet<EAttribute> commonEAttributes = new LinkedHashSet<EAttribute>();
        Iterator<EObject> iterator = styleDescriptionsToCustomize.iterator();
        if (iterator.hasNext()) {
            EObject styleDescription = iterator.next();
            commonEAttributes.addAll((Collection<EAttribute>)styleDescription.eClass().getEAllAttributes());
            while (iterator.hasNext()) {
                styleDescription = iterator.next();
                Iterator commonAttributesIterator = commonEAttributes.iterator();
                while (commonAttributesIterator.hasNext()) {
                    EAttribute eAttribute = (EAttribute)commonAttributesIterator.next();
                    if (this.containsEAttributeOrAnotherWithSameName((List<EAttribute>)styleDescription.eClass().getEAllAttributes(), eAttribute)) continue;
                    commonAttributesIterator.remove();
                }
            }
        }
        return commonEAttributes;
    }

    private boolean containsEAttributeOrAnotherWithSameName(List<EAttribute> eAllAttributes, EAttribute eAttribute) {
        boolean containsEAttributeOrAnotherWithSameName = eAllAttributes.contains(eAttribute);
        if (!containsEAttributeOrAnotherWithSameName) {
            for (EAttribute currentEAttribute : eAllAttributes) {
                if (!currentEAttribute.getName().equals(eAttribute.getName()) || !currentEAttribute.getEType().equals(eAttribute.getEType())) continue;
                containsEAttributeOrAnotherWithSameName = true;
                break;
            }
        }
        return containsEAttributeOrAnotherWithSameName;
    }

    public static void bindCompletionProcessor(final EAttributeCustomizationAttributeNamePropertySection section, Text text) {
        IBindingService bindingService = (IBindingService)PlatformUI.getWorkbench().getService(IBindingService.class);
        TriggerSequence[] contentAssistBindings = bindingService.getActiveBindingsFor("org.eclipse.ui.edit.text.contentAssist.proposals");
        if (contentAssistBindings != null && contentAssistBindings.length > 0) {
            KeyStroke keyStroke = EAttributeCustomizationAttributeNameContentProposalProvider.getKeyStroke(contentAssistBindings[0]);
            ContentProposalAdapter adapter = new ContentProposalAdapter((Control)text, (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)new EAttributeCustomizationAttributeNameContentProposalProvider(section.getEAttributeCustomization()), keyStroke, null);
            adapter.addContentProposalListener(new IContentProposalListener2(){

                public void proposalPopupClosed(ContentProposalAdapter arg0) {
                    if (section != null) {
                        section.enableModelUpdating();
                    }
                }

                public void proposalPopupOpened(ContentProposalAdapter arg0) {
                    if (section != null) {
                        section.disableModelUpdating();
                    }
                }
            });
        }
    }

    private static KeyStroke getKeyStroke(TriggerSequence sequence) {
        Trigger[] triggerArray = sequence.getTriggers();
        int n = triggerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Trigger trigger = triggerArray[n2];
            if (trigger instanceof KeyStroke) {
                return (KeyStroke)trigger;
            }
            ++n2;
        }
        return null;
    }
}

