/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.grammar;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.tm4e.core.grammar.GrammarHelper;
import org.eclipse.tm4e.core.grammar.IGrammar;
import org.eclipse.tm4e.core.grammar.IGrammarRepository;
import org.eclipse.tm4e.core.grammar.ITokenizeLineResult;
import org.eclipse.tm4e.core.grammar.ITokenizeLineResult2;
import org.eclipse.tm4e.core.grammar.Injection;
import org.eclipse.tm4e.core.grammar.StackElement;
import org.eclipse.tm4e.core.internal.grammar.LineTokenizer;
import org.eclipse.tm4e.core.internal.grammar.LineTokens;
import org.eclipse.tm4e.core.internal.grammar.ScopeListElement;
import org.eclipse.tm4e.core.internal.grammar.ScopeMetadata;
import org.eclipse.tm4e.core.internal.grammar.ScopeMetadataProvider;
import org.eclipse.tm4e.core.internal.grammar.StackElementMetadata;
import org.eclipse.tm4e.core.internal.grammar.TokenizeLineResult;
import org.eclipse.tm4e.core.internal.grammar.TokenizeLineResult2;
import org.eclipse.tm4e.core.internal.grammar.parser.Raw;
import org.eclipse.tm4e.core.internal.matcher.Matcher;
import org.eclipse.tm4e.core.internal.matcher.MatcherWithPriority;
import org.eclipse.tm4e.core.internal.oniguruma.OnigString;
import org.eclipse.tm4e.core.internal.rule.IRuleFactory;
import org.eclipse.tm4e.core.internal.rule.IRuleFactoryHelper;
import org.eclipse.tm4e.core.internal.rule.Rule;
import org.eclipse.tm4e.core.internal.rule.RuleFactory;
import org.eclipse.tm4e.core.internal.types.IRawGrammar;
import org.eclipse.tm4e.core.internal.types.IRawRepository;
import org.eclipse.tm4e.core.internal.types.IRawRule;
import org.eclipse.tm4e.core.theme.IThemeProvider;
import org.eclipse.tm4e.core.theme.ThemeTrieElementRule;

public class Grammar
implements IGrammar,
IRuleFactoryHelper {
    private int _rootId;
    private int _lastRuleId;
    private final Map<Integer, Rule> _ruleId2desc;
    private final Map<String, IRawGrammar> _includedGrammars;
    private final IGrammarRepository _grammarRepository;
    private final IRawGrammar _grammar;
    private List<Injection> _injections;
    private final ScopeMetadataProvider _scopeMetadataProvider;

    public Grammar(IRawGrammar grammar, int initialLanguage, Map<String, Integer> embeddedLanguages, IGrammarRepository grammarRepository, IThemeProvider themeProvider) {
        this._scopeMetadataProvider = new ScopeMetadataProvider(initialLanguage, themeProvider, embeddedLanguages);
        this._rootId = -1;
        this._lastRuleId = 0;
        this._includedGrammars = new HashMap<String, IRawGrammar>();
        this._grammarRepository = grammarRepository;
        this._grammar = this.initGrammar(grammar, null);
        this._ruleId2desc = new HashMap<Integer, Rule>();
        this._injections = null;
    }

    public void onDidChangeTheme() {
        this._scopeMetadataProvider.onDidChangeTheme();
    }

    public ScopeMetadata getMetadataForScope(String scope) {
        return this._scopeMetadataProvider.getMetadataForScope(scope);
    }

    public List<Injection> getInjections() {
        if (this._injections == null) {
            Collection<String> injectionScopeNames;
            this._injections = new ArrayList<Injection>();
            Map<String, IRawRule> rawInjections = this._grammar.getInjections();
            if (rawInjections != null) {
                for (Map.Entry<String, IRawRule> injection : rawInjections.entrySet()) {
                    String expression = injection.getKey();
                    IRawRule rule = injection.getValue();
                    this.collectInjections(this._injections, expression, rule, this, this._grammar);
                }
            }
            if (this._grammarRepository != null && (injectionScopeNames = this._grammarRepository.injections(this._grammar.getScopeName())) != null) {
                injectionScopeNames.forEach(injectionScopeName -> {
                    String selector;
                    IRawGrammar injectionGrammar = this.getExternalGrammar((String)injectionScopeName);
                    if (injectionGrammar != null && (selector = injectionGrammar.getInjectionSelector()) != null) {
                        this.collectInjections(this._injections, selector, (IRawRule)((Object)injectionGrammar), this, injectionGrammar);
                    }
                });
            }
            Collections.sort(this._injections, (i1, i2) -> i1.priority - i2.priority);
        }
        if (this._injections.size() == 0) {
            return this._injections;
        }
        return this._injections;
    }

    private void collectInjections(List<Injection> result, String selector, IRawRule rule, IRuleFactoryHelper ruleFactoryHelper, IRawGrammar grammar) {
        Collection<MatcherWithPriority<List<String>>> matchers = Matcher.createMatchers(selector);
        int ruleId = RuleFactory.getCompiledRuleId(rule, ruleFactoryHelper, grammar.getRepository());
        for (MatcherWithPriority<List<String>> matcher : matchers) {
            result.add(new Injection(matcher.matcher, ruleId, grammar, matcher.priority));
        }
    }

    @Override
    public Rule registerRule(IRuleFactory factory) {
        int id = ++this._lastRuleId;
        Rule result = factory.create(id);
        this._ruleId2desc.put(id, result);
        return result;
    }

    @Override
    public Rule getRule(int patternId) {
        return this._ruleId2desc.get(patternId);
    }

    public IRawGrammar getExternalGrammar(String scopeName) {
        return this.getExternalGrammar(scopeName, null);
    }

    @Override
    public IRawGrammar getExternalGrammar(String scopeName, IRawRepository repository) {
        IRawGrammar rawIncludedGrammar;
        if (this._includedGrammars.containsKey(scopeName)) {
            return this._includedGrammars.get(scopeName);
        }
        if (this._grammarRepository != null && (rawIncludedGrammar = this._grammarRepository.lookup(scopeName)) != null) {
            this._includedGrammars.put(scopeName, this.initGrammar(rawIncludedGrammar, repository != null ? repository.getBase() : null));
            return this._includedGrammars.get(scopeName);
        }
        return null;
    }

    private IRawGrammar initGrammar(IRawGrammar grammar, IRawRule base) {
        if ((grammar = this.clone(grammar)).getRepository() == null) {
            ((Raw)grammar).setRepository(new Raw());
        }
        Raw self = new Raw();
        self.setPatterns(grammar.getPatterns());
        self.setName(grammar.getScopeName());
        grammar.getRepository().setSelf(self);
        if (base != null) {
            grammar.getRepository().setBase(base);
        } else {
            grammar.getRepository().setBase(grammar.getRepository().getSelf());
        }
        return grammar;
    }

    private IRawGrammar clone(IRawGrammar grammar) {
        return (IRawGrammar)((Raw)grammar).clone();
    }

    @Override
    public ITokenizeLineResult tokenizeLine(String lineText) {
        return this.tokenizeLine(lineText, null);
    }

    @Override
    public ITokenizeLineResult tokenizeLine(String lineText, StackElement prevState) {
        return (ITokenizeLineResult)this._tokenize(lineText, prevState, false);
    }

    @Override
    public ITokenizeLineResult2 tokenizeLine2(String lineText) {
        return this.tokenizeLine2(lineText, null);
    }

    @Override
    public ITokenizeLineResult2 tokenizeLine2(String lineText, StackElement prevState) {
        return (ITokenizeLineResult2)this._tokenize(lineText, prevState, true);
    }

    private <T> T _tokenize(String lineText, StackElement prevState, boolean emitBinaryTokens) {
        boolean isFirstLine;
        if (this._rootId == -1) {
            this._rootId = RuleFactory.getCompiledRuleId(this._grammar.getRepository().getSelf(), this, this._grammar.getRepository());
        }
        if (prevState == null || prevState.equals(StackElement.NULL)) {
            isFirstLine = true;
            ScopeMetadata rawDefaultMetadata = this._scopeMetadataProvider.getDefaultMetadata();
            ThemeTrieElementRule defaultTheme = rawDefaultMetadata.themeData.get(0);
            int defaultMetadata = StackElementMetadata.set(0, rawDefaultMetadata.languageId, rawDefaultMetadata.tokenType, defaultTheme.fontStyle, defaultTheme.foreground, defaultTheme.background);
            String rootScopeName = this.getRule(this._rootId).getName(null, null);
            ScopeMetadata rawRootMetadata = this._scopeMetadataProvider.getMetadataForScope(rootScopeName);
            int rootMetadata = ScopeListElement.mergeMetadata(defaultMetadata, null, rawRootMetadata);
            ScopeListElement scopeList = new ScopeListElement(null, rootScopeName, rootMetadata);
            prevState = new StackElement(null, this._rootId, -1, null, scopeList, scopeList);
        } else {
            isFirstLine = false;
            prevState.reset();
        }
        if (lineText.isEmpty() || lineText.charAt(lineText.length() - 1) != '\n') {
            lineText = String.valueOf(lineText) + '\n';
        }
        OnigString onigLineText = GrammarHelper.createOnigString(lineText);
        int lineLength = lineText.length();
        LineTokens lineTokens = new LineTokens(emitBinaryTokens, lineText, this._grammarRepository.getLogger());
        StackElement nextState = LineTokenizer._tokenizeString(this, onigLineText, isFirstLine, 0, prevState, lineTokens);
        if (emitBinaryTokens) {
            return (T)new TokenizeLineResult2(lineTokens.getBinaryResult(nextState, lineLength), nextState);
        }
        return (T)new TokenizeLineResult(lineTokens.getResult(nextState, lineLength), nextState);
    }

    @Override
    public String getName() {
        return this._grammar.getName();
    }

    @Override
    public String getScopeName() {
        return this._grammar.getScopeName();
    }

    @Override
    public Collection<String> getFileTypes() {
        return this._grammar.getFileTypes();
    }
}

