/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.rule;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.tm4e.core.internal.oniguruma.OnigScanner;
import org.eclipse.tm4e.core.internal.rule.ICompiledRule;
import org.eclipse.tm4e.core.internal.rule.IRuleRegistry;
import org.eclipse.tm4e.core.internal.rule.RegExpSource;

public class RegExpSourceList {
    private List<RegExpSource> _items = new ArrayList<RegExpSource>();
    private boolean _hasAnchors = false;
    private ICompiledRule _cached = null;
    private final RegExpSourceListAnchorCache _anchorCache = new RegExpSourceListAnchorCache();

    public void push(RegExpSource item) {
        this._items.add(item);
        this._hasAnchors = this._hasAnchors ? this._hasAnchors : item.hasAnchor;
    }

    public void unshift(RegExpSource item) {
        this._items.add(0, item);
        this._hasAnchors = this._hasAnchors ? this._hasAnchors : item.hasAnchor;
    }

    public int length() {
        return this._items.size();
    }

    public void setSource(int index, String newSource) {
        RegExpSource r = this._items.get(index);
        if (!r.source.equals(newSource)) {
            this._cached = null;
            this._anchorCache.A0_G0 = null;
            this._anchorCache.A0_G1 = null;
            this._anchorCache.A1_G0 = null;
            this._anchorCache.A1_G1 = null;
            r.setSource(newSource);
        }
    }

    public ICompiledRule compile(IRuleRegistry grammar, boolean allowA, boolean allowG) {
        if (!this._hasAnchors) {
            if (this._cached == null) {
                ArrayList<String> regexps = new ArrayList<String>();
                for (RegExpSource regExpSource : this._items) {
                    regexps.add(regExpSource.source);
                }
                this._cached = new ICompiledRule(this.createOnigScanner(regexps.toArray(new String[0])), this.getRules());
            }
            return this._cached;
        }
        if (this._anchorCache.A0_G0 == null) {
            ICompiledRule iCompiledRule = this._anchorCache.A0_G0 = !allowA && !allowG ? this._resolveAnchors(allowA, allowG) : null;
        }
        if (this._anchorCache.A0_G1 == null) {
            ICompiledRule iCompiledRule = this._anchorCache.A0_G1 = !allowA && allowG ? this._resolveAnchors(allowA, allowG) : null;
        }
        if (this._anchorCache.A1_G0 == null) {
            ICompiledRule iCompiledRule = this._anchorCache.A1_G0 = allowA && !allowG ? this._resolveAnchors(allowA, allowG) : null;
        }
        if (this._anchorCache.A1_G1 == null) {
            ICompiledRule iCompiledRule = this._anchorCache.A1_G1 = allowA && allowG ? this._resolveAnchors(allowA, allowG) : null;
        }
        if (allowA) {
            if (allowG) {
                return this._anchorCache.A1_G1;
            }
            return this._anchorCache.A1_G0;
        }
        if (allowG) {
            return this._anchorCache.A0_G1;
        }
        return this._anchorCache.A0_G0;
    }

    private ICompiledRule _resolveAnchors(boolean allowA, boolean allowG) {
        ArrayList<String> regexps = new ArrayList<String>();
        for (RegExpSource regExpSource : this._items) {
            regexps.add(regExpSource.resolveAnchors(allowA, allowG));
        }
        return new ICompiledRule(this.createOnigScanner(regexps.toArray(new String[0])), this.getRules());
    }

    private OnigScanner createOnigScanner(String[] regexps) {
        return new OnigScanner(regexps);
    }

    private Integer[] getRules() {
        ArrayList<Integer> ruleIds = new ArrayList<Integer>();
        for (RegExpSource item : this._items) {
            ruleIds.add(item.ruleId);
        }
        return ruleIds.toArray(new Integer[0]);
    }

    private class RegExpSourceListAnchorCache {
        public ICompiledRule A0_G0;
        public ICompiledRule A0_G1;
        public ICompiledRule A1_G0;
        public ICompiledRule A1_G1;

        private RegExpSourceListAnchorCache() {
        }
    }
}

