/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.theme.reader;

import java.io.InputStream;
import org.eclipse.tm4e.core.internal.parser.json.JSONPListParser;
import org.eclipse.tm4e.core.internal.parser.xml.XMLPListParser;
import org.eclipse.tm4e.core.internal.theme.reader.IThemeParser;
import org.eclipse.tm4e.core.internal.theme.reader.SyncThemeReader;
import org.eclipse.tm4e.core.theme.IRawTheme;

public class ThemeReader {
    public static final IThemeParser XML_PARSER = new IThemeParser(){
        private XMLPListParser<IRawTheme> parser = new XMLPListParser(true);

        @Override
        public IRawTheme parse(InputStream contents) throws Exception {
            return this.parser.parse(contents);
        }
    };
    public static final IThemeParser JSON_PARSER = new IThemeParser(){
        private JSONPListParser<IRawTheme> parser = new JSONPListParser(true);

        @Override
        public IRawTheme parse(InputStream contents) throws Exception {
            return this.parser.parse(contents);
        }
    };

    public static IRawTheme readThemeSync(String filePath, InputStream in) throws Exception {
        SyncThemeReader reader = new SyncThemeReader(in, ThemeReader.getThemeParser(filePath));
        return reader.load();
    }

    private static IThemeParser getThemeParser(String filePath) {
        if (filePath.endsWith(".json")) {
            return JSON_PARSER;
        }
        return XML_PARSER;
    }
}

