/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.userstorage.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.http.client.CookieStore;
import org.apache.http.client.fluent.Executor;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.fluent.Response;
import org.apache.http.impl.client.BasicCookieStore;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.userstorage.IStorageService;
import org.eclipse.userstorage.internal.Blob;
import org.eclipse.userstorage.internal.Codes;
import org.eclipse.userstorage.internal.Headers;
import org.eclipse.userstorage.internal.StorageProperties;
import org.eclipse.userstorage.internal.util.IOUtil;
import org.eclipse.userstorage.internal.util.JSONUtil;
import org.eclipse.userstorage.internal.util.ProxyUtil;
import org.eclipse.userstorage.internal.util.StringUtil;
import org.eclipse.userstorage.spi.Credentials;
import org.eclipse.userstorage.spi.ICredentialsProvider;
import org.eclipse.userstorage.util.ConflictException;
import org.eclipse.userstorage.util.NotFoundException;
import org.eclipse.userstorage.util.ProtocolException;

public abstract class Session
implements Headers,
Codes {
    public static final String APPLICATION_JSON = "application/json";
    public static final String USER_AGENT_ID = "uss/1.0.0";
    public static final String USER_AGENT_PROPERTY = String.valueOf(Session.class.getName()) + ".userAgent";
    public static final String NOT_FOUND_ETAG = "not_found";
    private static final int AUTHENTICATION_ATTEMPTS = 3;
    private static final boolean DEBUG = Boolean.getBoolean("org.eclipse.userstorage.session.debug");
    private final CookieStore cookieStore;
    private final Executor executor;
    protected final ICredentialsProvider credentialsProvider;
    protected final IStorageService service;

    protected Session(IStorageService service, ICredentialsProvider credentialsProvider) {
        this.service = service;
        this.credentialsProvider = credentialsProvider;
        this.cookieStore = new BasicCookieStore();
        this.executor = Executor.newInstance().cookieStore(this.cookieStore);
    }

    public IStorageService getService() {
        return this.service;
    }

    public void reset() {
        this.cookieStore.clear();
    }

    public Map<String, Map<String, Object>> retrieveProperties(final String applicationToken, int pageSize, int page) throws IOException {
        if (pageSize < 1 || pageSize > 100) {
            throw new IllegalArgumentException("pageSize=" + pageSize);
        }
        if (page < 1) {
            throw new IllegalArgumentException("page=" + page);
        }
        URI uri = StringUtil.newURI(this.getServiceURI(), String.valueOf(applicationToken) + "?pagesize=" + pageSize + "&page=" + page);
        return (Map)new RequestTemplate<Map<String, Map<String, Object>>>(this, uri){

            @Override
            protected Request prepareRequest() throws IOException {
                return this.configureRequest(Request.Get((URI)this.uri), this.uri);
            }

            @Override
            protected Map<String, Map<String, Object>> handleResponse(HttpResponse response, HttpEntity responseEntity) throws IOException {
                this.getStatusCode("GET", this.uri, response, 200);
                List array = (List)JSONUtil.parse(responseEntity.getContent(), null);
                HashMap<String, Map<String, Object>> result = new HashMap<String, Map<String, Object>>();
                for (Object element : array) {
                    Map map = (Map)element;
                    Object appToken = map.remove("application_token");
                    if (!applicationToken.equals(appToken)) {
                        StatusLine statusLine = response.getStatusLine();
                        String protocolVersion = statusLine == null ? "HTTP" : this.getProtocolVersion(statusLine);
                        throw new ProtocolException("GET", this.uri, protocolVersion, 444, "Bad Response : Wrong application token: " + appToken);
                    }
                    map.remove("url");
                    String key = (String)map.remove("key");
                    result.put(key, map);
                }
                return result;
            }
        }.send();
    }

    protected abstract URI getServiceURI();

    public InputStream retrieveBlob(String applicationToken, String key, final Map<String, String> properties, final boolean useETag) throws IOException {
        URI uri = StringUtil.newURI(this.getServiceURI(), String.valueOf(applicationToken) + "/" + key);
        return (InputStream)new RequestTemplate<InputStream>(this, uri){

            @Override
            protected Request prepareRequest() throws IOException {
                Request request = this.configureRequest(Request.Get((URI)this.uri), this.uri);
                if (useETag) {
                    String eTag = (String)properties.get("etag");
                    if (DEBUG) {
                        System.out.println("Retrieving etag = " + eTag);
                    }
                    if (!StringUtil.isEmpty(eTag)) {
                        request.setHeader("If-None-Match", "\"" + eTag + "\"");
                    }
                }
                return request;
            }

            @Override
            protected InputStream handleResponse(HttpResponse response, HttpEntity responseEntity) throws IOException {
                int statusCode = this.getStatusCode("GET", this.uri, response, 200, 304, 404);
                String eTag = Session.getETag(response);
                if (eTag != null) {
                    if (DEBUG) {
                        System.out.println("Retrieved etag = " + eTag);
                    }
                    properties.put("etag", eTag);
                }
                if (statusCode == 200) {
                    Map object = (Map)JSONUtil.parse(responseEntity.getContent(), "value");
                    InputStream stream = (InputStream)object.remove("value");
                    for (Map.Entry entry : object.entrySet()) {
                        Object value = entry.getValue();
                        properties.put((String)entry.getKey(), String.valueOf(value));
                    }
                    return stream;
                }
                if (statusCode == 304) {
                    return Blob.NOT_MODIFIED;
                }
                properties.clear();
                StatusLine statusLine = response.getStatusLine();
                throw new NotFoundException("GET", this.uri, this.getProtocolVersion(statusLine), statusLine.getReasonPhrase());
            }
        }.send();
    }

    public boolean updateBlob(String applicationToken, String key, final Map<String, String> properties, final InputStream in) throws IOException, ConflictException {
        URI uri = StringUtil.newURI(this.getServiceURI(), String.valueOf(applicationToken) + "/" + key);
        return (Boolean)new RequestTemplate<Boolean>(this, uri){

            @Override
            protected Request prepareRequest() throws IOException {
                Request request = this.configureRequest(Request.Put((URI)this.uri), this.uri);
                String eTag = (String)properties.get("etag");
                if (DEBUG) {
                    System.out.println("Updating etag = " + eTag);
                }
                if (!StringUtil.isEmpty(eTag)) {
                    request.setHeader("If-Match", "\"" + eTag + "\"");
                }
                this.body = JSONUtil.build(Collections.singletonMap("value", in));
                request.bodyStream(this.body);
                return request;
            }

            @Override
            protected Boolean handleResponse(HttpResponse response, HttpEntity responseEntity) throws IOException {
                String eTag = Session.getETag(response);
                int statusCode = this.getStatusCode("PUT", this.uri, response, 200, 201, 409);
                if (statusCode == 409) {
                    StatusLine statusLine = response.getStatusLine();
                    throw new ConflictException("PUT", this.uri, this.getProtocolVersion(statusLine), statusLine.getReasonPhrase(), eTag);
                }
                if (eTag == null) {
                    throw new ProtocolException("PUT", this.uri, this.getProtocolVersion(response.getStatusLine()), 444, "Bad Response : No ETag");
                }
                if (DEBUG) {
                    System.out.println("Updated etag = " + eTag);
                }
                properties.put("etag", eTag);
                if (statusCode == 201) {
                    return true;
                }
                return false;
            }
        }.send();
    }

    public boolean deleteBlob(String applicationToken, String key, final Map<String, String> properties) throws IOException, ConflictException {
        URI uri = StringUtil.newURI(this.getServiceURI(), String.valueOf(applicationToken) + "/" + key);
        boolean deleted = (Boolean)new RequestTemplate<Boolean>(this, uri){

            @Override
            protected Request prepareRequest() throws IOException {
                Request request = this.configureRequest(Request.Delete((URI)this.uri), this.uri);
                String eTag = (String)properties.get("etag");
                if (!StringUtil.isEmpty(eTag)) {
                    request.setHeader("If-Match", "\"" + eTag + "\"");
                }
                return request;
            }

            @Override
            protected Boolean handleResponse(HttpResponse response, HttpEntity responseEntity) throws IOException {
                int statusCode = this.getStatusCode("DELETE", this.uri, response, 204, 409, 404);
                String eTag = Session.getETag(response);
                if (statusCode == 409) {
                    StatusLine statusLine = response.getStatusLine();
                    throw new ConflictException("DELETE", this.uri, this.getProtocolVersion(statusLine), statusLine.getReasonPhrase(), eTag);
                }
                properties.put("etag", "<deleted_etag>");
                if (statusCode == 204) {
                    return true;
                }
                return false;
            }
        }.send();
        return deleted;
    }

    public static void debugRequest(Request request) {
        if (!DEBUG) {
            return;
        }
        System.out.println(Session.formatRequest(request));
    }

    public static String formatRequest(Request request) {
        try {
            StringBuilder builder = new StringBuilder();
            builder.append(request);
            builder.append('\n');
            Field f1 = Request.class.getDeclaredField("request");
            f1.setAccessible(true);
            Object o1 = f1.get(request);
            Field f2 = Class.forName("org.apache.http.message.AbstractHttpMessage").getDeclaredField("headergroup");
            f2.setAccessible(true);
            Object o2 = f2.get(o1);
            Field f3 = o2.getClass().getDeclaredField("headers");
            f3.setAccessible(true);
            List o3 = (List)f3.get(o2);
            for (Header header : o3) {
                builder.append(header);
                builder.append('\n');
            }
            return builder.toString();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return ex.toString();
        }
    }

    public static void debugResponse(HttpResponse response, long totalTime) {
        if (!DEBUG) {
            return;
        }
        System.out.print(Session.formatResponse(response, totalTime));
    }

    public static String formatResponse(HttpResponse response, long totalTime) {
        try {
            StringBuilder builder = new StringBuilder();
            builder.append(response.getStatusLine());
            builder.append('\n');
            Header[] headerArray = response.getAllHeaders();
            int n = headerArray.length;
            int n2 = 0;
            while (n2 < n) {
                Header header = headerArray[n2];
                builder.append(header);
                builder.append('\n');
                ++n2;
            }
            if (totalTime > 0L) {
                builder.append("X-Round-Trip: ");
                builder.append(totalTime);
                builder.append(" millis");
                builder.append('\n');
            }
            builder.append('\n');
            return builder.toString();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return ex.toString();
        }
    }

    public static void debugResponseEntity(HttpEntity responseEntity) throws IOException {
        if (DEBUG && responseEntity != null) {
            responseEntity.writeTo((OutputStream)System.out);
            System.out.println();
            System.out.println();
        }
    }

    private static String getETag(HttpResponse response) {
        String eTag;
        Header[] headers = response.getHeaders("ETag");
        if (headers != null && headers.length != 0 && !StringUtil.isEmpty(eTag = headers[0].getValue())) {
            return eTag.substring(1, eTag.length() - 1);
        }
        return null;
    }

    protected abstract Credentials authenticate(Credentials var1, boolean var2) throws IOException;

    protected final Credentials provideCredentials(Credentials credentials, boolean reauthentication) throws OperationCanceledException {
        block7: {
            if (credentials == null) {
                Semaphore semaphore = this.service.getAuthenticationSemaphore();
                try {
                    try {
                        semaphore.acquire();
                        credentials = this.credentialsProvider.provideCredentials(this.service, reauthentication);
                    }
                    catch (InterruptedException interruptedException) {
                        semaphore.release();
                        break block7;
                    }
                }
                catch (Throwable throwable) {
                    semaphore.release();
                    throw throwable;
                }
                semaphore.release();
            }
        }
        if (credentials == null) {
            throw new OperationCanceledException("No credentials provided");
        }
        return credentials;
    }

    protected Request configureRequest(Request request, URI uri) {
        String userAgent = System.getProperty(USER_AGENT_PROPERTY, USER_AGENT_ID);
        return request.viaProxy(ProxyUtil.getProxyHost(uri)).staleConnectionCheck(true).connectTimeout(StorageProperties.getProperty("org.eclipse.userstorage.connectTimeout", 3000)).socketTimeout(StorageProperties.getProperty("org.eclipse.userstorage.socketTimeout", 10000)).addHeader("User-Agent", userAgent).addHeader("Content-Type", APPLICATION_JSON).addHeader("Accept", APPLICATION_JSON);
    }

    protected HttpResponse sendRequest(Request request, URI uri) throws IOException {
        long start = System.currentTimeMillis();
        Session.debugRequest(request);
        Response result = ProxyUtil.proxyAuthentication(this.executor, uri).execute(request);
        HttpResponse response = result.returnResponse();
        Session.debugResponse(response, System.currentTimeMillis() - start);
        return response;
    }

    protected final int getStatusCode(String method, URI uri, HttpResponse response, int ... expectedStatusCodes) throws ProtocolException {
        StatusLine statusLine = response.getStatusLine();
        if (statusLine == null) {
            throw new ProtocolException(method, uri, this.getProtocolVersion(statusLine), 444, "Bad Response : No status line returned");
        }
        int statusCode = statusLine.getStatusCode();
        if (statusCode == 401) {
            this.reset();
        }
        int i = 0;
        while (i < expectedStatusCodes.length) {
            int expectedStatusCode = expectedStatusCodes[i];
            if (statusCode == expectedStatusCode) {
                return statusCode;
            }
            ++i;
        }
        throw new ProtocolException(method, uri, this.getProtocolVersion(statusLine), statusCode, statusLine.getReasonPhrase());
    }

    protected final String getProtocolVersion(StatusLine statusLine) {
        ProtocolVersion protocolVersion;
        if (statusLine != null && (protocolVersion = statusLine.getProtocolVersion()) != null) {
            return protocolVersion.toString();
        }
        return "HTTP";
    }

    public void close() {
        this.reset();
    }

    private abstract class RequestTemplate<T> {
        protected final URI uri;
        protected InputStream body;

        public RequestTemplate(URI uri) {
            this.uri = uri;
        }

        public final synchronized T send() throws IOException {
            int authenticationAttempts = 3;
            boolean reauthentication = false;
            Credentials credentials = Session.this.credentialsProvider.getCredentials(Session.this.service);
            if (credentials != null) {
                if (!Session.this.credentialsProvider.isValid(credentials)) {
                    credentials = null;
                } else {
                    ++authenticationAttempts;
                }
            }
            boolean authenticated = false;
            while (true) {
                this.body = null;
                HttpEntity responseEntity = null;
                try {
                    authenticated = false;
                    credentials = Session.this.authenticate(credentials, reauthentication);
                    authenticated = true;
                    Request request = this.prepareRequest();
                    request = Session.this.credentialsProvider.configureRequest(request, this.uri, credentials);
                    HttpResponse response = Session.this.sendRequest(request, this.uri);
                    IOUtil.closeSilent(this.body);
                    this.body = null;
                    responseEntity = response.getEntity();
                    T t = this.handleResponse(response, responseEntity);
                    return t;
                }
                catch (IOException ex) {
                    ProtocolException protocolException;
                    Session.debugResponseEntity(responseEntity);
                    if (ex instanceof ProtocolException && (protocolException = (ProtocolException)ex).getStatusCode() == 401) {
                        if (authenticated) {
                            Session.this.reset();
                            continue;
                        }
                        if (--authenticationAttempts > 0) {
                            reauthentication = true;
                            credentials = null;
                            continue;
                        }
                    }
                    throw ex;
                }
                finally {
                    IOUtil.closeSilent(this.body);
                    this.body = null;
                    continue;
                }
                break;
            }
        }

        protected abstract Request prepareRequest() throws IOException;

        protected abstract T handleResponse(HttpResponse var1, HttpEntity var2) throws IOException;
    }
}

