/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.databinding.ui.editor.contentproviders;

import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.wb.internal.core.databinding.ui.editor.contentproviders.ChooseClassConfiguration;
import org.eclipse.wb.internal.core.databinding.ui.editor.contentproviders.PropertyAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChooseClassAndPropertiesConfiguration
extends ChooseClassConfiguration {
    private String m_propertiesLabel;
    private boolean m_propertiesMultiChecked;
    private boolean m_showSelectionButtons = true;
    private boolean m_reorderMode;
    private IBaseLabelProvider m_propertiesLabelProvider;
    private LoadedPropertiesCheckedStrategy m_loadedPropertiesCheckedStrategy = LoadedPropertiesCheckedStrategy.First;
    private String m_propertiesErrorMessage;
    private final List<IPropertiesFilter> m_propertiesFilters = Lists.newArrayList();

    public ChooseClassAndPropertiesConfiguration() {
    }

    public ChooseClassAndPropertiesConfiguration(ChooseClassAndPropertiesConfiguration configuration) {
        super(configuration);
        this.m_propertiesLabel = configuration.m_propertiesLabel;
        this.m_propertiesMultiChecked = configuration.m_propertiesMultiChecked;
        this.m_reorderMode = configuration.m_reorderMode;
        this.m_propertiesLabelProvider = configuration.m_propertiesLabelProvider;
        this.m_loadedPropertiesCheckedStrategy = configuration.m_loadedPropertiesCheckedStrategy;
        this.m_propertiesErrorMessage = configuration.m_propertiesErrorMessage;
        this.m_propertiesFilters.addAll(configuration.m_propertiesFilters);
    }

    public final String getPropertiesLabel() {
        return this.m_propertiesLabel;
    }

    public final void setPropertiesLabel(String propertiesLabel) {
        this.m_propertiesLabel = propertiesLabel;
    }

    public final boolean isPropertiesMultiChecked() {
        return this.m_propertiesMultiChecked;
    }

    public final void setPropertiesMultiChecked(boolean multiChecked) {
        this.m_propertiesMultiChecked = multiChecked;
    }

    public final boolean isReorderMode() {
        return this.m_reorderMode;
    }

    public final void setReorderMode(boolean reorderMode) {
        this.m_reorderMode = reorderMode;
    }

    public boolean isShowSelectionButtons() {
        return this.m_showSelectionButtons;
    }

    public void setShowSelectionButtons(boolean showSelectionButtons) {
        this.m_showSelectionButtons = showSelectionButtons;
    }

    public final IBaseLabelProvider getPropertiesLabelProvider() {
        return this.m_propertiesLabelProvider;
    }

    public final void setPropertiesLabelProvider(IBaseLabelProvider labelProvider) {
        this.m_propertiesLabelProvider = labelProvider;
    }

    public LoadedPropertiesCheckedStrategy getLoadedPropertiesCheckedStrategy() {
        return this.m_loadedPropertiesCheckedStrategy;
    }

    public void setLoadedPropertiesCheckedStrategy(LoadedPropertiesCheckedStrategy checkedStrategy) {
        this.m_loadedPropertiesCheckedStrategy = checkedStrategy;
    }

    public final void addPropertiesFilter(IPropertiesFilter propertiesFilter) {
        this.m_propertiesFilters.add(propertiesFilter);
    }

    public final void removePropertiesFilter(IPropertiesFilter propertiesFilter) {
        this.m_propertiesFilters.remove(propertiesFilter);
    }

    public List<PropertyAdapter> filterProperties(Class<?> choosenClass, List<PropertyAdapter> properties) throws Exception {
        if (!this.m_propertiesFilters.isEmpty()) {
            for (IPropertiesFilter filter : this.m_propertiesFilters) {
                properties = filter.filterProperties(choosenClass, properties);
            }
        }
        return properties;
    }

    public final String getPropertiesErrorMessage() {
        return this.m_propertiesErrorMessage;
    }

    public final void setPropertiesErrorMessage(String errorMessage) {
        this.m_propertiesErrorMessage = errorMessage;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IPropertiesFilter {
        public List<PropertyAdapter> filterProperties(Class<?> var1, List<PropertyAdapter> var2) throws Exception;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LoadedPropertiesCheckedStrategy {
        None,
        First,
        Last,
        All;

    }
}

