/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.ui.internal.contentassist;

import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.TransformerException;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.xpath.core.util.XSLTXPathHelper;
import org.eclipse.wst.xml.xpath.ui.internal.contentassist.XPathTemplateCompletionProcessor;
import org.eclipse.wst.xml.xpath.ui.internal.templates.TemplateContextTypeIdsXPath;
import org.eclipse.wst.xsl.ui.internal.XSLUIPlugin;
import org.eclipse.wst.xsl.ui.internal.contentassist.XPathElementContentAssist;
import org.eclipse.wst.xsl.ui.internal.util.XSLPluginImageHelper;
import org.eclipse.wst.xsl.ui.provisional.contentassist.AbstractXSLContentAssistRequest;
import org.eclipse.wst.xsl.ui.provisional.contentassist.CustomCompletionProposal;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SelectAttributeContentAssist
extends AbstractXSLContentAssistRequest {
    protected static final String SELECT_ATTRIBUTE = "select";
    private static final String XPATH_GLOBAL_VARIABLES = "/xsl:stylesheet/xsl:variable";
    private static final String XPATH_GLOBAL_PARAMS = "/xsl:stylesheet/xsl:param";
    private static final String XPATH_LOCAL_VARIABLES = "ancestor::xsl:template/descendant::xsl:variable";
    private static final String XPATH_LOCAL_PARAMS = "ancestor::xsl:template/descendant::xsl:param";
    private XPathTemplateCompletionProcessor fTemplateProcessor = null;
    private List<String> fTemplateContexts = new ArrayList<String>();
    private static final byte[] XPATH_LOCK = new byte[0];

    public SelectAttributeContentAssist(Node node, IStructuredDocumentRegion documentRegion, ITextRegion completionRegion, int begin, int length, String filter, ITextViewer textViewer) {
        super(node, documentRegion, completionRegion, begin, length, filter, textViewer);
    }

    @Override
    public ArrayList<ICompletionProposal> getCompletionProposals() {
        this.proposals.clear();
        this.adjustXPathStart(SELECT_ATTRIBUTE);
        int offset = this.getReplacementBeginPosition();
        IDOMAttr attrNode = this.getAttribute(SELECT_ATTRIBUTE);
        this.matchString = this.extractXPathMatchString(attrNode, this.getRegion(), this.getReplacementBeginPosition());
        this.addSelectProposals((Element)this.getNode().getParentNode(), offset);
        return this.getAllCompletionProposals();
    }

    protected IDOMAttr getAttribute(String attrName) {
        return (IDOMAttr)((IDOMElement)this.getNode()).getAttributeNode(attrName);
    }

    protected void adjustXPathStart(String attrName) {
        IDOMElement elem = (IDOMElement)this.getNode();
        IDOMAttr xpathNode = (IDOMAttr)elem.getAttributeNode(attrName);
        if (xpathNode == null) {
            return;
        }
        String xpathString = xpathNode.getValue();
        if (xpathString.length() == 0) {
            return;
        }
        int startOffset = xpathNode.getValueRegionStartOffset();
        this.replacementLength = this.getReplacementBeginPosition() - startOffset;
    }

    protected String extractXPathMatchString(IDOMAttr node, ITextRegion aRegion, int offset) {
        String nodeValue;
        if (node == null || node.getValue().length() == 0) {
            return "";
        }
        if (this.matchString.length() < 1) {
            return this.matchString;
        }
        int column = offset - node.getValueRegionStartOffset() - 1;
        int seperatorPos = this.getXPathSeperatorPos(column, nodeValue = node.getValue());
        if (seperatorPos >= column) {
            return "";
        }
        return node.getValue().substring(seperatorPos, column);
    }

    protected int getXPathSeperatorPos(int column, String nodeValue) {
        char[] keyTokens = new char[]{'{', '/', '[', ']', '(', ')', ',', ' '};
        int seperatorPos = 0;
        String potentialMatchString = nodeValue.substring(0, column);
        int cnt = 0;
        while (cnt < keyTokens.length) {
            int keyPos = potentialMatchString.lastIndexOf(keyTokens[cnt]);
            if (keyPos >= 0 && keyPos <= column - 1) {
                seperatorPos = keyPos + 1;
            }
            ++cnt;
        }
        int axisPos = nodeValue.indexOf("::");
        if (axisPos > seperatorPos && axisPos <= column - 1) {
            seperatorPos = axisPos + 1;
        }
        return seperatorPos;
    }

    protected void addSelectProposals(Element rootElement, int offset) {
        this.addContentModelProposals(offset);
        this.addGlobalProposals(rootElement, offset - this.getMatchString().length());
        this.addLocalProposals(this.getNode(), offset - this.getMatchString().length());
        this.addTemplates(TemplateContextTypeIdsXPath.AXIS, offset);
        this.addTemplates(TemplateContextTypeIdsXPath.XPATH, offset);
        this.addTemplates(TemplateContextTypeIdsXPath.CUSTOM, offset);
        this.addTemplates(TemplateContextTypeIdsXPath.OPERATOR, offset);
    }

    private void addContentModelProposals(int offset) {
        XPathElementContentAssist xpathXMLproposals = new XPathElementContentAssist(this.node, this.documentRegion, this.getRegion(), offset - this.getMatchString().length(), this.getReplacementLength(), this.getMatchString(), this.textViewer);
        ArrayList<ICompletionProposal> xmlProposals = ((AbstractXSLContentAssistRequest)xpathXMLproposals).getCompletionProposals();
        this.proposals.addAll(xmlProposals);
    }

    protected void addTemplates(String context, int startOffset) {
        if (this.fTemplateContexts.contains(context) || this.getTemplateCompletionProcessor() == null) {
            return;
        }
        XPathTemplateCompletionProcessor processor = this.getTemplateCompletionProcessor();
        this.fTemplateContexts.add(context);
        processor.setContextType(context);
        ICompletionProposal[] proposals = processor.computeCompletionProposals(this.textViewer, startOffset);
        int i = 0;
        while (i < proposals.length) {
            ICompletionProposal proposal = proposals[i];
            if (this.matchString.length() > 0) {
                if (proposal.getDisplayString().startsWith(this.matchString)) {
                    this.addProposal(proposals[i]);
                }
            } else {
                this.addProposal(proposals[i]);
            }
            ++i;
        }
    }

    private void addLocalProposals(Node xpathnode, int offset) {
        this.addVariablesProposals(XPATH_LOCAL_VARIABLES, xpathnode, offset);
        this.addVariablesProposals(XPATH_LOCAL_PARAMS, xpathnode, offset);
    }

    private void addGlobalProposals(Node xpathnode, int offset) {
        this.addVariablesProposals(XPATH_GLOBAL_VARIABLES, xpathnode, offset);
        this.addVariablesProposals(XPATH_GLOBAL_PARAMS, xpathnode, offset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addVariablesProposals(String xpath, Node xpathnode, int offset) {
        byte[] byArray = XPATH_LOCK;
        synchronized (XPATH_LOCK) {
            try {
                NodeList nodes = XSLTXPathHelper.selectNodeList((Node)xpathnode, (String)xpath);
                if (!this.hasNodes(nodes)) {
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return;
                }
                int startLength = this.getCursorPosition() - offset;
                int nodecnt = 0;
                while (nodecnt < nodes.getLength()) {
                    Node node = nodes.item(nodecnt);
                    Node nameItem = node.getAttributes().getNamedItem("name");
                    if (nameItem != null) {
                        String variableName = "$" + nameItem.getNodeValue();
                        CustomCompletionProposal proposal = new CustomCompletionProposal(variableName, offset, 0, startLength + variableName.length(), XSLPluginImageHelper.getInstance().getImage("icons/full/variable.gif"), variableName, null, null, 0);
                        if (this.matchString.length() > 0) {
                            if (proposal.getDisplayString().startsWith(this.matchString)) {
                                this.addProposal((ICompletionProposal)proposal);
                            }
                        } else {
                            this.addProposal((ICompletionProposal)proposal);
                        }
                    }
                    ++nodecnt;
                }
            }
            catch (TransformerException ex) {
                XSLUIPlugin.log(ex);
            }
            return;
        }
    }

    private XPathTemplateCompletionProcessor getTemplateCompletionProcessor() {
        if (this.fTemplateProcessor == null) {
            this.fTemplateProcessor = new XPathTemplateCompletionProcessor();
        }
        return this.fTemplateProcessor;
    }
}

