/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom;

import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.AbstractProcessingInstruction;
import org.apache.batik.dom.StyleSheetFactory;
import org.apache.batik.dom.util.DOMUtilities;
import org.apache.batik.dom.util.HashTable;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.stylesheets.LinkStyle;
import org.w3c.dom.stylesheets.StyleSheet;

public class StyleSheetProcessingInstruction
extends AbstractProcessingInstruction
implements LinkStyle {
    protected boolean readonly;
    protected transient StyleSheet sheet;
    protected StyleSheetFactory factory;
    protected transient HashTable pseudoAttributes;

    protected StyleSheetProcessingInstruction() {
    }

    public StyleSheetProcessingInstruction(String string, AbstractDocument abstractDocument, StyleSheetFactory styleSheetFactory) {
        this.ownerDocument = abstractDocument;
        this.setData(string);
        this.factory = styleSheetFactory;
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public void setReadonly(boolean bl) {
        this.readonly = bl;
    }

    public void setNodeName(String string) {
    }

    public String getTarget() {
        return "xml-stylesheet";
    }

    public StyleSheet getSheet() {
        if (this.sheet == null) {
            this.sheet = this.factory.createStyleSheet(this, this.getPseudoAttributes());
        }
        return this.sheet;
    }

    public HashTable getPseudoAttributes() {
        if (this.pseudoAttributes == null) {
            this.pseudoAttributes = new HashTable();
            this.pseudoAttributes.put("alternate", "no");
            this.pseudoAttributes.put("media", "all");
            DOMUtilities.parseStyleSheetPIData(this.data, this.pseudoAttributes);
        }
        return this.pseudoAttributes;
    }

    public void setData(String string) throws DOMException {
        super.setData(string);
        this.sheet = null;
        this.pseudoAttributes = null;
    }

    protected Node newNode() {
        return new StyleSheetProcessingInstruction();
    }
}

