/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.cache;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import org.apache.derby.iapi.services.cache.ClassSizeCatalog;

public class ClassSize {
    public static final int refSize;
    private static final int objectOverhead = 2;
    private static final int booleanSize = 4;
    private static final int charSize = 4;
    private static final int shortSize = 4;
    private static final int intSize = 4;
    private static final int longSize = 8;
    private static final int floatSize = 4;
    private static final int doubleSize = 8;
    private static final int minObjectSize;
    private static boolean dummyCatalog;
    static boolean noGuess;
    static boolean unitTest;
    private static final int[] wildGuess;

    public static void setDummyCatalog() {
        dummyCatalog = true;
    }

    public static int getRefSize() {
        return refSize;
    }

    public static int getIntSize() {
        return 4;
    }

    public static int[] getSizeCoefficients(Class clazz) {
        int[] nArray = new int[]{0, 2};
        while (null != clazz) {
            Field[] fieldArray = clazz.getDeclaredFields();
            if (null != fieldArray) {
                for (int i = 0; i < fieldArray.length; ++i) {
                    if (Modifier.isStatic(fieldArray[i].getModifiers())) continue;
                    Class<?> clazz2 = fieldArray[i].getType();
                    if (clazz2.isArray() || !clazz2.isPrimitive()) {
                        nArray[1] = nArray[1] + 1;
                        continue;
                    }
                    String string = clazz2.getName();
                    if (string.equals("int") || string.equals("I")) {
                        nArray[0] = nArray[0] + 4;
                        continue;
                    }
                    if (string.equals("long") || string.equals("J")) {
                        nArray[0] = nArray[0] + 8;
                        continue;
                    }
                    if (string.equals("boolean") || string.equals("Z")) {
                        nArray[0] = nArray[0] + 4;
                        continue;
                    }
                    if (string.equals("short") || string.equals("S")) {
                        nArray[0] = nArray[0] + 4;
                        continue;
                    }
                    if (string.equals("byte") || string.equals("B")) {
                        nArray[0] = nArray[0] + 1;
                        continue;
                    }
                    if (string.equals("char") || string.equals("C")) {
                        nArray[0] = nArray[0] + 4;
                        continue;
                    }
                    if (string.equals("float") || string.equals("F")) {
                        nArray[0] = nArray[0] + 4;
                        continue;
                    }
                    if (string.equals("double") || string.equals("D")) {
                        nArray[0] = nArray[0] + 8;
                        continue;
                    }
                    nArray[1] = nArray[1] + 1;
                }
            }
            clazz = clazz.getSuperclass();
        }
        return nArray;
    }

    public static int estimateBaseFromCoefficients(int[] nArray) {
        int n = nArray[0] + nArray[1] * refSize;
        n = (n + 7) / 8;
        return (n *= 8) < minObjectSize ? minObjectSize : n;
    }

    public static int estimateBaseFromCatalog(Class clazz) {
        return ClassSize.estimateBaseFromCatalog(clazz, false);
    }

    private static int estimateBaseFromCatalog(Class<?> clazz, boolean bl) {
        if (dummyCatalog) {
            return 0;
        }
        ClassSizeCatalog classSizeCatalog = ClassSizeCatalog.getInstance();
        int[] nArray = (int[])classSizeCatalog.get(clazz.getName());
        if (nArray == null) {
            try {
                nArray = ClassSize.getSizeCoefficients(clazz);
            }
            catch (Throwable throwable) {
                if (noGuess) {
                    return -2;
                }
                nArray = wildGuess;
            }
            if (bl) {
                classSizeCatalog.put(clazz.getName(), nArray);
            }
        }
        return ClassSize.estimateBaseFromCoefficients(nArray);
    }

    public static int estimateAndCatalogBase(Class clazz) {
        return ClassSize.estimateBaseFromCatalog(clazz, true);
    }

    public static int estimateBase(Class clazz) {
        return ClassSize.estimateBaseFromCoefficients(ClassSize.getSizeCoefficients(clazz));
    }

    public static int estimateArrayOverhead() {
        return minObjectSize;
    }

    public static int estimateHashEntrySize() {
        return 2 + 3 * refSize;
    }

    public static int estimateMemoryUsage(String string) {
        if (null == string) {
            return 0;
        }
        return 2 * string.length();
    }

    private static final int fetchRefSizeFromSystemProperties() {
        String string = ClassSize.getSystemProperty("sun.arch.data.model");
        try {
            return new Integer(string) / 8;
        }
        catch (NumberFormatException numberFormatException) {
            String string2 = ClassSize.getSystemProperty("os.arch");
            if (string2 != null) {
                String[] stringArray = new String[]{"i386", "x86", "sparc"};
                if (Arrays.asList(stringArray).contains(string2)) {
                    return 4;
                }
                String[] stringArray2 = new String[]{"amd64", "x86_64", "sparcv9"};
                if (Arrays.asList(stringArray2).contains(string2)) {
                    return 8;
                }
            }
            return -1;
        }
    }

    private static final String getSystemProperty(final String string) {
        try {
            return AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty(string, null);
                }
            });
        }
        catch (SecurityException securityException) {
            return null;
        }
    }

    static {
        dummyCatalog = false;
        noGuess = false;
        unitTest = false;
        wildGuess = new int[]{0, 16};
        int n = ClassSize.fetchRefSizeFromSystemProperties();
        if (n < 4) {
            Runtime runtime = Runtime.getRuntime();
            runtime.gc();
            runtime.runFinalization();
            long l = runtime.totalMemory() - runtime.freeMemory();
            Object[] objectArray = new Object[10000];
            runtime.gc();
            runtime.runFinalization();
            long l2 = runtime.totalMemory() - runtime.freeMemory() - l;
            int n2 = (int)((l2 + (long)(objectArray.length / 2)) / (long)objectArray.length);
            n = 4 > n2 ? 4 : n2;
        }
        refSize = n;
        minObjectSize = 4 * refSize;
    }
}

